/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.reactive;

import ch.rasc.wamp2spring.WampError;
import ch.rasc.wamp2spring.config.Feature;
import ch.rasc.wamp2spring.config.Features;
import ch.rasc.wamp2spring.event.WampDisconnectEvent;
import ch.rasc.wamp2spring.event.WampSessionEstablishedEvent;
import ch.rasc.wamp2spring.message.AbortMessage;
import ch.rasc.wamp2spring.message.GoodbyeMessage;
import ch.rasc.wamp2spring.message.HelloMessage;
import ch.rasc.wamp2spring.message.WampMessage;
import ch.rasc.wamp2spring.message.WampMessageHeader;
import ch.rasc.wamp2spring.message.WampRole;
import ch.rasc.wamp2spring.message.WelcomeMessage;
import ch.rasc.wamp2spring.reactive.MessageChannelReactiveUtils;
import ch.rasc.wamp2spring.util.IdGenerator;
import com.fasterxml.jackson.core.JsonFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class WampWebSocketHandler
implements WebSocketHandler,
ApplicationEventPublisherAware {
    private static final Log logger = LogFactory.getLog(WampWebSocketHandler.class);
    public static final String JSON_PROTOCOL = "wamp.2.json";
    public static final String MSGPACK_PROTOCOL = "wamp.2.msgpack";
    public static final String CBOR_PROTOCOL = "wamp.2.cbor";
    public static final String SMILE_PROTOCOL = "wamp.2.smile";
    private static final List<String> supportedProtocols = Arrays.asList("wamp.2.msgpack", "wamp.2.json", "wamp.2.cbor", "wamp.2.smile");
    private final JsonFactory jsonFactory;
    private final JsonFactory msgpackFactory;
    private final JsonFactory cborFactory;
    private final JsonFactory smileFactory;
    private final List<WampRole> roles;
    private final ConcurrentMap<String, Long> webSocketId2WampSessionId = new ConcurrentHashMap<String, Long>();
    private final MessageChannel clientInboundChannel;
    private final MessageChannel clientOutboundChannel;
    private ApplicationEventPublisher applicationEventPublisher;

    public WampWebSocketHandler(JsonFactory jsonFactory, JsonFactory msgpackFactory, JsonFactory cborFactory, JsonFactory smileFactory, MessageChannel clientOutboundChannel, MessageChannel clientInboundChannel, Features features) {
        this.jsonFactory = jsonFactory;
        this.msgpackFactory = msgpackFactory;
        this.cborFactory = cborFactory;
        this.smileFactory = smileFactory;
        this.clientOutboundChannel = clientOutboundChannel;
        this.clientInboundChannel = clientInboundChannel;
        this.roles = new ArrayList<WampRole>();
        if (features.isEnabled(Feature.DEALER)) {
            WampRole dealer = new WampRole(Feature.DEALER.getExternalValue());
            for (Feature feature : features.enabledDealerFeatures()) {
                dealer.addFeature(feature.getExternalValue());
            }
            this.roles.add(dealer);
        }
        if (features.isEnabled(Feature.BROKER)) {
            WampRole broker = new WampRole(Feature.BROKER.getExternalValue());
            for (Feature feature : features.enabledBrokerFeatures()) {
                broker.addFeature(feature.getExternalValue());
            }
            this.roles.add(broker);
        }
    }

    public List<String> getSubProtocols() {
        return supportedProtocols;
    }

    public Mono<Void> handle(WebSocketSession session) {
        session.receive().doFinally(sig -> {
            Long wampSessionId = (Long)this.webSocketId2WampSessionId.get(session.getId());
            if (wampSessionId != null) {
                this.applicationEventPublisher.publishEvent((Object)new WampDisconnectEvent(wampSessionId, session.getId(), (Principal)session.getHandshakeInfo().getPrincipal().block()));
                this.webSocketId2WampSessionId.remove(session.getId());
            }
            session.close();
        }).subscribe(inMsg -> this.handleIncomingMessage((WebSocketMessage)inMsg, session));
        Publisher publisher = MessageChannelReactiveUtils.toPublisher(this.clientOutboundChannel);
        return session.send((Publisher)Flux.from(publisher).filter(msg -> WampWebSocketHandler.resolveSessionId(msg).equals(session.getId())).map(msg -> this.handleOutgoingMessage((Message<Object>)msg, session)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleIncomingMessage(WebSocketMessage inMsg, WebSocketSession session) {
        try {
            WampMessage wampMessage = null;
            if (inMsg.getType() == WebSocketMessage.Type.TEXT) {
                byte[] bytes = new byte[inMsg.getPayload().readableByteCount()];
                inMsg.getPayload().read(bytes);
                wampMessage = WampMessage.deserialize((JsonFactory)this.jsonFactory, (byte[])bytes);
            } else {
                if (inMsg.getType() != WebSocketMessage.Type.BINARY) return;
                ByteBuffer byteBuffer = inMsg.getPayload().asByteBuffer();
                String acceptedProtocol = session.getHandshakeInfo().getSubProtocol();
                if (acceptedProtocol != null) {
                    if (acceptedProtocol.equals(MSGPACK_PROTOCOL)) {
                        wampMessage = WampMessage.deserialize((JsonFactory)this.msgpackFactory, (byte[])byteBuffer.array());
                    } else if (acceptedProtocol.equals(SMILE_PROTOCOL)) {
                        wampMessage = WampMessage.deserialize((JsonFactory)this.smileFactory, (byte[])byteBuffer.array());
                    } else if (acceptedProtocol.equals(CBOR_PROTOCOL)) {
                        wampMessage = WampMessage.deserialize((JsonFactory)this.cborFactory, (byte[])byteBuffer.array());
                    }
                } else {
                    if (!logger.isErrorEnabled()) return;
                    logger.error((Object)("Deserialization failed because no accepted protocol " + inMsg + " in session " + session.getId()));
                    return;
                }
            }
            if (wampMessage == null) {
                if (!logger.isErrorEnabled()) return;
                logger.error((Object)("Deserialization failed for message " + inMsg + " in session " + session.getId()));
                return;
            }
            wampMessage.setHeader(WampMessageHeader.WEBSOCKET_SESSION_ID, (Object)session.getId());
            wampMessage.setHeader(WampMessageHeader.PRINCIPAL, session.getHandshakeInfo().getPrincipal().block());
            wampMessage.setHeader(WampMessageHeader.WAMP_SESSION_ID, this.webSocketId2WampSessionId.get(session.getId()));
            if (wampMessage instanceof HelloMessage) {
                if (wampMessage.getWampSessionId() != null) {
                    logger.error((Object)"HelloMessage received during running session");
                    session.close(CloseStatus.PROTOCOL_ERROR);
                }
                long newWampSessionId = IdGenerator.newRandomId(new HashSet(this.webSocketId2WampSessionId.values()));
                this.webSocketId2WampSessionId.put(session.getId(), newWampSessionId);
                WelcomeMessage welcomeMessage = new WelcomeMessage((HelloMessage)wampMessage, newWampSessionId, this.roles);
                this.clientOutboundChannel.send((Message)welcomeMessage);
                this.applicationEventPublisher.publishEvent((Object)new WampSessionEstablishedEvent((WampMessage)welcomeMessage));
                return;
            } else if (wampMessage instanceof AbortMessage) {
                session.close(CloseStatus.GOING_AWAY);
                return;
            } else if (wampMessage instanceof GoodbyeMessage) {
                GoodbyeMessage goodbyeMessage = new GoodbyeMessage(WampError.GOODBYE_AND_OUT);
                goodbyeMessage.setHeader(WampMessageHeader.WEBSOCKET_SESSION_ID, (Object)session.getId());
                this.clientOutboundChannel.send((Message)goodbyeMessage);
                return;
            } else {
                if (wampMessage.getWampSessionId() == null) {
                    logger.error((Object)"Session not established");
                    session.close(CloseStatus.PROTOCOL_ERROR);
                }
                this.clientInboundChannel.send((Message)wampMessage);
            }
            return;
        }
        catch (IOException e) {
            if (!logger.isErrorEnabled()) return;
            logger.error((Object)("Failed to parse " + inMsg + " in session " + session.getId()), (Throwable)e);
        }
    }

    private static String resolveSessionId(Message<?> message) {
        return (String)message.getHeaders().get((Object)WampMessageHeader.WEBSOCKET_SESSION_ID.name());
    }

    /*
     * Exception decompiling
     */
    public WebSocketMessage handleOutgoingMessage(Message<Object> message, WebSocketSession session) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String toString() {
        return "WampWebSocketHandler " + this.getSubProtocols();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    private static /* synthetic */ DataBuffer lambda$handleOutgoingMessage$4(ByteArrayOutputStream bos, DataBufferFactory factory) {
        return factory.wrap(bos.toByteArray());
    }
}

