/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.reactive;

import ch.rasc.wamp2spring.config.WampConfiguration;
import ch.rasc.wamp2spring.config.WampConfigurer;
import ch.rasc.wamp2spring.reactive.EnableReactiveWamp;
import ch.rasc.wamp2spring.reactive.WampReactiveConfigurer;
import ch.rasc.wamp2spring.reactive.WampWebSocketHandler;
import java.util.HashMap;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.messaging.MessageChannel;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.reactive.handler.SimpleUrlHandlerMapping;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.server.WebSocketService;
import org.springframework.web.reactive.socket.server.support.HandshakeWebSocketService;
import org.springframework.web.reactive.socket.server.support.WebSocketHandlerAdapter;

@Configuration
public class WampReactiveConfiguration
extends WampConfiguration
implements ImportAware {
    public void setImportMetadata(AnnotationMetadata importMetadata) {
        super.setImportMetadata(importMetadata, EnableReactiveWamp.class.getName());
    }

    @Bean
    public WampWebSocketHandler wampWebSocketHandler() {
        return new WampWebSocketHandler(this.jsonJsonFactory(), this.msgpackJsonFactory(), this.cborJsonFactory(), this.smileJsonFactory(), (MessageChannel)this.clientOutboundChannel(), (MessageChannel)this.clientInboundChannel(), this.features);
    }

    @Bean
    public HandlerMapping handlerMapping() {
        HashMap<String, WebSocketHandler> map = new HashMap<String, WebSocketHandler>();
        WampWebSocketHandler wampWebSocketHandler = this.wampWebSocketHandler();
        WebSocketHandler decoratedWebSocketHandler = this.decorateWebSocketHandler(wampWebSocketHandler);
        for (WampConfigurer wc : this.configurers) {
            if (!(wc instanceof WampReactiveConfigurer)) continue;
            decoratedWebSocketHandler = ((WampReactiveConfigurer)wc).decorateWebSocketHandler(decoratedWebSocketHandler);
        }
        map.put(this.getWebSocketHandlerPath(), decoratedWebSocketHandler);
        SimpleUrlHandlerMapping mapping = new SimpleUrlHandlerMapping();
        mapping.setUrlMap(map);
        mapping.setOrder(-1);
        this.configureHandlerMapping(mapping);
        for (WampConfigurer wc : this.configurers) {
            if (!(wc instanceof WampReactiveConfigurer)) continue;
            ((WampReactiveConfigurer)wc).configureHandlerMapping(mapping);
        }
        return mapping;
    }

    @Bean
    public WebSocketHandlerAdapter handlerAdapter() {
        return new WebSocketHandlerAdapter(this.webSocketService());
    }

    @Bean
    public WebSocketService webSocketService() {
        return new HandshakeWebSocketService();
    }

    protected void configureHandlerMapping(SimpleUrlHandlerMapping mapping) {
    }

    protected WebSocketHandler decorateWebSocketHandler(WebSocketHandler handler) {
        return handler;
    }
}

