/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.lang.Nullable;

public class CollectionHelper {
    @SafeVarargs
    @Nullable
    public static <T> List<T> toList(T ... arguments) {
        if (arguments != null) {
            if (arguments.length == 1) {
                return Collections.singletonList(arguments[0]);
            }
            if (arguments.length > 1) {
                return Arrays.asList(arguments);
            }
        }
        return null;
    }

    @Nullable
    public static <T> List<Object> toList(@Nullable Collection<T> collection) {
        if (collection != null) {
            if (collection instanceof List) {
                return (List)collection;
            }
            return new ArrayList<Object>(collection);
        }
        return null;
    }

    @Nullable
    public static Set<Long> toSet(@Nullable Collection<Long> collection) {
        if (collection != null) {
            if (collection instanceof Set) {
                return (Set)collection;
            }
            return new HashSet<Long>(collection);
        }
        return null;
    }
}

