/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.rpc;

import ch.rasc.wamp2spring.message.RegisterMessage;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Procedure {
    private final String procedure;
    private final String webSocketSessionId;
    private final boolean discloseCaller;
    private final long registrationId;
    private final Set<Long> pendingInvocations;

    public Procedure(RegisterMessage registerMessage, long registrationId, boolean isDealerCallerIdentificationFeatureEnabled) {
        this.procedure = registerMessage.getProcedure();
        this.webSocketSessionId = registerMessage.getWebSocketSessionId();
        this.discloseCaller = isDealerCallerIdentificationFeatureEnabled ? registerMessage.isDiscloseCaller() : false;
        this.registrationId = registrationId;
        this.pendingInvocations = ConcurrentHashMap.newKeySet();
    }

    public String getProcedure() {
        return this.procedure;
    }

    public String getWebSocketSessionId() {
        return this.webSocketSessionId;
    }

    public long getRegistrationId() {
        return this.registrationId;
    }

    public void addPendingInvocation(long requestId) {
        this.pendingInvocations.add(requestId);
    }

    public void removePendingInvocation(long requestId) {
        this.pendingInvocations.remove(requestId);
    }

    public Set<Long> getPendingInvocations() {
        return this.pendingInvocations;
    }

    public boolean isDiscloseCaller() {
        return this.discloseCaller;
    }

    public String toString() {
        return "Procedure [procedure=" + this.procedure + ", webSocketSessionId=" + this.webSocketSessionId + ", discloseCaller=" + this.discloseCaller + ", registrationId=" + this.registrationId + ", pendingInvocations=" + this.pendingInvocations + "]";
    }
}

