/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.pubsub;

import ch.rasc.wamp2spring.WampError;
import ch.rasc.wamp2spring.annotation.WampListener;
import ch.rasc.wamp2spring.config.Feature;
import ch.rasc.wamp2spring.config.Features;
import ch.rasc.wamp2spring.event.WampDisconnectEvent;
import ch.rasc.wamp2spring.event.WampSubscriptionCreatedEvent;
import ch.rasc.wamp2spring.event.WampSubscriptionDeletedEvent;
import ch.rasc.wamp2spring.event.WampSubscriptionSubscribedEvent;
import ch.rasc.wamp2spring.event.WampSubscriptionUnsubscribedEvent;
import ch.rasc.wamp2spring.message.ErrorMessage;
import ch.rasc.wamp2spring.message.EventMessage;
import ch.rasc.wamp2spring.message.PublishMessage;
import ch.rasc.wamp2spring.message.PublishedMessage;
import ch.rasc.wamp2spring.message.SubscribeMessage;
import ch.rasc.wamp2spring.message.SubscribedMessage;
import ch.rasc.wamp2spring.message.UnsubscribeMessage;
import ch.rasc.wamp2spring.message.UnsubscribedMessage;
import ch.rasc.wamp2spring.pubsub.EventListenerInfo;
import ch.rasc.wamp2spring.pubsub.EventStore;
import ch.rasc.wamp2spring.pubsub.MatchPolicy;
import ch.rasc.wamp2spring.pubsub.SubscribeResult;
import ch.rasc.wamp2spring.pubsub.Subscriber;
import ch.rasc.wamp2spring.pubsub.Subscription;
import ch.rasc.wamp2spring.pubsub.SubscriptionDetail;
import ch.rasc.wamp2spring.pubsub.SubscriptionRegistry;
import ch.rasc.wamp2spring.pubsub.UnsubscribeResult;
import ch.rasc.wamp2spring.util.HandlerMethodService;
import ch.rasc.wamp2spring.util.IdGenerator;
import ch.rasc.wamp2spring.util.InvocableHandlerMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.context.event.EventListener;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.handler.HandlerMethod;
import org.springframework.util.ClassUtils;

public class PubSubMessageHandler
implements MessageHandler,
SmartLifecycle,
InitializingBean,
ApplicationContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final SubscribableChannel clientInboundChannel;
    private final SubscribableChannel brokerChannel;
    private final MessageChannel clientOutboundChannel;
    private final SubscriptionRegistry subscriptionRegistry;
    private boolean autoStartup = true;
    private volatile boolean running = false;
    private final Object lifecycleMonitor = new Object();
    private ApplicationContext applicationContext;
    private final HandlerMethodService handlerMethodService;
    private final Features features;
    private final EventStore eventStore;

    public PubSubMessageHandler(SubscribableChannel clientInboundChannel, SubscribableChannel brokerChannel, MessageChannel clientOutboundChannel, SubscriptionRegistry subscriptionRegistry, HandlerMethodService handlerMethodService, Features features, EventStore eventStore) {
        this.clientInboundChannel = clientInboundChannel;
        this.brokerChannel = brokerChannel;
        this.clientOutboundChannel = clientOutboundChannel;
        this.subscriptionRegistry = subscriptionRegistry;
        this.handlerMethodService = handlerMethodService;
        this.features = features;
        this.eventStore = eventStore;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public int getPhase() {
        return Integer.MAX_VALUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.clientInboundChannel.subscribe((MessageHandler)this);
            this.brokerChannel.subscribe((MessageHandler)this);
            this.running = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.clientInboundChannel.unsubscribe((MessageHandler)this);
            this.brokerChannel.unsubscribe((MessageHandler)this);
            this.running = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(Runnable callback) {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            this.stop();
            callback.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunning() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    public void handleMessage(Message<?> message) {
        if (!this.running) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)(this + " not running yet. Ignoring " + message));
            }
            return;
        }
        if (message instanceof SubscribeMessage) {
            SubscribeMessage subscribeMessage = (SubscribeMessage)message;
            if (this.features.isDisabled(Feature.BROKER_PATTERN_BASED_SUBSCRIPTION) && subscribeMessage.getMatchPolicy() != MatchPolicy.EXACT) {
                this.sendMessageToClient(new ErrorMessage(subscribeMessage, WampError.OPTION_NOT_ALLOWED));
                return;
            }
            SubscribeResult result = this.subscriptionRegistry.subscribe(subscribeMessage);
            this.sendMessageToClient(new SubscribedMessage(subscribeMessage, result.getSubscription().getSubscriptionId()));
            this.sendSubscriptionEvents(result, subscribeMessage);
            if (subscribeMessage.isGetRetained()) {
                this.handleRetentionRequest(subscribeMessage, result.getSubscription());
            }
        } else if (message instanceof UnsubscribeMessage) {
            UnsubscribeMessage unsubscribeMessage = (UnsubscribeMessage)message;
            UnsubscribeResult result = this.subscriptionRegistry.unsubscribe(unsubscribeMessage);
            if (result.getError() == null) {
                this.sendMessageToClient(new UnsubscribedMessage(unsubscribeMessage));
                this.sendSubscriptionEvents(result, unsubscribeMessage);
            } else {
                this.sendMessageToClient(new ErrorMessage(unsubscribeMessage, result.getError()));
            }
        } else if (message instanceof PublishMessage) {
            PublishMessage publishMessage = (PublishMessage)message;
            if (publishMessage.isDiscloseMe() && this.features.isDisabled(Feature.BROKER_PUBLISHER_IDENTIFICATION)) {
                if (publishMessage.getWebSocketSessionId() != null) {
                    this.sendMessageToClient(new ErrorMessage(publishMessage, WampError.DISCLOSE_ME_DISALLOWED));
                }
                return;
            }
            long publicationId = IdGenerator.newRandomId(null);
            this.handlePublishMessage(publishMessage, publicationId);
            if (publishMessage.isAcknowledge()) {
                this.sendMessageToClient(new PublishedMessage(publishMessage, publicationId));
            }
            if (this.features.isEnabled(Feature.BROKER_EVENT_RETENTION) && publishMessage.isRetain()) {
                this.eventStore.retain(publishMessage);
            }
        }
    }

    private void handleRetentionRequest(SubscribeMessage subscribeMessage, Subscription subscription) {
        List<PublishMessage> retainedMessages = this.eventStore.getRetained(subscription.getTopicMatch());
        if (!retainedMessages.isEmpty()) {
            Subscriber subscriber = new Subscriber(subscribeMessage.getWebSocketSessionId(), subscribeMessage.getWampSessionId());
            for (PublishMessage retainedMessage : retainedMessages) {
                this.publishRetentionEvent(subscription, subscriber, retainedMessage);
            }
        }
    }

    private void publishRetentionEvent(Subscription subscription, Subscriber subscriber, PublishMessage publishMessage) {
        String topic = null;
        Long publisher = null;
        if (subscription.getMatchPolicy() != MatchPolicy.EXACT) {
            topic = publishMessage.getTopic();
        }
        if (publishMessage.isDiscloseMe()) {
            publisher = publishMessage.getWampSessionId();
        }
        if (this.isEligible(publishMessage, subscriber)) {
            EventMessage eventMessage = new EventMessage(subscriber.getWebSocketSessionId(), subscription.getSubscriptionId(), IdGenerator.newRandomId(null), topic, publisher, true, publishMessage);
            this.sendMessageToClient(eventMessage);
        }
    }

    @EventListener
    void handleDisconnectEvent(WampDisconnectEvent event) {
        List<UnsubscribeResult> results = this.subscriptionRegistry.removeWebSocketSessionId(event.getWebSocketSessionId(), event.getWampSessionId());
        for (UnsubscribeResult result : results) {
            this.sendSubscriptionEvents(result, event);
        }
    }

    private void sendSubscriptionEvents(SubscribeResult result, SubscribeMessage subscribeMessage) {
        SubscriptionDetail detail = new SubscriptionDetail(result.getSubscription());
        if (result.isCreated()) {
            this.applicationContext.publishEvent((Object)new WampSubscriptionCreatedEvent(subscribeMessage, detail));
        }
        this.applicationContext.publishEvent((Object)new WampSubscriptionSubscribedEvent(subscribeMessage, detail));
    }

    private void sendSubscriptionEvents(UnsubscribeResult result, UnsubscribeMessage unsubscribeMessage) {
        SubscriptionDetail detail = new SubscriptionDetail(result.getSubscription());
        this.applicationContext.publishEvent((Object)new WampSubscriptionUnsubscribedEvent(unsubscribeMessage, detail));
        if (result.isDeleted()) {
            this.applicationContext.publishEvent((Object)new WampSubscriptionDeletedEvent(unsubscribeMessage, detail));
        }
    }

    private void sendSubscriptionEvents(UnsubscribeResult result, WampDisconnectEvent event) {
        SubscriptionDetail detail = new SubscriptionDetail(result.getSubscription());
        this.applicationContext.publishEvent((Object)new WampSubscriptionUnsubscribedEvent(event, detail));
        if (result.isDeleted()) {
            this.applicationContext.publishEvent((Object)new WampSubscriptionDeletedEvent(event, detail));
        }
    }

    private void handlePublishMessage(PublishMessage publishMessage, long publicationId) {
        Set<Subscription> subscriptions = this.subscriptionRegistry.findSubscriptions(publishMessage.getTopic());
        if (subscriptions.size() > 0) {
            Long publisher = null;
            for (Subscription subscription : subscriptions) {
                List<InvocableHandlerMethod> eventListenerHandlerMethods;
                String topic = null;
                if (subscription.getMatchPolicy() != MatchPolicy.EXACT) {
                    topic = publishMessage.getTopic();
                }
                if (publishMessage.isDiscloseMe()) {
                    publisher = publishMessage.getWampSessionId();
                }
                for (Subscriber subscriber : subscription.getSubscribers()) {
                    if (!this.isEligible(publishMessage, subscriber)) continue;
                    EventMessage eventMessage = new EventMessage(subscriber.getWebSocketSessionId(), subscription.getSubscriptionId(), publicationId, topic, publisher, false, publishMessage);
                    this.sendMessageToClient(eventMessage);
                }
                if (publishMessage.getWebSocketSessionId() == null && (publishMessage.isExcludeMe() || this.features.isDisabled(Feature.BROKER_PUBLISHER_EXCLUSION)) || (eventListenerHandlerMethods = subscription.getEventListenerHandlerMethods()) == null) continue;
                EventMessage eventMessage = new EventMessage(null, -1L, publicationId, topic, publisher, false, publishMessage);
                for (InvocableHandlerMethod handlerMethod : eventListenerHandlerMethods) {
                    try {
                        this.handlerMethodService.invoke(eventMessage, handlerMethod);
                    }
                    catch (Exception e) {
                        if (!this.logger.isErrorEnabled()) continue;
                        this.logger.error((Object)("Error while invoking event message handler method " + (Object)((Object)handlerMethod)), (Throwable)e);
                    }
                }
            }
        }
    }

    private boolean isEligible(PublishMessage publishMessage, Subscriber subscriber) {
        String myWebSocketSessionId = publishMessage.getWebSocketSessionId();
        if ((publishMessage.isExcludeMe() || this.features.isDisabled(Feature.BROKER_PUBLISHER_EXCLUSION)) && myWebSocketSessionId != null && myWebSocketSessionId.equals(subscriber.getWebSocketSessionId())) {
            return false;
        }
        if (this.features.isEnabled(Feature.BROKER_SUBSCRIBER_BLACKWHITE_LISTING)) {
            if (publishMessage.getEligible() != null && !publishMessage.getEligible().contains(subscriber.getWampSessionId())) {
                return false;
            }
            if (publishMessage.getExclude() != null && publishMessage.getExclude().contains(subscriber.getWampSessionId())) {
                return false;
            }
        }
        return true;
    }

    protected void sendMessageToClient(Message<?> message) {
        try {
            this.clientOutboundChannel.send(message);
        }
        catch (Throwable ex) {
            this.logger.error((Object)("Failed to send " + message), ex);
        }
    }

    public void afterPropertiesSet() throws Exception {
        for (String beanName : this.applicationContext.getBeanNamesForType(Object.class)) {
            this.detectAnnotatedMethods(beanName);
        }
    }

    private void detectAnnotatedMethods(String beanName) {
        Class handlerType = this.applicationContext.getType(beanName);
        Class userType = ClassUtils.getUserClass((Class)handlerType);
        List<EventListenerInfo> eventListeners = this.detectEventListeners(beanName, userType);
        this.subscriptionRegistry.subscribeEventHandlers(eventListeners);
    }

    private List<EventListenerInfo> detectEventListeners(String beanName, Class<?> userType) {
        ArrayList<EventListenerInfo> registry = new ArrayList<EventListenerInfo>();
        Set methods = MethodIntrospector.selectMethods(userType, method -> AnnotationUtils.findAnnotation((Method)method, WampListener.class) != null);
        for (Method method2 : methods) {
            WampListener wampEventListenerAnnotation = (WampListener)AnnotationUtils.findAnnotation((Method)method2, WampListener.class);
            InvocableHandlerMethod handlerMethod = new InvocableHandlerMethod(new HandlerMethod(this.applicationContext.getBean(beanName), method2));
            String[] topics = (String[])AnnotationUtils.getValue((Annotation)wampEventListenerAnnotation);
            if (topics.length == 0) {
                topics = new String[]{beanName + "." + method2.getName()};
            }
            MatchPolicy match = (MatchPolicy)((Object)AnnotationUtils.getValue((Annotation)wampEventListenerAnnotation, (String)"match"));
            EventListenerInfo info = new EventListenerInfo(handlerMethod, topics, match);
            registry.add(info);
        }
        return registry;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

