/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.pubsub;

import ch.rasc.wamp2spring.config.DestinationMatch;
import ch.rasc.wamp2spring.message.PublishMessage;
import ch.rasc.wamp2spring.pubsub.EventStore;
import ch.rasc.wamp2spring.pubsub.MatchPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MemoryEventStore
implements EventStore {
    protected final Map<String, PublishMessage> eventRetention = new ConcurrentHashMap<String, PublishMessage>();

    @Override
    public void retain(PublishMessage publishMessage) {
        if (publishMessage.getWebSocketSessionId() == null) {
            this.eventRetention.put(publishMessage.getTopic(), publishMessage);
        }
    }

    @Override
    public List<PublishMessage> getRetained(DestinationMatch query) {
        if (query.getMatchPolicy() == MatchPolicy.EXACT) {
            PublishMessage publishMessage2 = this.eventRetention.get(query.getDestination());
            if (publishMessage2 != null) {
                return Collections.singletonList(publishMessage2);
            }
            return Collections.emptyList();
        }
        if (query.getMatchPolicy() == MatchPolicy.PREFIX) {
            ArrayList<PublishMessage> matchedMessages = new ArrayList<PublishMessage>();
            this.eventRetention.forEach((topic, publishMessage) -> {
                if (query.matches((String)topic)) {
                    matchedMessages.add((PublishMessage)publishMessage);
                }
            });
            return matchedMessages;
        }
        if (query.getMatchPolicy() == MatchPolicy.WILDCARD) {
            ArrayList<PublishMessage> matchedMessages = new ArrayList<PublishMessage>();
            this.eventRetention.forEach((topic, publishMessage) -> {
                if (query.matches((String)topic)) {
                    matchedMessages.add((PublishMessage)publishMessage);
                }
            });
            return matchedMessages;
        }
        return Collections.emptyList();
    }
}

