/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.message;

import ch.rasc.wamp2spring.message.WampMessage;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;

public class UnsubscribeMessage
extends WampMessage {
    static final int CODE = 34;
    private final long requestId;
    private final long subscriptionId;

    public UnsubscribeMessage(long requestId, long subscriptionId) {
        super(34);
        this.requestId = requestId;
        this.subscriptionId = subscriptionId;
    }

    public static UnsubscribeMessage deserialize(JsonParser jp) throws IOException {
        jp.nextToken();
        long request = jp.getLongValue();
        jp.nextToken();
        long subscription = jp.getLongValue();
        return new UnsubscribeMessage(request, subscription);
    }

    @Override
    public void serialize(JsonGenerator generator) throws IOException {
        generator.writeNumber(this.getCode());
        generator.writeNumber(this.requestId);
        generator.writeNumber(this.subscriptionId);
    }

    public long getRequestId() {
        return this.requestId;
    }

    public long getSubscriptionId() {
        return this.subscriptionId;
    }

    public String toString() {
        return "UnsubscribeMessage [requestId=" + this.requestId + ", subscriptionId=" + this.subscriptionId + "]";
    }
}

