/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.message;

import ch.rasc.wamp2spring.message.WampMessage;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;

public class UnregisterMessage
extends WampMessage {
    static final int CODE = 66;
    private final long requestId;
    private final long registrationId;

    public UnregisterMessage(long requestId, long registrationId) {
        super(66);
        this.requestId = requestId;
        this.registrationId = registrationId;
    }

    public static UnregisterMessage deserialize(JsonParser jp) throws IOException {
        jp.nextToken();
        long request = jp.getLongValue();
        jp.nextToken();
        long registration = jp.getLongValue();
        return new UnregisterMessage(request, registration);
    }

    @Override
    public void serialize(JsonGenerator generator) throws IOException {
        generator.writeNumber(this.getCode());
        generator.writeNumber(this.requestId);
        generator.writeNumber(this.registrationId);
    }

    public long getRequestId() {
        return this.requestId;
    }

    public long getRegistrationId() {
        return this.registrationId;
    }

    public String toString() {
        return "UnregisterMessage [requestId=" + this.requestId + ", registrationId=" + this.registrationId + "]";
    }
}

