/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.message;

import ch.rasc.wamp2spring.message.SubscribeMessage;
import ch.rasc.wamp2spring.message.WampMessage;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;

public class SubscribedMessage
extends WampMessage {
    static final int CODE = 33;
    private final long requestId;
    private final long subscriptionId;

    public SubscribedMessage(long requestId, long subscriptionId) {
        super(33);
        this.requestId = requestId;
        this.subscriptionId = subscriptionId;
    }

    public SubscribedMessage(SubscribeMessage subscribeMessage, long subscriptionId) {
        this(subscribeMessage.getRequestId(), subscriptionId);
        this.setReceiver(subscribeMessage);
    }

    public static SubscribedMessage deserialize(JsonParser jp) throws IOException {
        jp.nextToken();
        long request = jp.getLongValue();
        jp.nextToken();
        long subscription = jp.getLongValue();
        return new SubscribedMessage(request, subscription);
    }

    @Override
    public void serialize(JsonGenerator generator) throws IOException {
        generator.writeNumber(this.getCode());
        generator.writeNumber(this.requestId);
        generator.writeNumber(this.subscriptionId);
    }

    public long getRequestId() {
        return this.requestId;
    }

    public long getSubscriptionId() {
        return this.subscriptionId;
    }

    public String toString() {
        return "SubscribedMessage [requestId=" + this.requestId + ", subscriptionId=" + this.subscriptionId + "]";
    }
}

