/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.message;

import ch.rasc.wamp2spring.WampError;
import ch.rasc.wamp2spring.message.ParserUtil;
import ch.rasc.wamp2spring.message.WampMessage;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.Map;
import org.springframework.lang.Nullable;

public class GoodbyeMessage
extends WampMessage {
    static final int CODE = 6;
    @Nullable
    private final String message;
    private final String reason;

    public GoodbyeMessage(WampError reason, @Nullable String message) {
        this(reason.getExternalValue(), message);
    }

    public GoodbyeMessage(WampError reason) {
        this(reason.getExternalValue(), null);
    }

    private GoodbyeMessage(String reason, @Nullable String message) {
        super(6);
        this.message = message;
        this.reason = reason;
    }

    public static GoodbyeMessage deserialize(JsonParser jp) throws IOException {
        String msg = null;
        jp.nextToken();
        Map<String, Object> details = ParserUtil.readObject(jp);
        if (details != null) {
            msg = (String)details.get("message");
        }
        jp.nextToken();
        return new GoodbyeMessage(jp.getValueAsString(), msg);
    }

    @Override
    public void serialize(JsonGenerator generator) throws IOException {
        generator.writeNumber(this.getCode());
        generator.writeStartObject();
        if (this.message != null) {
            generator.writeStringField("message", this.message);
        }
        generator.writeEndObject();
        generator.writeString(this.reason);
    }

    public String getReason() {
        return this.reason;
    }

    @Nullable
    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return "GoodbyeMessage [message=" + this.message + ", reason=" + this.reason + "]";
    }
}

