/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.config;

import ch.rasc.wamp2spring.WampPublisher;
import ch.rasc.wamp2spring.config.Feature;
import ch.rasc.wamp2spring.config.Features;
import ch.rasc.wamp2spring.config.NoOpMessageHandler;
import ch.rasc.wamp2spring.config.WampConfigurer;
import ch.rasc.wamp2spring.pubsub.EventStore;
import ch.rasc.wamp2spring.pubsub.MemoryEventStore;
import ch.rasc.wamp2spring.pubsub.PubSubMessageHandler;
import ch.rasc.wamp2spring.pubsub.SubscriptionRegistry;
import ch.rasc.wamp2spring.rpc.ProcedureRegistry;
import ch.rasc.wamp2spring.rpc.RpcMessageHandler;
import ch.rasc.wamp2spring.util.HandlerMethodService;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.msgpack.jackson.dataformat.MessagePackFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.lang.Nullable;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.support.AbstractMessageChannel;
import org.springframework.messaging.support.ExecutorSubscribableChannel;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.util.CollectionUtils;

public class WampConfiguration {
    @Nullable
    protected ConversionService internalConversionService;
    protected final List<WampConfigurer> configurers = new ArrayList<WampConfigurer>();
    protected final Features features = new Features();
    @Autowired(required=false)
    private EventStore eventStore;

    @Autowired(required=false)
    public void setConfigurers(List<WampConfigurer> configurers) {
        if (!CollectionUtils.isEmpty(configurers)) {
            this.configurers.addAll(configurers);
            this.configureFeatures(this.features);
            for (WampConfigurer wc : this.configurers) {
                wc.configureFeatures(this.features);
            }
        }
    }

    protected void configureFeatures(Features features) {
    }

    protected void setImportMetadata(AnnotationMetadata importMetadata, String enableClassName) {
        Feature[] disableFeatures;
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(enableClassName, false));
        if (attributes != null && (disableFeatures = (Feature[])attributes.get("disable")) != null) {
            for (Feature disableFeature : disableFeatures) {
                this.features.disable(disableFeature);
            }
        }
    }

    @Bean
    public JsonFactory jsonJsonFactory() {
        return new ObjectMapper().getFactory();
    }

    @Bean
    public JsonFactory msgpackJsonFactory() {
        return new ObjectMapper((JsonFactory)new MessagePackFactory()).getFactory();
    }

    @Bean
    public JsonFactory cborJsonFactory() {
        return new ObjectMapper((JsonFactory)new CBORFactory()).getFactory();
    }

    @Bean
    public JsonFactory smileJsonFactory() {
        return new ObjectMapper((JsonFactory)new SmileFactory()).getFactory();
    }

    protected String getWebSocketHandlerPath() {
        return "/wamp";
    }

    @Bean
    public SubscribableChannel clientInboundChannel() {
        ExecutorSubscribableChannel executorSubscribableChannel = new ExecutorSubscribableChannel(this.clientInboundChannelExecutor());
        this.configureClientInboundChannel(executorSubscribableChannel);
        for (WampConfigurer wc : this.configurers) {
            wc.configureClientInboundChannel((AbstractMessageChannel)executorSubscribableChannel);
        }
        return executorSubscribableChannel;
    }

    protected void configureClientInboundChannel(ExecutorSubscribableChannel executorSubscribableChannel) {
    }

    @Bean
    public Executor clientInboundChannelExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("wampClientInboundChannel-");
        executor.setCorePoolSize(Runtime.getRuntime().availableProcessors() * 2);
        executor.setMaxPoolSize(Integer.MAX_VALUE);
        executor.setKeepAliveSeconds(60);
        executor.setQueueCapacity(Integer.MAX_VALUE);
        executor.setAllowCoreThreadTimeOut(true);
        return executor;
    }

    @Bean
    public SubscribableChannel clientOutboundChannel() {
        return new ExecutorSubscribableChannel(this.clientOutboundChannelExecutor());
    }

    @Bean
    public Executor clientOutboundChannelExecutor() {
        ThreadPoolTaskExecutor executor = new ThreadPoolTaskExecutor();
        executor.setThreadNamePrefix("wampClientOutboundChannel-");
        executor.setCorePoolSize(Runtime.getRuntime().availableProcessors() * 2);
        executor.setMaxPoolSize(Integer.MAX_VALUE);
        executor.setKeepAliveSeconds(60);
        executor.setQueueCapacity(Integer.MAX_VALUE);
        executor.setAllowCoreThreadTimeOut(true);
        return executor;
    }

    @Bean
    public SubscribableChannel brokerChannel() {
        return new ExecutorSubscribableChannel(this.brokerChannelExecutor());
    }

    @Nullable
    public Executor brokerChannelExecutor() {
        return null;
    }

    @Bean
    public MessageHandler pubSubMessageHandler(ApplicationContext applicationContext) {
        if (this.features.isEnabled(Feature.BROKER)) {
            PubSubMessageHandler pubSubMessageHandler = new PubSubMessageHandler(this.clientInboundChannel(), this.brokerChannel(), (MessageChannel)this.clientOutboundChannel(), this.subscriptionRegistry(), this.handlerMethodService(applicationContext), this.features, this.eventStore());
            return pubSubMessageHandler;
        }
        return new NoOpMessageHandler();
    }

    @Bean
    public SubscriptionRegistry subscriptionRegistry() {
        return new SubscriptionRegistry();
    }

    @Bean
    public MessageHandler rpcMessageHandler(ApplicationContext applicationContext) {
        if (this.features.isEnabled(Feature.DEALER)) {
            RpcMessageHandler rpcMessageHandler = new RpcMessageHandler(this.clientInboundChannel(), (MessageChannel)this.clientOutboundChannel(), this.procedureRegistry(), this.handlerMethodService(applicationContext), this.features);
            return rpcMessageHandler;
        }
        return new NoOpMessageHandler();
    }

    @Bean
    public HandlerMethodService handlerMethodService(ApplicationContext applicationContext) {
        ArrayList<HandlerMethodArgumentResolver> argumentResolvers = new ArrayList<HandlerMethodArgumentResolver>();
        this.addArgumentResolvers(argumentResolvers);
        for (WampConfigurer wc : this.configurers) {
            wc.addArgumentResolvers(argumentResolvers);
        }
        return new HandlerMethodService(this.conversionService(), argumentResolvers, new ObjectMapper(), applicationContext);
    }

    protected void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
    }

    protected ConversionService conversionService() {
        if (this.internalConversionService == null) {
            this.internalConversionService = new DefaultFormattingConversionService();
        }
        return this.internalConversionService;
    }

    protected EventStore eventStore() {
        if (this.eventStore == null) {
            this.eventStore = new MemoryEventStore();
        }
        return this.eventStore;
    }

    @Bean
    public ProcedureRegistry procedureRegistry() {
        return new ProcedureRegistry(this.features);
    }

    @Bean
    public WampPublisher wampEventPublisher() {
        return new WampPublisher((MessageChannel)this.brokerChannel());
    }
}

