/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.config;

import ch.rasc.wamp2spring.config.Feature;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;

public class Features {
    private final EnumSet<Feature> enabledFeatures = EnumSet.allOf(Feature.class);

    public void disable(Feature feature) {
        this.enabledFeatures.remove((Object)feature);
    }

    EnumSet<Feature> getEnabledFeatures() {
        return this.enabledFeatures;
    }

    public boolean isEnabled(Feature feature) {
        return this.enabledFeatures.contains((Object)feature);
    }

    public boolean isDisabled(Feature feature) {
        return !this.enabledFeatures.contains((Object)feature);
    }

    public List<Feature> enabledDealerFeatures() {
        ArrayList<Feature> dealerFeatures = new ArrayList<Feature>();
        if (this.isEnabled(Feature.DEALER_CALLER_IDENTIFICATION)) {
            dealerFeatures.add(Feature.DEALER_CALLER_IDENTIFICATION);
        }
        return dealerFeatures;
    }

    public List<Feature> enabledBrokerFeatures() {
        ArrayList<Feature> brokerFeatures = new ArrayList<Feature>();
        if (this.isEnabled(Feature.BROKER_SUBSCRIBER_BLACKWHITE_LISTING)) {
            brokerFeatures.add(Feature.BROKER_SUBSCRIBER_BLACKWHITE_LISTING);
        }
        if (this.isEnabled(Feature.BROKER_PUBLISHER_EXCLUSION)) {
            brokerFeatures.add(Feature.BROKER_PUBLISHER_EXCLUSION);
        }
        if (this.isEnabled(Feature.BROKER_PUBLISHER_IDENTIFICATION)) {
            brokerFeatures.add(Feature.BROKER_PUBLISHER_IDENTIFICATION);
        }
        if (this.isEnabled(Feature.BROKER_PATTERN_BASED_SUBSCRIPTION)) {
            brokerFeatures.add(Feature.BROKER_PATTERN_BASED_SUBSCRIPTION);
        }
        if (this.isEnabled(Feature.BROKER_EVENT_RETENTION)) {
            brokerFeatures.add(Feature.BROKER_EVENT_RETENTION);
        }
        return brokerFeatures;
    }
}

