/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.config;

import ch.rasc.wamp2spring.pubsub.MatchPolicy;
import org.springframework.lang.Nullable;

public class DestinationMatch {
    private final String destination;
    private final MatchPolicy matchPolicy;
    @Nullable
    private final String[] wildcardComponents;

    public DestinationMatch(String destination) {
        this(destination, MatchPolicy.EXACT);
    }

    public DestinationMatch(String destination, MatchPolicy matchPolicy) {
        this.destination = destination;
        this.matchPolicy = matchPolicy;
        this.wildcardComponents = matchPolicy == MatchPolicy.WILDCARD ? destination.split("\\.") : null;
    }

    public String getDestination() {
        return this.destination;
    }

    public MatchPolicy getMatchPolicy() {
        return this.matchPolicy;
    }

    public boolean matches(String queryDestination) {
        if (this.matchPolicy == MatchPolicy.EXACT) {
            return this.destination.equals(queryDestination);
        }
        if (this.matchPolicy == MatchPolicy.PREFIX) {
            return queryDestination.startsWith(this.destination);
        }
        String[] components = queryDestination.split("\\.");
        return this.matchesWildcard(components);
    }

    public boolean matchesWildcard(String[] components) {
        if (this.wildcardComponents != null && components.length == this.wildcardComponents.length) {
            for (int i = 0; i < components.length; ++i) {
                String wc = this.wildcardComponents[i];
                if (wc.length() <= 0 || components[i].equals(wc)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

