/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring;

import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;

public class WampException
extends Exception {
    private final String uri;
    private final List<Object> arguments;
    private final Map<String, Object> argumentsKw;

    protected WampException(String uri, @Nullable List<Object> arguments, @Nullable Map<String, Object> argumentsKw, @Nullable Throwable throwable) {
        super(throwable);
        this.uri = uri;
        this.arguments = arguments;
        this.argumentsKw = argumentsKw;
    }

    public String getUri() {
        return this.uri;
    }

    @Nullable
    public List<Object> getArguments() {
        return this.arguments;
    }

    @Nullable
    public Map<String, Object> getArgumentsKw() {
        return this.argumentsKw;
    }

    public static class Builder {
        private List<Object> arguments;
        private Map<String, Object> argumentsKw;
        private Throwable throwable;

        public Builder arguments(List<Object> param) {
            this.arguments = param;
            return this;
        }

        public Builder argumentsKw(Map<String, Object> param) {
            this.argumentsKw = param;
            return this;
        }

        public Builder throwable(Throwable param) {
            this.throwable = param;
            return this;
        }

        public WampException build(String error) {
            return new WampException(error, this.arguments, this.argumentsKw, this.throwable);
        }
    }
}

