/**
 * Copyright 2017-2018 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ch.rasc.wamp2spring.config;

import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHandler;

/**
 * No operation implementation of the {@link MessageHandler} interface. Used for disabled
 * {@link Features}.
 */
public class NoOpMessageHandler implements MessageHandler {

	@Override
	public void handleMessage(Message<?> message) {
		// nothing here
	}
}