/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.util;

import ch.rasc.wamp2spring.config.PrincipalMethodArgumentResolver;
import ch.rasc.wamp2spring.config.WampMessageMethodArgumentResolver;
import ch.rasc.wamp2spring.config.WampSessionIdMethodArgumentResolver;
import ch.rasc.wamp2spring.message.CallMessage;
import ch.rasc.wamp2spring.message.EventMessage;
import ch.rasc.wamp2spring.util.InvocableHandlerMethod;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.convert.ConversionService;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.support.HeaderMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeadersMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolverComposite;
import org.springframework.util.ClassUtils;

public class HandlerMethodService {
    private final ParameterNameDiscoverer parameterNameDiscoverer;
    private final ConversionService conversionService;
    private final HandlerMethodArgumentResolverComposite argumentResolvers;
    private final ObjectMapper objectMapper;

    public HandlerMethodService(ConversionService conversionService, List<HandlerMethodArgumentResolver> customArgumentResolvers, ObjectMapper objectMapper, ApplicationContext applicationContext) {
        this.conversionService = conversionService;
        this.parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
        this.argumentResolvers = new HandlerMethodArgumentResolverComposite();
        ConfigurableListableBeanFactory beanFactory = ClassUtils.isAssignableValue(ConfigurableApplicationContext.class, (Object)applicationContext) ? ((ConfigurableApplicationContext)applicationContext).getBeanFactory() : null;
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new HeaderMethodArgumentResolver(this.conversionService, (ConfigurableBeanFactory)beanFactory));
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new HeadersMethodArgumentResolver());
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new WampMessageMethodArgumentResolver());
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new PrincipalMethodArgumentResolver());
        this.argumentResolvers.addResolver((HandlerMethodArgumentResolver)new WampSessionIdMethodArgumentResolver());
        this.argumentResolvers.addResolvers(customArgumentResolvers);
        this.objectMapper = objectMapper;
    }

    @Nullable
    public Object invoke(CallMessage callMessage, InvocableHandlerMethod handlerMethod) throws Exception {
        this.setHelpers(handlerMethod);
        return handlerMethod.invoke(callMessage, callMessage.getArguments(), callMessage.getArgumentsKw());
    }

    @Nullable
    public Object invoke(EventMessage eventMessage, InvocableHandlerMethod handlerMethod) throws Exception {
        this.setHelpers(handlerMethod);
        return handlerMethod.invoke(eventMessage, eventMessage.getArguments(), eventMessage.getArgumentsKw());
    }

    private void setHelpers(InvocableHandlerMethod handlerMethod) {
        handlerMethod.setArgumentResolvers(this.argumentResolvers);
        handlerMethod.setConversionService(this.conversionService);
        handlerMethod.setParameterNameDiscoverer(this.parameterNameDiscoverer);
        handlerMethod.setObjectMapper(this.objectMapper);
    }
}

