/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.rpc;

import ch.rasc.wamp2spring.WampError;
import ch.rasc.wamp2spring.config.Feature;
import ch.rasc.wamp2spring.config.Features;
import ch.rasc.wamp2spring.message.CallMessage;
import ch.rasc.wamp2spring.message.ErrorMessage;
import ch.rasc.wamp2spring.message.InvocationMessage;
import ch.rasc.wamp2spring.message.RegisterMessage;
import ch.rasc.wamp2spring.message.UnregisterMessage;
import ch.rasc.wamp2spring.message.WampMessage;
import ch.rasc.wamp2spring.message.YieldMessage;
import ch.rasc.wamp2spring.rpc.Procedure;
import ch.rasc.wamp2spring.rpc.UnregisterResult;
import ch.rasc.wamp2spring.util.IdGenerator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;

public class ProcedureRegistry {
    private static final AtomicLong lastRegistration = new AtomicLong(1L);
    private final Map<String, Procedure> procedures = new ConcurrentHashMap<String, Procedure>();
    private final Map<Long, String> registrations = new ConcurrentHashMap<Long, String>();
    private final Map<Long, CallProc> pendingInvocations = new ConcurrentHashMap<Long, CallProc>();
    private final Features features;

    public ProcedureRegistry(Features features) {
        this.features = features;
    }

    synchronized long register(RegisterMessage registerMessage) {
        if (!this.procedures.containsKey(registerMessage.getProcedure())) {
            long registrationId = IdGenerator.newLinearId(lastRegistration);
            this.registrations.put(registrationId, registerMessage.getProcedure());
            Procedure procedure = new Procedure(registerMessage, registrationId, this.features.isEnabled(Feature.DEALER_CALLER_IDENTIFICATION));
            this.procedures.put(registerMessage.getProcedure(), procedure);
            return registrationId;
        }
        return -1L;
    }

    synchronized UnregisterResult unregister(UnregisterMessage unregisterMessage) {
        String procedure = this.registrations.remove(unregisterMessage.getRegistrationId());
        if (procedure != null) {
            Procedure proc = this.procedures.remove(procedure);
            return new UnregisterResult(true, proc, ProcedureRegistry.createErrorsForPendingInvocations(proc));
        }
        return new UnregisterResult(false, null);
    }

    synchronized List<UnregisterResult> unregisterWebSocketSession(String webSocketSessionId) {
        ArrayList<UnregisterResult> unregisterResults = new ArrayList<UnregisterResult>();
        List toRemoveProcedures = this.procedures.values().stream().filter(proc -> proc.getWebSocketSessionId().equals(webSocketSessionId)).collect(Collectors.toList());
        for (Procedure proc2 : toRemoveProcedures) {
            this.procedures.remove(proc2.getProcedure());
            this.registrations.remove(proc2.getRegistrationId());
            List<ErrorMessage> errorsForPendingInvocations = ProcedureRegistry.createErrorsForPendingInvocations(proc2);
            UnregisterResult result = new UnregisterResult(true, proc2, errorsForPendingInvocations);
            unregisterResults.add(result);
        }
        return unregisterResults;
    }

    private static List<ErrorMessage> createErrorsForPendingInvocations(Procedure proc) {
        ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>();
        for (Long invocationRequestId : proc.getPendingInvocations()) {
            errorMessages.add(new ErrorMessage(68, invocationRequestId, WampError.NO_SUCH_REGISTRATION.getExternalValue(), null, null));
        }
        return errorMessages;
    }

    WampMessage createInvocationMessage(CallMessage callMessage) {
        Procedure procedure = this.procedures.get(callMessage.getProcedure());
        if (procedure != null) {
            InvocationMessage invocationMessage = new InvocationMessage(procedure, callMessage);
            this.pendingInvocations.put(invocationMessage.getRequestId(), new CallProc(callMessage, procedure));
            procedure.addPendingInvocation(invocationMessage.getRequestId());
            return invocationMessage;
        }
        return new ErrorMessage(callMessage, WampError.NO_SUCH_PROCEDURE);
    }

    @Nullable
    CallMessage removeInvocationCall(WampMessage yieldOrErrorMessage) {
        long requestId;
        if (yieldOrErrorMessage instanceof YieldMessage) {
            requestId = ((YieldMessage)yieldOrErrorMessage).getRequestId();
        } else if (yieldOrErrorMessage instanceof ErrorMessage) {
            requestId = ((ErrorMessage)yieldOrErrorMessage).getRequestId();
        } else {
            return null;
        }
        CallProc callProc = this.pendingInvocations.remove(requestId);
        if (callProc != null) {
            callProc.procedure.removePendingInvocation(requestId);
            return callProc.callMessage;
        }
        return null;
    }

    static class CallProc {
        CallMessage callMessage;
        Procedure procedure;

        public CallProc(CallMessage callMessage, Procedure procedure) {
            this.callMessage = callMessage;
            this.procedure = procedure;
        }
    }
}

