/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.pubsub;

import ch.rasc.wamp2spring.WampError;
import ch.rasc.wamp2spring.config.DestinationMatch;
import ch.rasc.wamp2spring.message.SubscribeMessage;
import ch.rasc.wamp2spring.message.UnsubscribeMessage;
import ch.rasc.wamp2spring.pubsub.EventListenerInfo;
import ch.rasc.wamp2spring.pubsub.MatchPolicy;
import ch.rasc.wamp2spring.pubsub.SubscribeResult;
import ch.rasc.wamp2spring.pubsub.Subscriber;
import ch.rasc.wamp2spring.pubsub.Subscription;
import ch.rasc.wamp2spring.pubsub.SubscriptionDetail;
import ch.rasc.wamp2spring.pubsub.UnsubscribeResult;
import ch.rasc.wamp2spring.util.IdGenerator;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.springframework.lang.Nullable;

public class SubscriptionRegistry {
    private static final AtomicLong lastSubscriptionId = new AtomicLong(1L);
    private final EnumMap<MatchPolicy, Map<String, Subscription>> subscriptionsByMatch = new EnumMap(MatchPolicy.class);
    private final Map<Long, Subscription> subscriptionsById = new ConcurrentHashMap<Long, Subscription>();
    private final LoadingCache<String, Set<Subscription>> subscriptionsCache = Caffeine.newBuilder().maximumSize(512L).build(key -> this.internalFindSubscriptions((String)key));
    private final Object monitor = new Object();

    public SubscriptionRegistry() {
        this.subscriptionsByMatch.put(MatchPolicy.EXACT, new ConcurrentHashMap());
        this.subscriptionsByMatch.put(MatchPolicy.PREFIX, new ConcurrentHashMap());
        this.subscriptionsByMatch.put(MatchPolicy.WILDCARD, new ConcurrentHashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SubscribeResult subscribe(SubscribeMessage subscribeMessage) {
        Map<String, Subscription> subscriptionMap = this.subscriptionsByMatch.get((Object)subscribeMessage.getMatchPolicy());
        boolean created = false;
        Subscription subscription = subscriptionMap.get(subscribeMessage.getTopic());
        if (subscription == null) {
            Object object = this.monitor;
            synchronized (object) {
                subscription = subscriptionMap.get(subscribeMessage.getTopic());
                if (subscription == null) {
                    long subscriptionId = IdGenerator.newLinearId(lastSubscriptionId);
                    subscription = new Subscription(subscribeMessage.getTopic(), subscribeMessage.getMatchPolicy(), subscriptionId);
                    subscriptionMap.put(subscription.getTopic(), subscription);
                    this.subscriptionsById.put(subscriptionId, subscription);
                    created = true;
                    this.invalidateCacheEntries(subscription);
                }
            }
        }
        Subscriber subscriber = new Subscriber(subscribeMessage.getWebSocketSessionId(), subscribeMessage.getWampSessionId());
        subscription.addSubscriber(subscriber);
        return new SubscribeResult(subscribeMessage.getWampSessionId(), subscription, created);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void subscribeEventHandlers(List<EventListenerInfo> eventListeners) {
        for (EventListenerInfo eventListener : eventListeners) {
            Map<String, Subscription> subscriptionMap = this.subscriptionsByMatch.get((Object)eventListener.getMatch());
            for (String topic : eventListener.getTopic()) {
                Object object = this.monitor;
                synchronized (object) {
                    Subscription subscription = subscriptionMap.get(topic);
                    if (subscription == null) {
                        long subscriptionId = IdGenerator.newLinearId(lastSubscriptionId);
                        subscription = new Subscription(topic, eventListener.getMatch(), subscriptionId);
                        subscriptionMap.put(subscription.getTopic(), subscription);
                        this.subscriptionsById.put(subscriptionId, subscription);
                        this.invalidateCacheEntries(subscription);
                    }
                    subscription.addEventListenerHandlerMethod(eventListener.getHandlerMethod());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UnsubscribeResult unsubscribe(UnsubscribeMessage message) {
        Subscription subscription = this.subscriptionsById.get(message.getSubscriptionId());
        if (subscription != null) {
            Subscriber subscriber = new Subscriber(message.getWebSocketSessionId(), message.getWampSessionId());
            Object object = this.monitor;
            synchronized (object) {
                if (subscription.removeSubscriber(subscriber)) {
                    boolean deleted = false;
                    if (!subscription.hasSubscribers()) {
                        this.subscriptionsByMatch.get((Object)subscription.getMatchPolicy()).remove(subscription.getTopic());
                        this.subscriptionsById.remove(subscription.getSubscriptionId());
                        deleted = true;
                        this.invalidateCacheEntries(subscription);
                    }
                    return new UnsubscribeResult(message.getWampSessionId(), subscription, deleted);
                }
            }
        }
        return new UnsubscribeResult(message.getWampSessionId(), WampError.NO_SUCH_SUBSCRIPTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<UnsubscribeResult> removeWebSocketSessionId(String webSocketSessionId, long wampSessionId) {
        ArrayList<UnsubscribeResult> results = new ArrayList<UnsubscribeResult>();
        for (MatchPolicy matchPolicy : MatchPolicy.values()) {
            Map<String, Subscription> subscriptionMap = this.subscriptionsByMatch.get((Object)matchPolicy);
            for (Subscription subscription : subscriptionMap.values()) {
                Subscriber subscriber = new Subscriber(webSocketSessionId, wampSessionId);
                Object object = this.monitor;
                synchronized (object) {
                    if (subscription.removeSubscriber(subscriber)) {
                        boolean deleted = false;
                        if (!subscription.hasSubscribers()) {
                            subscriptionMap.remove(subscription.getTopic());
                            this.subscriptionsById.remove(subscription.getSubscriptionId());
                            deleted = true;
                            this.invalidateCacheEntries(subscription);
                        }
                        results.add(new UnsubscribeResult(wampSessionId, subscription, deleted));
                    }
                }
            }
        }
        return results;
    }

    @Nullable
    Set<Subscription> findSubscriptions(String topic) {
        return (Set)this.subscriptionsCache.get((Object)topic);
    }

    private Set<Subscription> internalFindSubscriptions(String topic) {
        HashSet<Subscription> subscriptions = new HashSet<Subscription>();
        Subscription exactSubscription = this.subscriptionsByMatch.get((Object)MatchPolicy.EXACT).get(topic);
        if (exactSubscription != null) {
            subscriptions.add(exactSubscription);
        }
        Map<String, Subscription> prefixSubscriptionMap = this.subscriptionsByMatch.get((Object)MatchPolicy.PREFIX);
        for (Subscription prefixSubscription : prefixSubscriptionMap.values()) {
            if (!prefixSubscription.getTopicMatch().matches(topic)) continue;
            subscriptions.add(prefixSubscription);
        }
        Map<String, Subscription> wildcardSubscriptionMap = this.subscriptionsByMatch.get((Object)MatchPolicy.WILDCARD);
        String[] components = topic.split("\\.");
        for (Subscription wildcardSubscription : wildcardSubscriptionMap.values()) {
            if (!wildcardSubscription.getTopicMatch().matchesWildcard(components)) continue;
            subscriptions.add(wildcardSubscription);
        }
        return subscriptions;
    }

    private void invalidateCacheEntries(Subscription subscription) {
        if (subscription.getMatchPolicy() == MatchPolicy.EXACT) {
            this.subscriptionsCache.invalidate((Object)subscription.getTopic());
        } else {
            DestinationMatch topicMatch = subscription.getTopicMatch();
            this.subscriptionsCache.asMap().keySet().removeIf(topicMatch::matches);
        }
    }

    public EnumMap<MatchPolicy, List<Long>> listSubscriptions() {
        EnumMap<MatchPolicy, List<Long>> result = new EnumMap<MatchPolicy, List<Long>>(MatchPolicy.class);
        for (MatchPolicy matchPolicy : MatchPolicy.values()) {
            List subscriptionIds = this.subscriptionsByMatch.get((Object)matchPolicy).values().stream().map(Subscription::getSubscriptionId).collect(Collectors.toList());
            result.put(matchPolicy, subscriptionIds);
        }
        return result;
    }

    @Nullable
    public Long lookupSubscription(String topic, @Nullable MatchPolicy matchPolicy) {
        Subscription subscription;
        MatchPolicy me = matchPolicy;
        if (me == null) {
            me = MatchPolicy.EXACT;
        }
        if ((subscription = this.subscriptionsByMatch.get((Object)me).get(topic)) != null) {
            return subscription.getSubscriptionId();
        }
        return null;
    }

    public List<Long> getMatchSubscriptions(String topic) {
        return this.findSubscriptions(topic).stream().map(Subscription::getSubscriptionId).collect(Collectors.toList());
    }

    @Nullable
    public SubscriptionDetail getSubscription(long subscriptionId) {
        Subscription sub = this.subscriptionsById.get(subscriptionId);
        if (sub != null) {
            return new SubscriptionDetail(sub);
        }
        return null;
    }

    public List<Long> listSubscribers(long subscriptionId) {
        Subscription sub = this.subscriptionsById.get(subscriptionId);
        if (sub != null) {
            return sub.getSubscribers().stream().map(Subscriber::getWampSessionId).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Nullable
    public Integer countSubscribers(long subscriptionId) {
        Subscription sub = this.subscriptionsById.get(subscriptionId);
        if (sub != null) {
            return sub.getSubscribers().size();
        }
        return null;
    }

    public boolean hasSubscribers(String topic) {
        return !this.getMatchSubscriptions(topic).isEmpty();
    }
}

