/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.pubsub;

import ch.rasc.wamp2spring.config.DestinationMatch;
import ch.rasc.wamp2spring.pubsub.MatchPolicy;
import ch.rasc.wamp2spring.pubsub.Subscriber;
import ch.rasc.wamp2spring.util.InvocableHandlerMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.lang.Nullable;

class Subscription {
    private final DestinationMatch topicMatch;
    private final long subscriptionId;
    private final Set<Subscriber> subscribers;
    private final long createdTimeMillis = System.currentTimeMillis();
    @Nullable
    private List<InvocableHandlerMethod> eventListenerHandlerMethods = null;

    Subscription(String topic, MatchPolicy matchPolicy, long subscriptionId) {
        this.topicMatch = new DestinationMatch(topic, matchPolicy);
        this.subscriptionId = subscriptionId;
        this.subscribers = ConcurrentHashMap.newKeySet();
    }

    void addEventListenerHandlerMethod(InvocableHandlerMethod handlerMethod) {
        if (this.eventListenerHandlerMethods == null) {
            this.eventListenerHandlerMethods = new ArrayList<InvocableHandlerMethod>();
        }
        this.eventListenerHandlerMethods.add(handlerMethod);
    }

    void addSubscriber(Subscriber subscriber) {
        this.subscribers.add(subscriber);
    }

    boolean removeSubscriber(Subscriber subscriber) {
        return this.subscribers.remove(subscriber);
    }

    boolean hasSubscribers() {
        return !this.subscribers.isEmpty() || this.eventListenerHandlerMethods != null;
    }

    long getCreatedTimeMillis() {
        return this.createdTimeMillis;
    }

    String getTopic() {
        return this.topicMatch.getDestination();
    }

    MatchPolicy getMatchPolicy() {
        return this.topicMatch.getMatchPolicy();
    }

    public DestinationMatch getTopicMatch() {
        return this.topicMatch;
    }

    long getSubscriptionId() {
        return this.subscriptionId;
    }

    Set<Subscriber> getSubscribers() {
        return this.subscribers;
    }

    @Nullable
    List<InvocableHandlerMethod> getEventListenerHandlerMethods() {
        return this.eventListenerHandlerMethods;
    }
}

