/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.message;

import java.util.HashSet;
import java.util.Set;
import org.springframework.lang.Nullable;

public final class WampRole {
    private final String role;
    private final Set<String> features;

    public WampRole(String role) {
        this.role = role;
        this.features = new HashSet<String>();
    }

    String getRole() {
        return this.role;
    }

    Set<String> getFeatures() {
        return this.features;
    }

    public void addFeature(String feature) {
        this.features.add(feature);
    }

    boolean hasFeatures() {
        return !this.features.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.features == null ? 0 : this.features.hashCode());
        result = 31 * result + (this.role == null ? 0 : this.role.hashCode());
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WampRole other = (WampRole)obj;
        if (this.features == null ? other.features != null : !this.features.equals(other.features)) {
            return false;
        }
        return !(this.role == null ? other.role != null : !this.role.equals(other.role));
    }

    public String toString() {
        return "WampRole [role=" + this.role + ", features=" + this.features + "]";
    }
}

