/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.message;

import ch.rasc.wamp2spring.message.ParserUtil;
import ch.rasc.wamp2spring.message.UnsubscribeMessage;
import ch.rasc.wamp2spring.message.WampMessage;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Map;
import org.springframework.lang.Nullable;

public class UnsubscribedMessage
extends WampMessage {
    static final int CODE = 35;
    private final long requestId;
    @Nullable
    private final Long subscriptionId;
    @Nullable
    private final String reason;

    public UnsubscribedMessage(long requestId) {
        this(requestId, null, null);
    }

    public UnsubscribedMessage(long requestId, @Nullable Long subscriptionId, @Nullable String reason) {
        super(35);
        this.requestId = requestId;
        this.subscriptionId = subscriptionId;
        this.reason = reason;
    }

    public UnsubscribedMessage(UnsubscribeMessage unsubscribeMessage) {
        this(unsubscribeMessage.getRequestId());
        this.setReceiver(unsubscribeMessage);
    }

    public static UnsubscribedMessage deserialize(JsonParser jp) throws IOException {
        jp.nextToken();
        long request = jp.getLongValue();
        Long subscriptionId = null;
        String reason = null;
        JsonToken token = jp.nextToken();
        if (token == JsonToken.START_OBJECT) {
            Map<String, Object> details = ParserUtil.readObject(jp);
            reason = (String)details.get("reason");
            Object subscriptionObj = details.get("subscription");
            if (subscriptionObj != null) {
                subscriptionId = ((Number)subscriptionObj).longValue();
            }
        }
        return new UnsubscribedMessage(request, subscriptionId, reason);
    }

    @Override
    public void serialize(JsonGenerator generator) throws IOException {
        generator.writeNumber(this.getCode());
        generator.writeNumber(this.requestId);
        if (this.subscriptionId != null || this.reason != null) {
            generator.writeStartObject();
            if (this.reason != null) {
                generator.writeStringField("reason", this.reason);
            }
            if (this.subscriptionId != null) {
                generator.writeNumberField("subscription", this.subscriptionId.longValue());
            }
            generator.writeEndObject();
        }
    }

    public long getRequestId() {
        return this.requestId;
    }

    @Nullable
    public Long getSubscriptionId() {
        return this.subscriptionId;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    public String toString() {
        return "UnsubscribedMessage [requestId=" + this.requestId + ", subscriptionId=" + this.subscriptionId + ", reason=" + this.reason + "]";
    }
}

