/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.message;

import ch.rasc.wamp2spring.message.ParserUtil;
import ch.rasc.wamp2spring.message.UnregisterMessage;
import ch.rasc.wamp2spring.message.WampMessage;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Map;
import org.springframework.lang.Nullable;

public class UnregisteredMessage
extends WampMessage {
    static final int CODE = 67;
    private final long requestId;
    @Nullable
    private final Long registrationId;
    @Nullable
    private final String reason;

    public UnregisteredMessage(long requestId) {
        this(requestId, null, null);
    }

    public UnregisteredMessage(long requestId, @Nullable Long registrationId, @Nullable String reason) {
        super(67);
        this.requestId = requestId;
        this.registrationId = registrationId;
        this.reason = reason;
    }

    public UnregisteredMessage(UnregisterMessage unregisterMessage) {
        this(unregisterMessage.getRequestId());
        this.setReceiver(unregisterMessage);
    }

    public static UnregisteredMessage deserialize(JsonParser jp) throws IOException {
        jp.nextToken();
        long request = jp.getLongValue();
        Long registrationId = null;
        String reason = null;
        JsonToken token = jp.nextToken();
        if (token == JsonToken.START_OBJECT) {
            Map<String, Object> details = ParserUtil.readObject(jp);
            reason = (String)details.get("reason");
            Object registrationObj = details.get("registration");
            if (registrationObj != null) {
                registrationId = ((Number)registrationObj).longValue();
            }
        }
        return new UnregisteredMessage(request, registrationId, reason);
    }

    @Override
    public void serialize(JsonGenerator generator) throws IOException {
        generator.writeNumber(this.getCode());
        generator.writeNumber(this.requestId);
        if (this.registrationId != null || this.reason != null) {
            generator.writeStartObject();
            if (this.reason != null) {
                generator.writeStringField("reason", this.reason);
            }
            if (this.registrationId != null) {
                generator.writeNumberField("registration", this.registrationId.longValue());
            }
            generator.writeEndObject();
        }
    }

    public long getRequestId() {
        return this.requestId;
    }

    @Nullable
    public Long getRegistrationId() {
        return this.registrationId;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    public String toString() {
        return "UnregisteredMessage [requestId=" + this.requestId + ", registrationId=" + this.registrationId + ", reason=" + this.reason + "]";
    }
}

