/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.message;

import ch.rasc.wamp2spring.message.ParserUtil;
import ch.rasc.wamp2spring.message.WampMessage;
import ch.rasc.wamp2spring.pubsub.MatchPolicy;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.Map;

public class SubscribeMessage
extends WampMessage {
    public static final int CODE = 32;
    private final long requestId;
    private final MatchPolicy matchPolicy;
    private final String topic;
    private final boolean getRetained;

    public SubscribeMessage(long requestId, String topic) {
        this(requestId, topic, MatchPolicy.EXACT, false);
    }

    public SubscribeMessage(long requestId, String topic, boolean get_retained) {
        this(requestId, topic, MatchPolicy.EXACT, get_retained);
    }

    public SubscribeMessage(long requestId, String topic, MatchPolicy match) {
        this(requestId, topic, match, false);
    }

    public SubscribeMessage(long requestId, String topic, MatchPolicy match, boolean getRetained) {
        super(32);
        this.requestId = requestId;
        this.matchPolicy = match;
        this.topic = topic;
        this.getRetained = getRetained;
    }

    public static SubscribeMessage deserialize(JsonParser jp) throws IOException {
        jp.nextToken();
        long request = jp.getLongValue();
        MatchPolicy match = MatchPolicy.EXACT;
        jp.nextToken();
        boolean getRetained = false;
        Map<String, Object> options = ParserUtil.readObject(jp);
        if (options != null) {
            String extValue = (String)options.get("match");
            if (extValue != null && (match = MatchPolicy.fromExtValue(extValue)) == null) {
                match = MatchPolicy.EXACT;
            }
            getRetained = (Boolean)options.getOrDefault("get_retained", false);
        }
        jp.nextToken();
        String topic = jp.getValueAsString();
        return new SubscribeMessage(request, topic, match, getRetained);
    }

    @Override
    public void serialize(JsonGenerator generator) throws IOException {
        generator.writeNumber(this.getCode());
        generator.writeNumber(this.requestId);
        generator.writeStartObject();
        if (this.matchPolicy != MatchPolicy.EXACT) {
            generator.writeStringField("match", this.matchPolicy.getExternalValue());
        }
        if (this.getRetained) {
            generator.writeBooleanField("get_retained", this.getRetained);
        }
        generator.writeEndObject();
        generator.writeString(this.topic);
    }

    public long getRequestId() {
        return this.requestId;
    }

    public MatchPolicy getMatchPolicy() {
        return this.matchPolicy;
    }

    public String getTopic() {
        return this.topic;
    }

    public boolean isGetRetained() {
        return this.getRetained;
    }

    public String toString() {
        return "SubscribeMessage [requestId=" + this.requestId + ", matchPolicy=" + (Object)((Object)this.matchPolicy) + ", topic=" + this.topic + ", getRetained=" + this.getRetained + "]";
    }
}

