/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.message;

import ch.rasc.wamp2spring.message.RegisterMessage;
import ch.rasc.wamp2spring.message.WampMessage;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;

public class RegisteredMessage
extends WampMessage {
    static final int CODE = 65;
    private final long requestId;
    private final long registrationId;

    public RegisteredMessage(long requestId, long registrationId) {
        super(65);
        this.requestId = requestId;
        this.registrationId = registrationId;
    }

    public RegisteredMessage(RegisterMessage registerMessage, long registrationId) {
        this(registerMessage.getRequestId(), registrationId);
        this.setReceiver(registerMessage);
    }

    public static RegisteredMessage deserialize(JsonParser jp) throws IOException {
        jp.nextToken();
        long request = jp.getLongValue();
        jp.nextToken();
        long registration = jp.getLongValue();
        return new RegisteredMessage(request, registration);
    }

    @Override
    public void serialize(JsonGenerator generator) throws IOException {
        generator.writeNumber(this.getCode());
        generator.writeNumber(this.requestId);
        generator.writeNumber(this.registrationId);
    }

    public long getRequestId() {
        return this.requestId;
    }

    public long getRegistrationId() {
        return this.registrationId;
    }

    public String toString() {
        return "RegisteredMessage [requestId=" + this.requestId + ", registrationId=" + this.registrationId + "]";
    }
}

