/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.message;

import ch.rasc.wamp2spring.message.ParserUtil;
import ch.rasc.wamp2spring.message.WampMessage;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import java.io.IOException;
import java.util.Map;

public class RegisterMessage
extends WampMessage {
    public static final int CODE = 64;
    private final long requestId;
    private final String procedure;
    private final boolean discloseCaller;

    public RegisterMessage(long requestId, String procedure) {
        this(requestId, procedure, false);
    }

    public RegisterMessage(long requestId, String procedure, boolean discloseCaller) {
        super(64);
        this.requestId = requestId;
        this.procedure = procedure;
        this.discloseCaller = discloseCaller;
    }

    public static RegisterMessage deserialize(JsonParser jp) throws IOException {
        jp.nextToken();
        long request = jp.getLongValue();
        boolean discloseCaller = false;
        jp.nextToken();
        Map<String, Object> options = ParserUtil.readObject(jp);
        if (options != null) {
            discloseCaller = (Boolean)options.getOrDefault("disclose_caller", false);
        }
        jp.nextToken();
        String procedure = jp.getValueAsString();
        return new RegisterMessage(request, procedure, discloseCaller);
    }

    @Override
    public void serialize(JsonGenerator generator) throws IOException {
        generator.writeNumber(this.getCode());
        generator.writeNumber(this.requestId);
        generator.writeStartObject();
        if (this.discloseCaller) {
            generator.writeBooleanField("disclose_caller", this.discloseCaller);
        }
        generator.writeEndObject();
        generator.writeString(this.procedure);
    }

    public long getRequestId() {
        return this.requestId;
    }

    public String getProcedure() {
        return this.procedure;
    }

    public boolean isDiscloseCaller() {
        return this.discloseCaller;
    }

    public String toString() {
        return "RegisterMessage [requestId=" + this.requestId + ", procedure=" + this.procedure + ", discloseCaller=" + this.discloseCaller + "]";
    }
}

