/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.wamp2spring.message;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.lang.Nullable;

public class ParserUtil {
    @Nullable
    public static List<Object> readArray(JsonParser jp) throws IOException {
        if (jp.currentToken() != JsonToken.START_ARRAY) {
            return null;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        JsonToken token = jp.nextToken();
        while (token != JsonToken.END_ARRAY) {
            if (token == JsonToken.START_ARRAY) {
                result.add(ParserUtil.readArray(jp));
            } else if (token == JsonToken.START_OBJECT) {
                result.add(ParserUtil.readObject(jp));
            } else {
                result.add(ParserUtil.getValue(jp));
            }
            token = jp.nextToken();
        }
        return result;
    }

    @Nullable
    public static Map<String, Object> readObject(JsonParser jp) throws IOException {
        if (jp.currentToken() != JsonToken.START_OBJECT) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        JsonToken token = jp.nextToken();
        while (token != JsonToken.END_OBJECT) {
            String key = jp.getText();
            token = jp.nextToken();
            if (token == JsonToken.START_ARRAY) {
                result.put(key, ParserUtil.readArray(jp));
            } else if (token == JsonToken.START_OBJECT) {
                result.put(key, ParserUtil.readObject(jp));
            } else {
                result.put(key, ParserUtil.getValue(jp));
            }
            token = jp.nextToken();
        }
        return result;
    }

    @Nullable
    private static Object getValue(JsonParser jp) throws IOException {
        switch (jp.currentToken()) {
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                return jp.getBooleanValue();
            }
            case VALUE_STRING: {
                return jp.getValueAsString();
            }
            case VALUE_NUMBER_INT: {
                switch (jp.getNumberType()) {
                    case INT: {
                        return jp.getIntValue();
                    }
                    case LONG: {
                        return jp.getLongValue();
                    }
                    case BIG_INTEGER: {
                        return jp.getBigIntegerValue();
                    }
                }
                return null;
            }
            case VALUE_NUMBER_FLOAT: {
                switch (jp.getNumberType()) {
                    case FLOAT: {
                        return Float.valueOf(jp.getFloatValue());
                    }
                    case DOUBLE: {
                        return jp.getDoubleValue();
                    }
                    case BIG_DECIMAL: {
                        return jp.getDecimalValue();
                    }
                }
                return null;
            }
        }
        return null;
    }
}

