/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.sse.eventbus;

import ch.rasc.sse.eventbus.ImmutableSseEvent;
import java.time.Duration;
import java.util.Optional;
import java.util.Set;
import org.immutables.value.Value;

@Value.Style(depluralize=true, visibility=Value.Style.ImplementationVisibility.PACKAGE, overshadowImplementation=true)
@Value.Immutable
public interface SseEvent {
    public static final String DEFAULT_EVENT = "message";

    public Set<String> clientIds();

    public Set<String> excludeClientIds();

    public Optional<Class<?>> jsonView();

    @Value.Default
    default public String event() {
        return DEFAULT_EVENT;
    }

    public Object data();

    public Optional<Duration> retry();

    public Optional<String> id();

    public Optional<String> comment();

    public static SseEvent ofData(Object data) {
        return SseEvent.builder().data(data).build();
    }

    public static SseEvent ofEvent(String event) {
        return SseEvent.builder().event(event).data("").build();
    }

    public static SseEvent of(String event, Object data) {
        return SseEvent.builder().event(event).data(data).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ImmutableSseEvent.Builder {
    }
}

