/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.sse.eventbus.config;

import ch.rasc.sse.eventbus.DataObjectConverter;
import ch.rasc.sse.eventbus.DefaultDataObjectConverter;
import ch.rasc.sse.eventbus.DefaultSubscriptionRegistry;
import ch.rasc.sse.eventbus.JacksonDataObjectConverter;
import ch.rasc.sse.eventbus.SseEventBus;
import ch.rasc.sse.eventbus.SubscriptionRegistry;
import ch.rasc.sse.eventbus.config.SseEventBusConfigurer;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DefaultSseEventBusConfiguration {
    @Autowired(required=false)
    private SseEventBusConfigurer configurer;
    @Autowired(required=false)
    private ObjectMapper objectMapper;
    @Autowired(required=false)
    private List<DataObjectConverter> dataObjectConverters;
    @Autowired(required=false)
    private SubscriptionRegistry subscriptionRegistry;

    @Bean
    public SseEventBus eventBus() {
        SubscriptionRegistry registry;
        SseEventBusConfigurer config = this.configurer;
        if (config == null) {
            config = new SseEventBusConfigurer(){};
        }
        if ((registry = this.subscriptionRegistry) == null) {
            registry = new DefaultSubscriptionRegistry();
        }
        SseEventBus sseEventBus = new SseEventBus(config, registry);
        List<DataObjectConverter> converters = this.dataObjectConverters;
        if (converters == null) {
            converters = new ArrayList<DataObjectConverter>();
        }
        if (this.objectMapper != null) {
            converters.add(new JacksonDataObjectConverter(this.objectMapper));
        } else {
            converters.add(new DefaultDataObjectConverter());
        }
        sseEventBus.setDataObjectConverters(converters);
        return sseEventBus;
    }
}

