/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.sse.eventbus;

import ch.rasc.sse.eventbus.Client;
import ch.rasc.sse.eventbus.ClientEvent;
import ch.rasc.sse.eventbus.DataObjectConverter;
import ch.rasc.sse.eventbus.SseEvent;
import ch.rasc.sse.eventbus.config.SseEventBusConfigurer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.PreDestroy;
import org.springframework.context.event.EventListener;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

public class SseEventBus {
    private final Map<String, Client> clients;
    private final Map<String, Set<String>> eventSubscribers;
    private final ScheduledExecutorService taskScheduler;
    private final int noOfSendResponseTries;
    private final Duration clientExpiration;
    private List<DataObjectConverter> dataObjectConverters;
    private final BlockingQueue<ClientEvent> errorQueue;
    private final BlockingQueue<ClientEvent> sendQueue;

    public SseEventBus(SseEventBusConfigurer configurer) {
        this.taskScheduler = configurer.taskScheduler();
        this.noOfSendResponseTries = configurer.noOfSendResponseTries();
        this.clientExpiration = configurer.clientExpiration();
        this.clients = new ConcurrentHashMap<String, Client>();
        this.eventSubscribers = new ConcurrentHashMap<String, Set<String>>();
        this.errorQueue = configurer.errorQueue();
        this.sendQueue = configurer.sendQueue();
        this.taskScheduler.submit(this::eventLoop);
        this.taskScheduler.scheduleWithFixedDelay(this::reScheduleFailedEvents, 0L, configurer.schedulerDelay().toMillis(), TimeUnit.MILLISECONDS);
        this.taskScheduler.scheduleAtFixedRate(this::cleanUpClients, 0L, this.clientExpiration.toMillis(), TimeUnit.MILLISECONDS);
    }

    @PreDestroy
    public void cleanUp() {
        this.taskScheduler.shutdownNow();
    }

    public SseEmitter createSseEmitter(String clientId) {
        return this.createSseEmitter(clientId, (Long)180000L, new String[0]);
    }

    public SseEmitter createSseEmitter(String clientId, String ... events) {
        return this.createSseEmitter(clientId, (Long)180000L, false, false, events);
    }

    public SseEmitter createSseEmitter(String clientId, boolean unsubscribe, String ... events) {
        return this.createSseEmitter(clientId, (Long)180000L, unsubscribe, false, events);
    }

    public SseEmitter createSseEmitter(String clientId, Long timeout, String ... events) {
        return this.createSseEmitter(clientId, timeout, false, false, events);
    }

    public SseEmitter createSseEmitter(String clientId, Long timeout, boolean unsubscribe, String ... events) {
        return this.createSseEmitter(clientId, timeout, unsubscribe, false, events);
    }

    public SseEmitter createSseEmitter(String clientId, Long timeout, boolean unsubscribe, boolean completeAfterMessage, String ... events) {
        SseEmitter emitter = new SseEmitter(timeout);
        emitter.onTimeout(() -> ((SseEmitter)emitter).complete());
        this.registerClient(clientId, emitter, completeAfterMessage);
        if (events != null && events.length > 0) {
            if (unsubscribe) {
                this.unsubscribeFromAllEvents(clientId, events);
            }
            for (String event : events) {
                this.subscribe(clientId, event);
            }
        }
        return emitter;
    }

    public void registerClient(String clientId, SseEmitter emitter) {
        this.registerClient(clientId, emitter, false);
    }

    public void registerClient(String clientId, SseEmitter emitter, boolean completeAfterMessage) {
        Client client = this.clients.get(clientId);
        if (client == null) {
            this.clients.put(clientId, new Client(clientId, emitter, completeAfterMessage));
        } else {
            client.updateEmitter(emitter);
        }
    }

    public void unregisterClient(String clientId) {
        this.unsubscribeFromAllEvents(clientId, new String[0]);
        this.clients.remove(clientId);
    }

    public void subscribe(String clientId) {
        this.subscribe(clientId, "message");
    }

    public void subscribe(String clientId, String event) {
        this.eventSubscribers.computeIfAbsent(event, k -> new HashSet()).add(clientId);
    }

    public void subscribeOnly(String clientId, String event) {
        this.eventSubscribers.computeIfAbsent(event, k -> new HashSet()).add(clientId);
        this.unsubscribeFromAllEvents(clientId, event);
    }

    public void unsubscribe(String clientId, String event) {
        Set<String> clientIds = this.eventSubscribers.get(event);
        if (clientIds != null) {
            clientIds.remove(clientId);
            if (clientIds.isEmpty()) {
                this.eventSubscribers.remove(event);
            }
        }
    }

    public void unsubscribeFromAllEvents(String clientId, String ... keepEvents) {
        HashSet<String> keepEventsSet = null;
        if (keepEvents != null && keepEvents.length > 0) {
            keepEventsSet = new HashSet<String>();
            for (String keepEvent : keepEvents) {
                keepEventsSet.add(keepEvent);
            }
        }
        HashSet<String> emptyEvents = new HashSet<String>();
        for (Map.Entry<String, Set<String>> entry : this.eventSubscribers.entrySet()) {
            if (keepEventsSet != null && keepEventsSet.contains(entry.getKey())) continue;
            Set<String> clientIds = entry.getValue();
            clientIds.remove(clientId);
            if (!clientIds.isEmpty()) continue;
            emptyEvents.add(entry.getKey());
        }
        emptyEvents.forEach(this.eventSubscribers::remove);
    }

    @EventListener
    public void handleEvent(SseEvent event) {
        try {
            String convertedValue = null;
            if (!(event.data() instanceof String)) {
                convertedValue = this.convertObject(event);
            }
            if (event.clientIds().isEmpty()) {
                for (Client client : this.clients.values()) {
                    if (event.excludeClientIds().contains(client.getId()) || !this.isUserSubscribed(client.getId(), event)) continue;
                    this.sendQueue.put(new ClientEvent(client, event, convertedValue));
                }
            } else {
                for (String clientId : event.clientIds()) {
                    if (!this.isUserSubscribed(clientId, event)) continue;
                    this.sendQueue.put(new ClientEvent(this.clients.get(clientId), event, convertedValue));
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void reScheduleFailedEvents() {
        ArrayList failedEvents = new ArrayList();
        this.errorQueue.drainTo(failedEvents);
        for (ClientEvent sseClientEvent : failedEvents) {
            if (!this.isUserSubscribed(sseClientEvent.getClient().getId(), sseClientEvent.getSseEvent())) continue;
            try {
                this.sendQueue.put(sseClientEvent);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private boolean isUserSubscribed(String clientId, SseEvent event) {
        Set<String> subscribedClients = this.eventSubscribers.get(event.event());
        if (subscribedClients != null) {
            return subscribedClients.contains(clientId);
        }
        return false;
    }

    private void eventLoop() {
        try {
            while (true) {
                ClientEvent clientEvent;
                if ((clientEvent = this.sendQueue.take()).getErrorCounter() < this.noOfSendResponseTries) {
                    Client client = clientEvent.getClient();
                    boolean ok = SseEventBus.sendEventToClient(clientEvent);
                    if (ok) {
                        client.updateLastTransfer();
                        continue;
                    }
                    clientEvent.incErrorCounter();
                    this.errorQueue.put(clientEvent);
                    continue;
                }
                this.unregisterClient(clientEvent.getClient().getId());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean sendEventToClient(ClientEvent clientEvent) {
        Client client = clientEvent.getClient();
        try {
            client.sseEmitter().send(clientEvent.createSseEventBuilder());
            if (client.isCompleteAfterMessage()) {
                client.sseEmitter().complete();
            }
            return true;
        }
        catch (Exception e) {
            client.sseEmitter().completeWithError((Throwable)e);
            return false;
        }
    }

    private String convertObject(SseEvent event) {
        if (this.dataObjectConverters != null) {
            for (DataObjectConverter converter : this.dataObjectConverters) {
                if (!converter.supports(event)) continue;
                return converter.convert(event);
            }
        }
        return null;
    }

    private void cleanUpClients() {
        if (!this.clients.isEmpty()) {
            long expirationTime = System.currentTimeMillis() - this.clientExpiration.toMillis();
            Iterator<Map.Entry<String, Client>> it = this.clients.entrySet().iterator();
            HashSet<String> staleClients = new HashSet<String>();
            while (it.hasNext()) {
                Map.Entry<String, Client> entry = it.next();
                if (entry.getValue().lastTransfer() >= expirationTime) continue;
                staleClients.add(entry.getKey());
            }
            staleClients.forEach(this::unregisterClient);
        }
    }

    public List<DataObjectConverter> getDataObjectConverters() {
        return this.dataObjectConverters;
    }

    public void setDataObjectConverters(List<DataObjectConverter> dataObjectConverters) {
        this.dataObjectConverters = dataObjectConverters;
    }
}

