/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.piwik.tracking;

import ch.rasc.piwik.tracking.PiwikConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

@Generated(from="PiwikConfig", generator="Immutables")
final class ImmutablePiwikConfig
implements PiwikConfig {
    private final String scheme;
    private final String host;
    private final String path;
    private final String authToken;
    private final List<String> idSite;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePiwikConfig(Builder builder) {
        this.host = builder.host;
        this.authToken = builder.authToken;
        this.idSite = ImmutablePiwikConfig.createUnmodifiableList(true, builder.idSite);
        if (builder.scheme != null) {
            this.initShim.scheme(builder.scheme);
        }
        if (builder.path != null) {
            this.initShim.path(builder.path);
        }
        this.scheme = this.initShim.scheme();
        this.path = this.initShim.path();
        this.initShim = null;
    }

    private String schemeInitialize() {
        return PiwikConfig.super.scheme();
    }

    private String pathInitialize() {
        return PiwikConfig.super.path();
    }

    @Override
    public String scheme() {
        InitShim shim = this.initShim;
        return shim != null ? shim.scheme() : this.scheme;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public String path() {
        InitShim shim = this.initShim;
        return shim != null ? shim.path() : this.path;
    }

    @Override
    public Optional<String> authToken() {
        return Optional.ofNullable(this.authToken);
    }

    @Override
    public List<String> idSite() {
        return this.idSite;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePiwikConfig && this.equalTo((ImmutablePiwikConfig)another);
    }

    private boolean equalTo(ImmutablePiwikConfig another) {
        return this.scheme.equals(another.scheme) && this.host.equals(another.host) && this.path.equals(another.path) && Objects.equals(this.authToken, another.authToken) && this.idSite.equals(another.idSite);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.scheme.hashCode();
        h += (h << 5) + this.host.hashCode();
        h += (h << 5) + this.path.hashCode();
        h += (h << 5) + Objects.hashCode(this.authToken);
        h += (h << 5) + this.idSite.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("PiwikConfig{");
        builder.append("scheme=").append(this.scheme);
        builder.append(", ");
        builder.append("host=").append(this.host);
        builder.append(", ");
        builder.append("path=").append(this.path);
        if (this.authToken != null) {
            builder.append(", ");
            builder.append("authToken=").append(this.authToken);
        }
        builder.append(", ");
        builder.append("idSite=").append(this.idSite);
        return builder.append("}").toString();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="PiwikConfig", generator="Immutables")
    public static class Builder {
        private static final long INIT_BIT_HOST = 1L;
        private long initBits = 1L;
        private String scheme;
        private String host;
        private String path;
        private String authToken;
        private List<String> idSite = new ArrayList<String>();

        public Builder() {
            if (!(this instanceof PiwikConfig.Builder)) {
                throw new UnsupportedOperationException("Use: new PiwikConfig.Builder()");
            }
        }

        public final PiwikConfig.Builder from(PiwikConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.scheme(instance.scheme());
            this.host(instance.host());
            this.path(instance.path());
            Optional<String> authTokenOptional = instance.authToken();
            if (authTokenOptional.isPresent()) {
                this.authToken(authTokenOptional);
            }
            this.addAllIdSite(instance.idSite());
            return (PiwikConfig.Builder)this;
        }

        public final PiwikConfig.Builder scheme(String scheme) {
            this.scheme = Objects.requireNonNull(scheme, "scheme");
            return (PiwikConfig.Builder)this;
        }

        public final PiwikConfig.Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (PiwikConfig.Builder)this;
        }

        public final PiwikConfig.Builder path(String path) {
            this.path = Objects.requireNonNull(path, "path");
            return (PiwikConfig.Builder)this;
        }

        public final PiwikConfig.Builder authToken(String authToken) {
            this.authToken = Objects.requireNonNull(authToken, "authToken");
            return (PiwikConfig.Builder)this;
        }

        public final PiwikConfig.Builder authToken(Optional<String> authToken) {
            this.authToken = authToken.orElse(null);
            return (PiwikConfig.Builder)this;
        }

        public final PiwikConfig.Builder addIdSite(String element) {
            this.idSite.add(Objects.requireNonNull(element, "idSite element"));
            return (PiwikConfig.Builder)this;
        }

        public final PiwikConfig.Builder addIdSite(String ... elements) {
            for (String element : elements) {
                this.idSite.add(Objects.requireNonNull(element, "idSite element"));
            }
            return (PiwikConfig.Builder)this;
        }

        public final PiwikConfig.Builder idSite(Iterable<String> elements) {
            this.idSite.clear();
            return this.addAllIdSite(elements);
        }

        public final PiwikConfig.Builder addAllIdSite(Iterable<String> elements) {
            for (String element : elements) {
                this.idSite.add(Objects.requireNonNull(element, "idSite element"));
            }
            return (PiwikConfig.Builder)this;
        }

        public ImmutablePiwikConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePiwikConfig(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("host");
            }
            return "Cannot build PiwikConfig, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="PiwikConfig", generator="Immutables")
    private final class InitShim {
        private byte schemeBuildStage = 0;
        private String scheme;
        private byte pathBuildStage = 0;
        private String path;

        private InitShim() {
        }

        String scheme() {
            if (this.schemeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schemeBuildStage == 0) {
                this.schemeBuildStage = (byte)-1;
                this.scheme = Objects.requireNonNull(ImmutablePiwikConfig.this.schemeInitialize(), "scheme");
                this.schemeBuildStage = 1;
            }
            return this.scheme;
        }

        void scheme(String scheme) {
            this.scheme = scheme;
            this.schemeBuildStage = 1;
        }

        String path() {
            if (this.pathBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pathBuildStage == 0) {
                this.pathBuildStage = (byte)-1;
                this.path = Objects.requireNonNull(ImmutablePiwikConfig.this.pathInitialize(), "path");
                this.pathBuildStage = 1;
            }
            return this.path;
        }

        void path(String path) {
            this.path = path;
            this.pathBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.schemeBuildStage == -1) {
                attributes.add("scheme");
            }
            if (this.pathBuildStage == -1) {
                attributes.add("path");
            }
            return "Cannot build PiwikConfig, attribute initializers form cycle " + attributes;
        }
    }
}

