package ch.rasc.piwik.tracking;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link PiwikRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new PiwikRequest.Builder()}.
 */
@SuppressWarnings({"all"})
@Generated("org.immutables.processor.ProxyProcessor")
final class ImmutablePiwikRequest implements PiwikRequest {
  private final String url;
  private final List<String> idSite;
  private final Map<QueryParameter, Object> parameters;

  private ImmutablePiwikRequest(
      String url,
      List<String> idSite,
      Map<QueryParameter, Object> parameters) {
    this.url = url;
    this.idSite = idSite;
    this.parameters = parameters;
  }

  /**
   * @return The value of the {@code url} attribute
   */
  @Override
  public String url() {
    return url;
  }

  /**
   * @return The value of the {@code idSite} attribute
   */
  @Override
  public List<String> idSite() {
    return idSite;
  }

  /**
   * @return The value of the {@code parameters} attribute
   */
  @Override
  public Map<QueryParameter, Object> parameters() {
    return parameters;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PiwikRequest#url() url} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for url
   * @return A modified copy of the {@code this} object
   */
  public final ImmutablePiwikRequest withUrl(String value) {
    if (this.url.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "url");
    return new ImmutablePiwikRequest(newValue, this.idSite, this.parameters);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PiwikRequest#idSite() idSite}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePiwikRequest withIdSite(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutablePiwikRequest(this.url, newValue, this.parameters);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PiwikRequest#idSite() idSite}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of idSite elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePiwikRequest withIdSite(Iterable<String> elements) {
    if (this.idSite == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutablePiwikRequest(this.url, newValue, this.parameters);
  }

  /**
   * Copy the current immutable object by replacing the {@link PiwikRequest#parameters() parameters} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the parameters map
   * @return A modified copy of {@code this} object
   */
  public final ImmutablePiwikRequest withParameters(Map<QueryParameter, ? extends Object> entries) {
    if (this.parameters == entries) return this;
    Map<QueryParameter, Object> newValue = createUnmodifiableEnumMap(true, false, entries);
    return new ImmutablePiwikRequest(this.url, this.idSite, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePiwikRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePiwikRequest
        && equalTo((ImmutablePiwikRequest) another);
  }

  private boolean equalTo(ImmutablePiwikRequest another) {
    return url.equals(another.url)
        && idSite.equals(another.idSite)
        && parameters.equals(another.parameters);
  }

  /**
   * Computes a hash code from attributes: {@code url}, {@code idSite}, {@code parameters}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + url.hashCode();
    h += (h << 5) + idSite.hashCode();
    h += (h << 5) + parameters.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PiwikRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PiwikRequest{"
        + "url=" + url
        + ", idSite=" + idSite
        + ", parameters=" + parameters
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link PiwikRequest} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable PiwikRequest instance
   */
  public static ImmutablePiwikRequest copyOf(PiwikRequest instance) {
    if (instance instanceof ImmutablePiwikRequest) {
      return (ImmutablePiwikRequest) instance;
    }
    return new PiwikRequest.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutablePiwikRequest ImmutablePiwikRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static class Builder {
    private static final long INIT_BIT_URL = 0x1L;
    private long initBits = 0x1L;

    private String url;
    private List<String> idSite = new ArrayList<String>();
    private EnumMap<QueryParameter, Object> parameters = new EnumMap<QueryParameter, Object>(QueryParameter.class);

    /**
     * Creates a builder for {@link ImmutablePiwikRequest ImmutablePiwikRequest} instances.
     */
    public Builder() {
      if (!(this instanceof PiwikRequest.Builder)) {
        throw new UnsupportedOperationException("Use: new PiwikRequest.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code PiwikRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikRequest.Builder from(PiwikRequest instance) {
      Objects.requireNonNull(instance, "instance");
      url(instance.url());
      addAllIdSite(instance.idSite());
      putAllParameters(instance.parameters());
      return (PiwikRequest.Builder) this;
    }

    /**
     * Initializes the value for the {@link PiwikRequest#url() url} attribute.
     * @param url The value for url 
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikRequest.Builder url(String url) {
      this.url = Objects.requireNonNull(url, "url");
      initBits &= ~INIT_BIT_URL;
      return (PiwikRequest.Builder) this;
    }

    /**
     * Adds one element to {@link PiwikRequest#idSite() idSite} list.
     * @param element A idSite element
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikRequest.Builder addIdSite(String element) {
      this.idSite.add(Objects.requireNonNull(element, "idSite element"));
      return (PiwikRequest.Builder) this;
    }

    /**
     * Adds elements to {@link PiwikRequest#idSite() idSite} list.
     * @param elements An array of idSite elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikRequest.Builder addIdSite(String... elements) {
      for (String element : elements) {
        this.idSite.add(Objects.requireNonNull(element, "idSite element"));
      }
      return (PiwikRequest.Builder) this;
    }


    /**
     * Sets or replaces all elements for {@link PiwikRequest#idSite() idSite} list.
     * @param elements An iterable of idSite elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikRequest.Builder idSite(Iterable<String> elements) {
      this.idSite.clear();
      return addAllIdSite(elements);
    }

    /**
     * Adds elements to {@link PiwikRequest#idSite() idSite} list.
     * @param elements An iterable of idSite elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikRequest.Builder addAllIdSite(Iterable<String> elements) {
      for (String element : elements) {
        this.idSite.add(Objects.requireNonNull(element, "idSite element"));
      }
      return (PiwikRequest.Builder) this;
    }

    /**
     * Put one entry to the {@link PiwikRequest#parameters() parameters} map.
     * @param key The key in the parameters map
     * @param value The associated value in the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikRequest.Builder putParameter(QueryParameter key, Object value) {
      this.parameters.put(
          Objects.requireNonNull(key, "parameters key"),
          Objects.requireNonNull(value, "parameters value"));
      return (PiwikRequest.Builder) this;
    }

    /**
     * Put one entry to the {@link PiwikRequest#parameters() parameters} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikRequest.Builder putParameter(Map.Entry<QueryParameter, ? extends Object> entry) {
      QueryParameter k = entry.getKey();
      Object v = entry.getValue();
      this.parameters.put(
          Objects.requireNonNull(k, "parameters key"),
          Objects.requireNonNull(v, "parameters value"));
      return (PiwikRequest.Builder) this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link PiwikRequest#parameters() parameters} map. Nulls are not permitted
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikRequest.Builder parameters(Map<QueryParameter, ? extends Object> entries) {
      this.parameters.clear();
      return putAllParameters(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link PiwikRequest#parameters() parameters} map. Nulls are not permitted
     * @param entries The entries that will be added to the parameters map
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikRequest.Builder putAllParameters(Map<QueryParameter, ? extends Object> entries) {
      for (Map.Entry<QueryParameter, ? extends Object> e : entries.entrySet()) {
        QueryParameter k = e.getKey();
        Object v = e.getValue();
        this.parameters.put(
            Objects.requireNonNull(k, "parameters key"),
            Objects.requireNonNull(v, "parameters value"));
      }
      return (PiwikRequest.Builder) this;
    }

    /**
     * Builds a new {@link ImmutablePiwikRequest ImmutablePiwikRequest}.
     * @return An immutable instance of PiwikRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePiwikRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePiwikRequest(
          url,
          createUnmodifiableList(true, idSite),
          createUnmodifiableEnumMap(false, false, parameters));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_URL) != 0) attributes.add("url");
      return "Cannot build PiwikRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }

  private static <K extends Enum<K>, V> Map<K, V> createUnmodifiableEnumMap(boolean checkNulls, boolean skipNulls, Map<K, ? extends V> map) {
    EnumMap<K, V> enumMap = new EnumMap<>(map);
    if (checkNulls || skipNulls) {
      Iterator<? extends V> it = map.values().iterator();
      while(it.hasNext()) {
        V v = it.next();
        if (checkNulls) {
          Objects.requireNonNull(v, "value");
        } else if (skipNulls) {
          if (v == null) it.remove();
        }
      }
    }
    return Collections.unmodifiableMap(enumMap);
  }
}
