/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.piwik.tracking;

import ch.rasc.piwik.tracking.PiwikRequest;
import ch.rasc.piwik.tracking.QueryParameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class ImmutablePiwikRequest
implements PiwikRequest {
    private final String url;
    private final List<String> idSite;
    private final Map<QueryParameter, Object> parameters;

    private ImmutablePiwikRequest(String url, List<String> idSite, Map<QueryParameter, Object> parameters) {
        this.url = url;
        this.idSite = idSite;
        this.parameters = parameters;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public List<String> idSite() {
        return this.idSite;
    }

    @Override
    public Map<QueryParameter, Object> parameters() {
        return this.parameters;
    }

    public final ImmutablePiwikRequest withUrl(String value) {
        if (this.url.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "url");
        return new ImmutablePiwikRequest(newValue, this.idSite, this.parameters);
    }

    public final ImmutablePiwikRequest withIdSite(String ... elements) {
        List<String> newValue = ImmutablePiwikRequest.createUnmodifiableList(false, ImmutablePiwikRequest.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePiwikRequest(this.url, newValue, this.parameters);
    }

    public final ImmutablePiwikRequest withIdSite(Iterable<String> elements) {
        if (this.idSite == elements) {
            return this;
        }
        List<String> newValue = ImmutablePiwikRequest.createUnmodifiableList(false, ImmutablePiwikRequest.createSafeList(elements, true, false));
        return new ImmutablePiwikRequest(this.url, newValue, this.parameters);
    }

    public final ImmutablePiwikRequest withParameters(Map<QueryParameter, ? extends Object> entries) {
        if (this.parameters == entries) {
            return this;
        }
        Map<QueryParameter, Object> newValue = ImmutablePiwikRequest.createUnmodifiableEnumMap(true, false, entries);
        return new ImmutablePiwikRequest(this.url, this.idSite, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePiwikRequest && this.equalTo((ImmutablePiwikRequest)another);
    }

    private boolean equalTo(ImmutablePiwikRequest another) {
        return this.url.equals(another.url) && this.idSite.equals(another.idSite) && this.parameters.equals(another.parameters);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.url.hashCode();
        h = h * 17 + this.idSite.hashCode();
        h = h * 17 + this.parameters.hashCode();
        return h;
    }

    public String toString() {
        return "PiwikRequest{url=" + this.url + ", idSite=" + this.idSite + ", parameters=" + this.parameters + "}";
    }

    public static ImmutablePiwikRequest copyOf(PiwikRequest instance) {
        if (instance instanceof ImmutablePiwikRequest) {
            return (ImmutablePiwikRequest)instance;
        }
        return new PiwikRequest.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K extends Enum<K>, V> Map<K, V> createUnmodifiableEnumMap(boolean checkNulls, boolean skipNulls, Map<K, ? extends V> map) {
        EnumMap<K, ? extends V> enumMap = new EnumMap<K, V>(map);
        if (checkNulls || skipNulls) {
            Iterator<V> it = map.values().iterator();
            while (it.hasNext()) {
                V v = it.next();
                if (checkNulls) {
                    Objects.requireNonNull(v, "value");
                    continue;
                }
                if (!skipNulls || v != null) continue;
                it.remove();
            }
        }
        return Collections.unmodifiableMap(enumMap);
    }

    static class Builder {
        private static final long INIT_BIT_URL = 1L;
        private long initBits = 1L;
        private String url;
        private List<String> idSite = new ArrayList<String>();
        private EnumMap<QueryParameter, Object> parameters = new EnumMap(QueryParameter.class);

        Builder() {
            if (!(this instanceof PiwikRequest.Builder)) {
                throw new UnsupportedOperationException("Use: new PiwikRequest.Builder()");
            }
        }

        public final PiwikRequest.Builder from(PiwikRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.url(instance.url());
            this.addAllIdSite(instance.idSite());
            this.putAllParameters(instance.parameters());
            return (PiwikRequest.Builder)this;
        }

        public final PiwikRequest.Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (PiwikRequest.Builder)this;
        }

        public final PiwikRequest.Builder addIdSite(String element) {
            this.idSite.add(Objects.requireNonNull(element, "idSite element"));
            return (PiwikRequest.Builder)this;
        }

        public final PiwikRequest.Builder addIdSite(String ... elements) {
            for (String element : elements) {
                this.idSite.add(Objects.requireNonNull(element, "idSite element"));
            }
            return (PiwikRequest.Builder)this;
        }

        public final PiwikRequest.Builder idSite(Iterable<String> elements) {
            this.idSite.clear();
            return this.addAllIdSite(elements);
        }

        public final PiwikRequest.Builder addAllIdSite(Iterable<String> elements) {
            for (String element : elements) {
                this.idSite.add(Objects.requireNonNull(element, "idSite element"));
            }
            return (PiwikRequest.Builder)this;
        }

        public final PiwikRequest.Builder putParameter(QueryParameter key, Object value) {
            this.parameters.put((QueryParameter)((Enum)Objects.requireNonNull(key, "parameters key")), Objects.requireNonNull(value, "parameters value"));
            return (PiwikRequest.Builder)this;
        }

        public final PiwikRequest.Builder putParameter(Map.Entry<QueryParameter, ? extends Object> entry) {
            QueryParameter k = entry.getKey();
            Object v = entry.getValue();
            this.parameters.put((QueryParameter)((Enum)Objects.requireNonNull(k, "parameters key")), Objects.requireNonNull(v, "parameters value"));
            return (PiwikRequest.Builder)this;
        }

        public final PiwikRequest.Builder parameters(Map<QueryParameter, ? extends Object> parameters) {
            this.parameters.clear();
            return this.putAllParameters(parameters);
        }

        public final PiwikRequest.Builder putAllParameters(Map<QueryParameter, ? extends Object> parameters) {
            for (Map.Entry<QueryParameter, ? extends Object> entry : parameters.entrySet()) {
                QueryParameter k = entry.getKey();
                Object v = entry.getValue();
                this.parameters.put((QueryParameter)((Enum)Objects.requireNonNull(k, "parameters key")), Objects.requireNonNull(v, "parameters value"));
            }
            return (PiwikRequest.Builder)this;
        }

        public ImmutablePiwikRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePiwikRequest(this.url, ImmutablePiwikRequest.createUnmodifiableList(true, this.idSite), ImmutablePiwikRequest.createUnmodifiableEnumMap(false, false, this.parameters));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build PiwikRequest, some of required attributes are not set " + attributes;
        }
    }
}

