/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.piwik.tracking;

import ch.rasc.piwik.tracking.PiwikConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

final class ImmutablePiwikConfig
implements PiwikConfig {
    private final String host;
    private final String authToken;
    private final List<String> idSite;

    private ImmutablePiwikConfig(Builder builder) {
        this.host = builder.host;
        this.authToken = builder.authToken;
        this.idSite = ImmutablePiwikConfig.createUnmodifiableList(true, builder.idSite);
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public String authToken() {
        return this.authToken;
    }

    @Override
    public List<String> idSite() {
        return this.idSite;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePiwikConfig && this.equalTo((ImmutablePiwikConfig)another);
    }

    private boolean equalTo(ImmutablePiwikConfig another) {
        return this.host.equals(another.host) && this.authToken.equals(another.authToken) && this.idSite.equals(another.idSite);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.host.hashCode();
        h = h * 17 + this.authToken.hashCode();
        h = h * 17 + this.idSite.hashCode();
        return h;
    }

    public String toString() {
        return "PiwikConfig{host=" + this.host + ", authToken=" + this.authToken + ", idSite=" + this.idSite + "}";
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static class Builder {
        private static final long INIT_BIT_HOST = 1L;
        private static final long INIT_BIT_AUTH_TOKEN = 2L;
        private long initBits = 3L;
        private String host;
        private String authToken;
        private List<String> idSite = new ArrayList<String>();

        Builder() {
            if (!(this instanceof PiwikConfig.Builder)) {
                throw new UnsupportedOperationException("Use: new PiwikConfig.Builder()");
            }
        }

        public final PiwikConfig.Builder from(PiwikConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.host(instance.host());
            this.authToken(instance.authToken());
            this.addAllIdSite(instance.idSite());
            return (PiwikConfig.Builder)this;
        }

        public final PiwikConfig.Builder host(String host) {
            this.host = Objects.requireNonNull(host, "host");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (PiwikConfig.Builder)this;
        }

        public final PiwikConfig.Builder authToken(String authToken) {
            this.authToken = Objects.requireNonNull(authToken, "authToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (PiwikConfig.Builder)this;
        }

        public final PiwikConfig.Builder addIdSite(String element) {
            this.idSite.add(Objects.requireNonNull(element, "idSite element"));
            return (PiwikConfig.Builder)this;
        }

        public final PiwikConfig.Builder addIdSite(String ... elements) {
            for (String element : elements) {
                this.idSite.add(Objects.requireNonNull(element, "idSite element"));
            }
            return (PiwikConfig.Builder)this;
        }

        public final PiwikConfig.Builder idSite(Iterable<String> elements) {
            this.idSite.clear();
            return this.addAllIdSite(elements);
        }

        public final PiwikConfig.Builder addAllIdSite(Iterable<String> elements) {
            for (String element : elements) {
                this.idSite.add(Objects.requireNonNull(element, "idSite element"));
            }
            return (PiwikConfig.Builder)this;
        }

        public ImmutablePiwikConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePiwikConfig(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("host");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("authToken");
            }
            return "Cannot build PiwikConfig, some of required attributes are not set " + attributes;
        }
    }
}

