package ch.rasc.piwik.tracking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link PiwikConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new PiwikConfig.Builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "PiwikConfig"})
final class ImmutablePiwikConfig implements PiwikConfig {
  private final String host;
  private final String authToken;
  private final List<String> idSite;

  private ImmutablePiwikConfig(ImmutablePiwikConfig.Builder builder) {
    this.host = builder.host;
    this.authToken = builder.authToken;
    this.idSite = createUnmodifiableList(true, builder.idSite);
  }

  /**
   * @return The value of the {@code host} attribute
   */
  @Override
  public String host() {
    return host;
  }

  /**
   * @return The value of the {@code authToken} attribute
   */
  @Override
  public String authToken() {
    return authToken;
  }

  /**
   * @return The value of the {@code idSite} attribute
   */
  @Override
  public List<String> idSite() {
    return idSite;
  }

  /**
   * This instance is equal to all instances of {@code ImmutablePiwikConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutablePiwikConfig
        && equalTo((ImmutablePiwikConfig) another);
  }

  private boolean equalTo(ImmutablePiwikConfig another) {
    return host.equals(another.host)
        && authToken.equals(another.authToken)
        && idSite.equals(another.idSite);
  }

  /**
   * Computes a hash code from attributes: {@code host}, {@code authToken}, {@code idSite}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + host.hashCode();
    h = h * 17 + authToken.hashCode();
    h = h * 17 + idSite.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code PiwikConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "PiwikConfig{"
        + "host=" + host
        + ", authToken=" + authToken
        + ", idSite=" + idSite
        + "}";
  }

  /**
   * Builds instances of type {@link ImmutablePiwikConfig ImmutablePiwikConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static class Builder {
    private static final long INIT_BIT_HOST = 0x1L;
    private static final long INIT_BIT_AUTH_TOKEN = 0x2L;
    private long initBits = 0x3L;

    private String host;
    private String authToken;
    private List<String> idSite = new ArrayList<String>();

    /**
     * Creates a builder for {@link ImmutablePiwikConfig ImmutablePiwikConfig} instances.
     */
    Builder() {
      if (!(this instanceof PiwikConfig.Builder)) {
        throw new UnsupportedOperationException("Use: new PiwikConfig.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code PiwikConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikConfig.Builder from(PiwikConfig instance) {
      Objects.requireNonNull(instance, "instance");
      host(instance.host());
      authToken(instance.authToken());
      addAllIdSite(instance.idSite());
      return (PiwikConfig.Builder) this;
    }

    /**
     * Initializes the value for the {@link PiwikConfig#host() host} attribute.
     * @param host The value for host 
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikConfig.Builder host(String host) {
      this.host = Objects.requireNonNull(host, "host");
      initBits &= ~INIT_BIT_HOST;
      return (PiwikConfig.Builder) this;
    }

    /**
     * Initializes the value for the {@link PiwikConfig#authToken() authToken} attribute.
     * @param authToken The value for authToken 
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikConfig.Builder authToken(String authToken) {
      this.authToken = Objects.requireNonNull(authToken, "authToken");
      initBits &= ~INIT_BIT_AUTH_TOKEN;
      return (PiwikConfig.Builder) this;
    }

    /**
     * Adds one element to {@link PiwikConfig#idSite() idSite} list.
     * @param element A idSite element
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikConfig.Builder addIdSite(String element) {
      this.idSite.add(Objects.requireNonNull(element, "idSite element"));
      return (PiwikConfig.Builder) this;
    }

    /**
     * Adds elements to {@link PiwikConfig#idSite() idSite} list.
     * @param elements An array of idSite elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikConfig.Builder addIdSite(String... elements) {
      for (String element : elements) {
        this.idSite.add(Objects.requireNonNull(element, "idSite element"));
      }
      return (PiwikConfig.Builder) this;
    }

    /**
     * Sets or replaces all elements for {@link PiwikConfig#idSite() idSite} list.
     * @param elements An iterable of idSite elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikConfig.Builder idSite(Iterable<String> elements) {
      this.idSite.clear();
      return addAllIdSite(elements);
    }

    /**
     * Adds elements to {@link PiwikConfig#idSite() idSite} list.
     * @param elements An iterable of idSite elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final PiwikConfig.Builder addAllIdSite(Iterable<String> elements) {
      for (String element : elements) {
        this.idSite.add(Objects.requireNonNull(element, "idSite element"));
      }
      return (PiwikConfig.Builder) this;
    }

    /**
     * Builds a new {@link ImmutablePiwikConfig ImmutablePiwikConfig}.
     * @return An immutable instance of PiwikConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutablePiwikConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutablePiwikConfig(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_HOST) != 0) attributes.add("host");
      if ((initBits & INIT_BIT_AUTH_TOKEN) != 0) attributes.add("authToken");
      return "Cannot build PiwikConfig, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
