/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.forcastio.model;

import ch.rasc.forcastio.converter.FioIconDeserializer;
import ch.rasc.forcastio.model.FioDataBlock;
import ch.rasc.forcastio.model.FioDataPoint;
import ch.rasc.forcastio.model.FioIcon;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableFioDataBlock
implements FioDataBlock {
    private final String summary;
    private final FioIcon icon;
    private final List<FioDataPoint> data;

    private ImmutableFioDataBlock(String summary, FioIcon icon, List<FioDataPoint> data) {
        this.summary = summary;
        this.icon = icon;
        this.data = data;
    }

    @Override
    @JsonProperty(value="summary")
    public String summary() {
        return this.summary;
    }

    @Override
    @JsonProperty(value="icon")
    @JsonDeserialize(using=FioIconDeserializer.class)
    public FioIcon icon() {
        return this.icon;
    }

    @Override
    @JsonProperty(value="data")
    public List<FioDataPoint> data() {
        return this.data;
    }

    public final ImmutableFioDataBlock withSummary(String value) {
        if (this.summary.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "summary");
        return new ImmutableFioDataBlock(newValue, this.icon, this.data);
    }

    public final ImmutableFioDataBlock withIcon(FioIcon value) {
        if (this.icon == value) {
            return this;
        }
        FioIcon newValue = Objects.requireNonNull(value, "icon");
        return new ImmutableFioDataBlock(this.summary, newValue, this.data);
    }

    public final ImmutableFioDataBlock withData(FioDataPoint ... elements) {
        List<FioDataPoint> newValue = ImmutableFioDataBlock.createUnmodifiableList(false, ImmutableFioDataBlock.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableFioDataBlock(this.summary, this.icon, newValue);
    }

    public final ImmutableFioDataBlock withData(Iterable<? extends FioDataPoint> elements) {
        if (this.data == elements) {
            return this;
        }
        List<FioDataPoint> newValue = ImmutableFioDataBlock.createUnmodifiableList(false, ImmutableFioDataBlock.createSafeList(elements, true, false));
        return new ImmutableFioDataBlock(this.summary, this.icon, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFioDataBlock && this.equalTo((ImmutableFioDataBlock)another);
    }

    private boolean equalTo(ImmutableFioDataBlock another) {
        return this.summary.equals(another.summary) && this.icon.equals((Object)another.icon) && this.data.equals(another.data);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.summary.hashCode();
        h = h * 17 + this.icon.hashCode();
        h = h * 17 + this.data.hashCode();
        return h;
    }

    public String toString() {
        return "FioDataBlock{summary=" + this.summary + ", icon=" + (Object)((Object)this.icon) + ", data=" + this.data + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFioDataBlock fromJson(Json json) {
        Builder builder = ImmutableFioDataBlock.builder();
        if (json.summary != null) {
            builder.summary(json.summary);
        }
        if (json.icon != null) {
            builder.icon(json.icon);
        }
        if (json.data != null) {
            builder.addAllData(json.data);
        }
        return builder.build();
    }

    public static ImmutableFioDataBlock copyOf(FioDataBlock instance) {
        if (instance instanceof ImmutableFioDataBlock) {
            return (ImmutableFioDataBlock)instance;
        }
        return ImmutableFioDataBlock.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_SUMMARY = 1L;
        private static final long INIT_BIT_ICON = 2L;
        private long initBits = 3L;
        private String summary;
        private FioIcon icon;
        private List<FioDataPoint> data = new ArrayList<FioDataPoint>();

        private Builder() {
        }

        public final Builder from(FioDataBlock instance) {
            Objects.requireNonNull(instance, "instance");
            this.summary(instance.summary());
            this.icon(instance.icon());
            this.addAllData(instance.data());
            return this;
        }

        public final Builder summary(String summary) {
            this.summary = Objects.requireNonNull(summary, "summary");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder icon(FioIcon icon) {
            this.icon = Objects.requireNonNull(icon, "icon");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addData(FioDataPoint element) {
            this.data.add(Objects.requireNonNull(element, "data element"));
            return this;
        }

        public final Builder addData(FioDataPoint ... elements) {
            for (FioDataPoint element : elements) {
                this.data.add(Objects.requireNonNull(element, "data element"));
            }
            return this;
        }

        public final Builder data(Iterable<? extends FioDataPoint> elements) {
            this.data.clear();
            return this.addAllData(elements);
        }

        public final Builder addAllData(Iterable<? extends FioDataPoint> elements) {
            for (FioDataPoint fioDataPoint : elements) {
                this.data.add(Objects.requireNonNull(fioDataPoint, "data element"));
            }
            return this;
        }

        public ImmutableFioDataBlock build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFioDataBlock(this.summary, this.icon, ImmutableFioDataBlock.createUnmodifiableList(true, this.data));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("summary");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("icon");
            }
            return "Cannot build FioDataBlock, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements FioDataBlock {
        String summary;
        FioIcon icon;
        List<FioDataPoint> data = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="summary")
        public void setSummary(String summary) {
            this.summary = summary;
        }

        @JsonProperty(value="icon")
        @JsonDeserialize(using=FioIconDeserializer.class)
        public void setIcon(FioIcon icon) {
            this.icon = icon;
        }

        @JsonProperty(value="data")
        public void setData(List<FioDataPoint> data) {
            this.data = data;
        }

        @Override
        public String summary() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FioIcon icon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<FioDataPoint> data() {
            throw new UnsupportedOperationException();
        }
    }
}

