package ch.rasc.forcastio.model;

import ch.rasc.forcastio.converter.FioIconDeserializer;
import ch.rasc.forcastio.converter.FioPrecipTypeDeserializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link FioDataPoint}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFioDataPoint.builder()}.
 */
@SuppressWarnings({"all"})
@Generated({"Immutables.generator", "FioDataPoint"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableFioDataPoint extends FioDataPoint {
  private final long time;
  private final @Nullable String summary;
  private final @Nullable FioIcon icon;
  private final @Nullable Long sunriseTime;
  private final @Nullable Long sunsetTime;
  private final @Nullable BigDecimal moonPhase;
  private final @Nullable BigDecimal nearestStormDistance;
  private final @Nullable BigDecimal nearestStormBearing;
  private final @Nullable BigDecimal precipIntensity;
  private final @Nullable BigDecimal precipIntensityMax;
  private final @Nullable Long precipIntensityMaxTime;
  private final @Nullable BigDecimal precipProbability;
  private final @Nullable FioPrecipType precipType;
  private final @Nullable BigDecimal precipAccumulation;
  private final @Nullable BigDecimal temperature;
  private final @Nullable BigDecimal temperatureMin;
  private final @Nullable Long temperatureMinTime;
  private final @Nullable BigDecimal temperatureMax;
  private final @Nullable Long temperatureMaxTime;
  private final @Nullable BigDecimal apparentTemperature;
  private final @Nullable BigDecimal apparentTemperatureMin;
  private final @Nullable Long apparentTemperatureMinTime;
  private final @Nullable BigDecimal apparentTemperatureMax;
  private final @Nullable Long apparentTemperatureMaxTime;
  private final @Nullable BigDecimal dewPoint;
  private final @Nullable BigDecimal windSpeed;
  private final @Nullable BigDecimal windBearing;
  private final @Nullable BigDecimal cloudCover;
  private final @Nullable BigDecimal humidity;
  private final @Nullable BigDecimal pressure;
  private final @Nullable BigDecimal visibility;
  private final @Nullable BigDecimal ozone;

  private ImmutableFioDataPoint(
      long time,
      @Nullable String summary,
      @Nullable FioIcon icon,
      @Nullable Long sunriseTime,
      @Nullable Long sunsetTime,
      @Nullable BigDecimal moonPhase,
      @Nullable BigDecimal nearestStormDistance,
      @Nullable BigDecimal nearestStormBearing,
      @Nullable BigDecimal precipIntensity,
      @Nullable BigDecimal precipIntensityMax,
      @Nullable Long precipIntensityMaxTime,
      @Nullable BigDecimal precipProbability,
      @Nullable FioPrecipType precipType,
      @Nullable BigDecimal precipAccumulation,
      @Nullable BigDecimal temperature,
      @Nullable BigDecimal temperatureMin,
      @Nullable Long temperatureMinTime,
      @Nullable BigDecimal temperatureMax,
      @Nullable Long temperatureMaxTime,
      @Nullable BigDecimal apparentTemperature,
      @Nullable BigDecimal apparentTemperatureMin,
      @Nullable Long apparentTemperatureMinTime,
      @Nullable BigDecimal apparentTemperatureMax,
      @Nullable Long apparentTemperatureMaxTime,
      @Nullable BigDecimal dewPoint,
      @Nullable BigDecimal windSpeed,
      @Nullable BigDecimal windBearing,
      @Nullable BigDecimal cloudCover,
      @Nullable BigDecimal humidity,
      @Nullable BigDecimal pressure,
      @Nullable BigDecimal visibility,
      @Nullable BigDecimal ozone) {
    this.time = time;
    this.summary = summary;
    this.icon = icon;
    this.sunriseTime = sunriseTime;
    this.sunsetTime = sunsetTime;
    this.moonPhase = moonPhase;
    this.nearestStormDistance = nearestStormDistance;
    this.nearestStormBearing = nearestStormBearing;
    this.precipIntensity = precipIntensity;
    this.precipIntensityMax = precipIntensityMax;
    this.precipIntensityMaxTime = precipIntensityMaxTime;
    this.precipProbability = precipProbability;
    this.precipType = precipType;
    this.precipAccumulation = precipAccumulation;
    this.temperature = temperature;
    this.temperatureMin = temperatureMin;
    this.temperatureMinTime = temperatureMinTime;
    this.temperatureMax = temperatureMax;
    this.temperatureMaxTime = temperatureMaxTime;
    this.apparentTemperature = apparentTemperature;
    this.apparentTemperatureMin = apparentTemperatureMin;
    this.apparentTemperatureMinTime = apparentTemperatureMinTime;
    this.apparentTemperatureMax = apparentTemperatureMax;
    this.apparentTemperatureMaxTime = apparentTemperatureMaxTime;
    this.dewPoint = dewPoint;
    this.windSpeed = windSpeed;
    this.windBearing = windBearing;
    this.cloudCover = cloudCover;
    this.humidity = humidity;
    this.pressure = pressure;
    this.visibility = visibility;
    this.ozone = ozone;
  }

  /**
   * The UNIX time (that is, seconds since midnight GMT on 1 Jan 1970) at which this
   * data point occurs
   */
  @JsonProperty("time")
  @Override
  public long time() {
    return time;
  }

  /**
   * A human-readable text summary of this data point. (Do not use this value for
   * automated purposes: you should use the icon property, instead.)
   */
  @JsonProperty("summary")
  @Override
  public @Nullable String summary() {
    return summary;
  }

  /**
   * A machine-readable text summary of this data point, suitable for selecting an icon
   * for display.
   */
  @JsonProperty("icon")
  @JsonDeserialize(using = FioIconDeserializer.class)
  @Override
  public @Nullable FioIcon icon() {
    return icon;
  }

  /**
   * The UNIX time (that is, seconds since midnight GMT on 1 Jan 1970) of the last
   * sunrise before the solar noon closest to local noon on the given day. (Note: near
   * the poles, these may occur on a different day entirely!)
   * <p>
   * Only defined on daily data points
   */
  @JsonProperty("sunriseTime")
  @Override
  public @Nullable Long sunriseTime() {
    return sunriseTime;
  }

  /**
   * The UNIX time (that is, seconds since midnight GMT on 1 Jan 1970) of the first
   * sunset after the solar noon closest to local noon on the given day. (Note: near the
   * poles, these may occur on a different day entirely!)
   * <p>
   * Only defined on daily data points
   */
  @JsonProperty("sunsetTime")
  @Override
  public @Nullable Long sunsetTime() {
    return sunsetTime;
  }

  /**
   * A number representing the fractional part of the lunation number of the given day:
   * a value of 0 corresponds to a new moon, 0.25 to a first quarter moon, 0.5 to a full
   * moon, and 0.75 to a last quarter moon. (The ranges in between these represent
   * waxing crescent, waxing gibbous, waning gibbous, and waning crescent moons,
   * respectively.)
   * <p>
   * Only defined on daily data points
   */
  @JsonProperty("moonPhase")
  @Override
  public @Nullable BigDecimal moonPhase() {
    return moonPhase;
  }

  /**
   * A numerical value representing the distance to the nearest storm in miles. (This
   * value is very approximate and should not be used in scenarios requiring accurate
   * results. In particular, a storm distance of zero doesn't necessarily refer to a
   * storm at the requested location, but rather a storm in the vicinity of that
   * location.)
   * <p>
   * Only defined on currently data points
   */
  @JsonProperty("nearestStormDistance")
  @Override
  public @Nullable BigDecimal nearestStormDistance() {
    return nearestStormDistance;
  }

  /**
   * A numerical value representing the direction of the nearest storm in degrees, with
   * true north at 0° and progressing clockwise. (If nearestStormDistance is zero, then
   * this value will not be defined. The caveats that apply to nearestStormDistance also
   * apply to this value.)
   * <p>
   * Only defined on currently data points
   */
  @JsonProperty("nearestStormBearing")
  @Override
  public @Nullable BigDecimal nearestStormBearing() {
    return nearestStormBearing;
  }

  /**
   * A numerical value representing the average expected intensity (in inches of liquid
   * water per hour) of precipitation occurring at the given time conditional on
   * probability (that is, assuming any precipitation occurs at all). A very rough guide
   * is that a value of 0 in./hr. corresponds to no precipitation, 0.002 in./hr.
   * corresponds to very light precipitation, 0.017 in./hr. corresponds to light
   * precipitation, 0.1 in./hr. corresponds to moderate precipitation, and 0.4 in./hr.
   * corresponds to heavy precipitation.
   */
  @JsonProperty("precipIntensity")
  @Override
  public @Nullable BigDecimal precipIntensity() {
    return precipIntensity;
  }

  /**
   * Numerical values representing the maximumum expected intensity of precipitation on
   * the given day in inches of liquid water per hour.
   * <p>
   * Only defined on daily data points
   */
  @JsonProperty("precipIntensityMax")
  @Override
  public @Nullable BigDecimal precipIntensityMax() {
    return precipIntensityMax;
  }

  /**
   * The UNIX time at which {@link #precipIntensityMax()} occurs on the given day
   * <p>
   * Only defined on daily data points.
   */
  @JsonProperty("precipIntensityMaxTime")
  @Override
  public @Nullable Long precipIntensityMaxTime() {
    return precipIntensityMaxTime;
  }

  /**
   * A numerical value between 0 and 1 (inclusive) representing the probability of
   * precipitation occurring at the given time.
   */
  @JsonProperty("precipProbability")
  @Override
  public @Nullable BigDecimal precipProbability() {
    return precipProbability;
  }

  /**
   * The type of precipitation occurring at the given time. If
   * {@link #precipIntensity()} is zero, then this property will not be defined.)
   */
  @JsonProperty("precipType")
  @JsonDeserialize(using = FioPrecipTypeDeserializer.class)
  @Override
  public @Nullable FioPrecipType precipType() {
    return precipType;
  }

  /**
   * The amount of snowfall accumulation expected to occur on the given day, in inches.
   * (If no accumulation is expected, this property will not be defined.)
   * <p>
   * Only defined on hourly and daily data points
   */
  @JsonProperty("precipAccumulation")
  @Override
  public @Nullable BigDecimal precipAccumulation() {
    return precipAccumulation;
  }

  /**
   * A numerical value representing the temperature at the given time in degrees
   * Fahrenheit.
   * <p>
   * Not defined on daily data points.
   */
  @JsonProperty("temperature")
  @Override
  public @Nullable BigDecimal temperature() {
    return temperature;
  }

  /**
   * Numerical values representing the minimum temperature on the given day in degrees
   * Fahrenheit.
   * <p>
   * Only defined on daily data points.
   */
  @JsonProperty("temperatureMin")
  @Override
  public @Nullable BigDecimal temperatureMin() {
    return temperatureMin;
  }

  /**
   * The UNIX time at which {@link #temperatureMin()} occurs.
   * <p>
   * Only defined on daily data points.
   */
  @JsonProperty("temperatureMinTime")
  @Override
  public @Nullable Long temperatureMinTime() {
    return temperatureMinTime;
  }

  /**
   * A numerical value representing the maximumum temperature on the given day in
   * degrees Fahrenheit.
   * <p>
   * Only defined on daily data points.
   */
  @JsonProperty("temperatureMax")
  @Override
  public @Nullable BigDecimal temperatureMax() {
    return temperatureMax;
  }

  /**
   * The UNIX time at which {@link #temperatureMax()} occurs.
   * <p>
   * Only defined on daily data points.
   */
  @JsonProperty("temperatureMaxTime")
  @Override
  public @Nullable Long temperatureMaxTime() {
    return temperatureMaxTime;
  }

  /**
   * A numerical value representing the apparent (or "feels like") temperature at the
   * given time in degrees Fahrenheit.
   * <p>
   * Not defined on daily data points
   */
  @JsonProperty("apparentTemperature")
  @Override
  public @Nullable BigDecimal apparentTemperature() {
    return apparentTemperature;
  }

  /**
   * A numerical value representing the minimum apparent temperature on the given day in
   * degrees Fahrenheit.
   * <p>
   * Only defined on daily data points.
   */
  @JsonProperty("apparentTemperatureMin")
  @Override
  public @Nullable BigDecimal apparentTemperatureMin() {
    return apparentTemperatureMin;
  }

  /**
   * The UNIX time at which {@link #apparentTemperatureMin()} occurs.
   * <p>
   * Only defined on daily data points.
   */
  @JsonProperty("apparentTemperatureMinTime")
  @Override
  public @Nullable Long apparentTemperatureMinTime() {
    return apparentTemperatureMinTime;
  }

  /**
   * A numerical value representing the maximumum apparent temperature on the given day
   * in degrees Fahrenheit.
   * <p>
   * Only defined on daily data points.
   */
  @JsonProperty("apparentTemperatureMax")
  @Override
  public @Nullable BigDecimal apparentTemperatureMax() {
    return apparentTemperatureMax;
  }

  /**
   * The UNIX time at which {@link #apparentTemperatureMax()} occurs.
   * <p>
   * Only defined on daily data points.
   */
  @JsonProperty("apparentTemperatureMaxTime")
  @Override
  public @Nullable Long apparentTemperatureMaxTime() {
    return apparentTemperatureMaxTime;
  }

  /**
   * A numerical value representing the dew point at the given time in degrees
   * Fahrenheit.
   */
  @JsonProperty("dewPoint")
  @Override
  public @Nullable BigDecimal dewPoint() {
    return dewPoint;
  }

  /**
   * A numerical value representing the wind speed in miles per hour.
   */
  @JsonProperty("windSpeed")
  @Override
  public @Nullable BigDecimal windSpeed() {
    return windSpeed;
  }

  /**
   * A numerical value representing the direction that the wind is coming from in
   * degrees, with true north at 0° and progressing clockwise. (If windSpeed is zero,
   * then this value will not be defined.)
   */
  @JsonProperty("windBearing")
  @Override
  public @Nullable BigDecimal windBearing() {
    return windBearing;
  }

  /**
   * A numerical value between 0 and 1 (inclusive) representing the percentage of sky
   * occluded by clouds.
   */
  @JsonProperty("cloudCover")
  @Override
  public @Nullable BigDecimal cloudCover() {
    return cloudCover;
  }

  /**
   * A numerical value between 0 and 1 (inclusive) representing the relative humidity.
   */
  @JsonProperty("humidity")
  @Override
  public @Nullable BigDecimal humidity() {
    return humidity;
  }

  /**
   * A numerical value representing the sea-level air pressure in millibars.
   */
  @JsonProperty("pressure")
  @Override
  public @Nullable BigDecimal pressure() {
    return pressure;
  }

  /**
   * A numerical value representing the average visibility in miles, capped at 10 miles.
   */
  @JsonProperty("visibility")
  @Override
  public @Nullable BigDecimal visibility() {
    return visibility;
  }

  /**
   * A numerical value representing the columnar density of total atmospheric ozone at
   * the given time in Dobson units.
   */
  @JsonProperty("ozone")
  @Override
  public @Nullable BigDecimal ozone() {
    return ozone;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#time() time} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for time
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withTime(long value) {
    if (this.time == value) return this;
    return new ImmutableFioDataPoint(
        value,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#summary() summary} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for summary (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withSummary(@Nullable String value) {
    if (Objects.equals(this.summary, value)) return this;
    return new ImmutableFioDataPoint(
        this.time,
        value,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#icon() icon} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for icon (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withIcon(@Nullable FioIcon value) {
    if (this.icon == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        value,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#sunriseTime() sunriseTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sunriseTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withSunriseTime(@Nullable Long value) {
    if (Objects.equals(this.sunriseTime, value)) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        value,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#sunsetTime() sunsetTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sunsetTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withSunsetTime(@Nullable Long value) {
    if (Objects.equals(this.sunsetTime, value)) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        value,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#moonPhase() moonPhase} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for moonPhase (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withMoonPhase(@Nullable BigDecimal value) {
    if (this.moonPhase == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        value,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#nearestStormDistance() nearestStormDistance} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nearestStormDistance (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withNearestStormDistance(@Nullable BigDecimal value) {
    if (this.nearestStormDistance == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        value,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#nearestStormBearing() nearestStormBearing} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nearestStormBearing (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withNearestStormBearing(@Nullable BigDecimal value) {
    if (this.nearestStormBearing == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        value,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#precipIntensity() precipIntensity} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for precipIntensity (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withPrecipIntensity(@Nullable BigDecimal value) {
    if (this.precipIntensity == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        value,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#precipIntensityMax() precipIntensityMax} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for precipIntensityMax (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withPrecipIntensityMax(@Nullable BigDecimal value) {
    if (this.precipIntensityMax == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        value,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#precipIntensityMaxTime() precipIntensityMaxTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for precipIntensityMaxTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withPrecipIntensityMaxTime(@Nullable Long value) {
    if (Objects.equals(this.precipIntensityMaxTime, value)) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        value,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#precipProbability() precipProbability} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for precipProbability (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withPrecipProbability(@Nullable BigDecimal value) {
    if (this.precipProbability == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        value,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#precipType() precipType} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for precipType (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withPrecipType(@Nullable FioPrecipType value) {
    if (this.precipType == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        value,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#precipAccumulation() precipAccumulation} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for precipAccumulation (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withPrecipAccumulation(@Nullable BigDecimal value) {
    if (this.precipAccumulation == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        value,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#temperature() temperature} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for temperature (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withTemperature(@Nullable BigDecimal value) {
    if (this.temperature == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        value,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#temperatureMin() temperatureMin} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for temperatureMin (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withTemperatureMin(@Nullable BigDecimal value) {
    if (this.temperatureMin == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        value,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#temperatureMinTime() temperatureMinTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for temperatureMinTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withTemperatureMinTime(@Nullable Long value) {
    if (Objects.equals(this.temperatureMinTime, value)) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        value,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#temperatureMax() temperatureMax} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for temperatureMax (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withTemperatureMax(@Nullable BigDecimal value) {
    if (this.temperatureMax == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        value,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#temperatureMaxTime() temperatureMaxTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for temperatureMaxTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withTemperatureMaxTime(@Nullable Long value) {
    if (Objects.equals(this.temperatureMaxTime, value)) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        value,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#apparentTemperature() apparentTemperature} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for apparentTemperature (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withApparentTemperature(@Nullable BigDecimal value) {
    if (this.apparentTemperature == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        value,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#apparentTemperatureMin() apparentTemperatureMin} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for apparentTemperatureMin (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withApparentTemperatureMin(@Nullable BigDecimal value) {
    if (this.apparentTemperatureMin == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        value,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#apparentTemperatureMinTime() apparentTemperatureMinTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for apparentTemperatureMinTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withApparentTemperatureMinTime(@Nullable Long value) {
    if (Objects.equals(this.apparentTemperatureMinTime, value)) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        value,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#apparentTemperatureMax() apparentTemperatureMax} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for apparentTemperatureMax (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withApparentTemperatureMax(@Nullable BigDecimal value) {
    if (this.apparentTemperatureMax == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        value,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#apparentTemperatureMaxTime() apparentTemperatureMaxTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for apparentTemperatureMaxTime (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withApparentTemperatureMaxTime(@Nullable Long value) {
    if (Objects.equals(this.apparentTemperatureMaxTime, value)) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        value,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#dewPoint() dewPoint} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dewPoint (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withDewPoint(@Nullable BigDecimal value) {
    if (this.dewPoint == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        value,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#windSpeed() windSpeed} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for windSpeed (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withWindSpeed(@Nullable BigDecimal value) {
    if (this.windSpeed == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        value,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#windBearing() windBearing} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for windBearing (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withWindBearing(@Nullable BigDecimal value) {
    if (this.windBearing == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        value,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#cloudCover() cloudCover} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for cloudCover (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withCloudCover(@Nullable BigDecimal value) {
    if (this.cloudCover == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        value,
        this.humidity,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#humidity() humidity} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for humidity (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withHumidity(@Nullable BigDecimal value) {
    if (this.humidity == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        value,
        this.pressure,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#pressure() pressure} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for pressure (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withPressure(@Nullable BigDecimal value) {
    if (this.pressure == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        value,
        this.visibility,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#visibility() visibility} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for visibility (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withVisibility(@Nullable BigDecimal value) {
    if (this.visibility == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        value,
        this.ozone);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataPoint#ozone() ozone} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ozone (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataPoint withOzone(@Nullable BigDecimal value) {
    if (this.ozone == value) return this;
    return new ImmutableFioDataPoint(
        this.time,
        this.summary,
        this.icon,
        this.sunriseTime,
        this.sunsetTime,
        this.moonPhase,
        this.nearestStormDistance,
        this.nearestStormBearing,
        this.precipIntensity,
        this.precipIntensityMax,
        this.precipIntensityMaxTime,
        this.precipProbability,
        this.precipType,
        this.precipAccumulation,
        this.temperature,
        this.temperatureMin,
        this.temperatureMinTime,
        this.temperatureMax,
        this.temperatureMaxTime,
        this.apparentTemperature,
        this.apparentTemperatureMin,
        this.apparentTemperatureMinTime,
        this.apparentTemperatureMax,
        this.apparentTemperatureMaxTime,
        this.dewPoint,
        this.windSpeed,
        this.windBearing,
        this.cloudCover,
        this.humidity,
        this.pressure,
        this.visibility,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFioDataPoint} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFioDataPoint
        && equalTo((ImmutableFioDataPoint) another);
  }

  private boolean equalTo(ImmutableFioDataPoint another) {
    return time == another.time
        && Objects.equals(summary, another.summary)
        && Objects.equals(icon, another.icon)
        && Objects.equals(sunriseTime, another.sunriseTime)
        && Objects.equals(sunsetTime, another.sunsetTime)
        && Objects.equals(moonPhase, another.moonPhase)
        && Objects.equals(nearestStormDistance, another.nearestStormDistance)
        && Objects.equals(nearestStormBearing, another.nearestStormBearing)
        && Objects.equals(precipIntensity, another.precipIntensity)
        && Objects.equals(precipIntensityMax, another.precipIntensityMax)
        && Objects.equals(precipIntensityMaxTime, another.precipIntensityMaxTime)
        && Objects.equals(precipProbability, another.precipProbability)
        && Objects.equals(precipType, another.precipType)
        && Objects.equals(precipAccumulation, another.precipAccumulation)
        && Objects.equals(temperature, another.temperature)
        && Objects.equals(temperatureMin, another.temperatureMin)
        && Objects.equals(temperatureMinTime, another.temperatureMinTime)
        && Objects.equals(temperatureMax, another.temperatureMax)
        && Objects.equals(temperatureMaxTime, another.temperatureMaxTime)
        && Objects.equals(apparentTemperature, another.apparentTemperature)
        && Objects.equals(apparentTemperatureMin, another.apparentTemperatureMin)
        && Objects.equals(apparentTemperatureMinTime, another.apparentTemperatureMinTime)
        && Objects.equals(apparentTemperatureMax, another.apparentTemperatureMax)
        && Objects.equals(apparentTemperatureMaxTime, another.apparentTemperatureMaxTime)
        && Objects.equals(dewPoint, another.dewPoint)
        && Objects.equals(windSpeed, another.windSpeed)
        && Objects.equals(windBearing, another.windBearing)
        && Objects.equals(cloudCover, another.cloudCover)
        && Objects.equals(humidity, another.humidity)
        && Objects.equals(pressure, another.pressure)
        && Objects.equals(visibility, another.visibility)
        && Objects.equals(ozone, another.ozone);
  }

  /**
   * Computes a hash code from attributes: {@code time}, {@code summary}, {@code icon}, {@code sunriseTime}, {@code sunsetTime}, {@code moonPhase}, {@code nearestStormDistance}, {@code nearestStormBearing}, {@code precipIntensity}, {@code precipIntensityMax}, {@code precipIntensityMaxTime}, {@code precipProbability}, {@code precipType}, {@code precipAccumulation}, {@code temperature}, {@code temperatureMin}, {@code temperatureMinTime}, {@code temperatureMax}, {@code temperatureMaxTime}, {@code apparentTemperature}, {@code apparentTemperatureMin}, {@code apparentTemperatureMinTime}, {@code apparentTemperatureMax}, {@code apparentTemperatureMaxTime}, {@code dewPoint}, {@code windSpeed}, {@code windBearing}, {@code cloudCover}, {@code humidity}, {@code pressure}, {@code visibility}, {@code ozone}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Long.hashCode(time);
    h = h * 17 + Objects.hashCode(summary);
    h = h * 17 + Objects.hashCode(icon);
    h = h * 17 + Objects.hashCode(sunriseTime);
    h = h * 17 + Objects.hashCode(sunsetTime);
    h = h * 17 + Objects.hashCode(moonPhase);
    h = h * 17 + Objects.hashCode(nearestStormDistance);
    h = h * 17 + Objects.hashCode(nearestStormBearing);
    h = h * 17 + Objects.hashCode(precipIntensity);
    h = h * 17 + Objects.hashCode(precipIntensityMax);
    h = h * 17 + Objects.hashCode(precipIntensityMaxTime);
    h = h * 17 + Objects.hashCode(precipProbability);
    h = h * 17 + Objects.hashCode(precipType);
    h = h * 17 + Objects.hashCode(precipAccumulation);
    h = h * 17 + Objects.hashCode(temperature);
    h = h * 17 + Objects.hashCode(temperatureMin);
    h = h * 17 + Objects.hashCode(temperatureMinTime);
    h = h * 17 + Objects.hashCode(temperatureMax);
    h = h * 17 + Objects.hashCode(temperatureMaxTime);
    h = h * 17 + Objects.hashCode(apparentTemperature);
    h = h * 17 + Objects.hashCode(apparentTemperatureMin);
    h = h * 17 + Objects.hashCode(apparentTemperatureMinTime);
    h = h * 17 + Objects.hashCode(apparentTemperatureMax);
    h = h * 17 + Objects.hashCode(apparentTemperatureMaxTime);
    h = h * 17 + Objects.hashCode(dewPoint);
    h = h * 17 + Objects.hashCode(windSpeed);
    h = h * 17 + Objects.hashCode(windBearing);
    h = h * 17 + Objects.hashCode(cloudCover);
    h = h * 17 + Objects.hashCode(humidity);
    h = h * 17 + Objects.hashCode(pressure);
    h = h * 17 + Objects.hashCode(visibility);
    h = h * 17 + Objects.hashCode(ozone);
    return h;
  }

  /**
   * Prints the immutable value {@code FioDataPoint} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FioDataPoint{"
        + "time=" + time
        + ", summary=" + summary
        + ", icon=" + icon
        + ", sunriseTime=" + sunriseTime
        + ", sunsetTime=" + sunsetTime
        + ", moonPhase=" + moonPhase
        + ", nearestStormDistance=" + nearestStormDistance
        + ", nearestStormBearing=" + nearestStormBearing
        + ", precipIntensity=" + precipIntensity
        + ", precipIntensityMax=" + precipIntensityMax
        + ", precipIntensityMaxTime=" + precipIntensityMaxTime
        + ", precipProbability=" + precipProbability
        + ", precipType=" + precipType
        + ", precipAccumulation=" + precipAccumulation
        + ", temperature=" + temperature
        + ", temperatureMin=" + temperatureMin
        + ", temperatureMinTime=" + temperatureMinTime
        + ", temperatureMax=" + temperatureMax
        + ", temperatureMaxTime=" + temperatureMaxTime
        + ", apparentTemperature=" + apparentTemperature
        + ", apparentTemperatureMin=" + apparentTemperatureMin
        + ", apparentTemperatureMinTime=" + apparentTemperatureMinTime
        + ", apparentTemperatureMax=" + apparentTemperatureMax
        + ", apparentTemperatureMaxTime=" + apparentTemperatureMaxTime
        + ", dewPoint=" + dewPoint
        + ", windSpeed=" + windSpeed
        + ", windBearing=" + windBearing
        + ", cloudCover=" + cloudCover
        + ", humidity=" + humidity
        + ", pressure=" + pressure
        + ", visibility=" + visibility
        + ", ozone=" + ozone
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends FioDataPoint {
    long time;
    boolean timeIsSet;
    String summary;
    FioIcon icon;
    Long sunriseTime;
    Long sunsetTime;
    BigDecimal moonPhase;
    BigDecimal nearestStormDistance;
    BigDecimal nearestStormBearing;
    BigDecimal precipIntensity;
    BigDecimal precipIntensityMax;
    Long precipIntensityMaxTime;
    BigDecimal precipProbability;
    FioPrecipType precipType;
    BigDecimal precipAccumulation;
    BigDecimal temperature;
    BigDecimal temperatureMin;
    Long temperatureMinTime;
    BigDecimal temperatureMax;
    Long temperatureMaxTime;
    BigDecimal apparentTemperature;
    BigDecimal apparentTemperatureMin;
    Long apparentTemperatureMinTime;
    BigDecimal apparentTemperatureMax;
    Long apparentTemperatureMaxTime;
    BigDecimal dewPoint;
    BigDecimal windSpeed;
    BigDecimal windBearing;
    BigDecimal cloudCover;
    BigDecimal humidity;
    BigDecimal pressure;
    BigDecimal visibility;
    BigDecimal ozone;
    @JsonProperty("time")
    public void setTime(long time) {
      this.time = time;
      this.timeIsSet = true;
    }
    @JsonProperty("summary")
    public void setSummary(@Nullable String summary) {
      this.summary = summary;
    }
    @JsonProperty("icon")
    @JsonDeserialize(using = FioIconDeserializer.class)
    public void setIcon(@Nullable FioIcon icon) {
      this.icon = icon;
    }
    @JsonProperty("sunriseTime")
    public void setSunriseTime(@Nullable Long sunriseTime) {
      this.sunriseTime = sunriseTime;
    }
    @JsonProperty("sunsetTime")
    public void setSunsetTime(@Nullable Long sunsetTime) {
      this.sunsetTime = sunsetTime;
    }
    @JsonProperty("moonPhase")
    public void setMoonPhase(@Nullable BigDecimal moonPhase) {
      this.moonPhase = moonPhase;
    }
    @JsonProperty("nearestStormDistance")
    public void setNearestStormDistance(@Nullable BigDecimal nearestStormDistance) {
      this.nearestStormDistance = nearestStormDistance;
    }
    @JsonProperty("nearestStormBearing")
    public void setNearestStormBearing(@Nullable BigDecimal nearestStormBearing) {
      this.nearestStormBearing = nearestStormBearing;
    }
    @JsonProperty("precipIntensity")
    public void setPrecipIntensity(@Nullable BigDecimal precipIntensity) {
      this.precipIntensity = precipIntensity;
    }
    @JsonProperty("precipIntensityMax")
    public void setPrecipIntensityMax(@Nullable BigDecimal precipIntensityMax) {
      this.precipIntensityMax = precipIntensityMax;
    }
    @JsonProperty("precipIntensityMaxTime")
    public void setPrecipIntensityMaxTime(@Nullable Long precipIntensityMaxTime) {
      this.precipIntensityMaxTime = precipIntensityMaxTime;
    }
    @JsonProperty("precipProbability")
    public void setPrecipProbability(@Nullable BigDecimal precipProbability) {
      this.precipProbability = precipProbability;
    }
    @JsonProperty("precipType")
    @JsonDeserialize(using = FioPrecipTypeDeserializer.class)
    public void setPrecipType(@Nullable FioPrecipType precipType) {
      this.precipType = precipType;
    }
    @JsonProperty("precipAccumulation")
    public void setPrecipAccumulation(@Nullable BigDecimal precipAccumulation) {
      this.precipAccumulation = precipAccumulation;
    }
    @JsonProperty("temperature")
    public void setTemperature(@Nullable BigDecimal temperature) {
      this.temperature = temperature;
    }
    @JsonProperty("temperatureMin")
    public void setTemperatureMin(@Nullable BigDecimal temperatureMin) {
      this.temperatureMin = temperatureMin;
    }
    @JsonProperty("temperatureMinTime")
    public void setTemperatureMinTime(@Nullable Long temperatureMinTime) {
      this.temperatureMinTime = temperatureMinTime;
    }
    @JsonProperty("temperatureMax")
    public void setTemperatureMax(@Nullable BigDecimal temperatureMax) {
      this.temperatureMax = temperatureMax;
    }
    @JsonProperty("temperatureMaxTime")
    public void setTemperatureMaxTime(@Nullable Long temperatureMaxTime) {
      this.temperatureMaxTime = temperatureMaxTime;
    }
    @JsonProperty("apparentTemperature")
    public void setApparentTemperature(@Nullable BigDecimal apparentTemperature) {
      this.apparentTemperature = apparentTemperature;
    }
    @JsonProperty("apparentTemperatureMin")
    public void setApparentTemperatureMin(@Nullable BigDecimal apparentTemperatureMin) {
      this.apparentTemperatureMin = apparentTemperatureMin;
    }
    @JsonProperty("apparentTemperatureMinTime")
    public void setApparentTemperatureMinTime(@Nullable Long apparentTemperatureMinTime) {
      this.apparentTemperatureMinTime = apparentTemperatureMinTime;
    }
    @JsonProperty("apparentTemperatureMax")
    public void setApparentTemperatureMax(@Nullable BigDecimal apparentTemperatureMax) {
      this.apparentTemperatureMax = apparentTemperatureMax;
    }
    @JsonProperty("apparentTemperatureMaxTime")
    public void setApparentTemperatureMaxTime(@Nullable Long apparentTemperatureMaxTime) {
      this.apparentTemperatureMaxTime = apparentTemperatureMaxTime;
    }
    @JsonProperty("dewPoint")
    public void setDewPoint(@Nullable BigDecimal dewPoint) {
      this.dewPoint = dewPoint;
    }
    @JsonProperty("windSpeed")
    public void setWindSpeed(@Nullable BigDecimal windSpeed) {
      this.windSpeed = windSpeed;
    }
    @JsonProperty("windBearing")
    public void setWindBearing(@Nullable BigDecimal windBearing) {
      this.windBearing = windBearing;
    }
    @JsonProperty("cloudCover")
    public void setCloudCover(@Nullable BigDecimal cloudCover) {
      this.cloudCover = cloudCover;
    }
    @JsonProperty("humidity")
    public void setHumidity(@Nullable BigDecimal humidity) {
      this.humidity = humidity;
    }
    @JsonProperty("pressure")
    public void setPressure(@Nullable BigDecimal pressure) {
      this.pressure = pressure;
    }
    @JsonProperty("visibility")
    public void setVisibility(@Nullable BigDecimal visibility) {
      this.visibility = visibility;
    }
    @JsonProperty("ozone")
    public void setOzone(@Nullable BigDecimal ozone) {
      this.ozone = ozone;
    }
    @Override
    public long time() { throw new UnsupportedOperationException(); }
    @Override
    public String summary() { throw new UnsupportedOperationException(); }
    @Override
    public FioIcon icon() { throw new UnsupportedOperationException(); }
    @Override
    public Long sunriseTime() { throw new UnsupportedOperationException(); }
    @Override
    public Long sunsetTime() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal moonPhase() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal nearestStormDistance() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal nearestStormBearing() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal precipIntensity() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal precipIntensityMax() { throw new UnsupportedOperationException(); }
    @Override
    public Long precipIntensityMaxTime() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal precipProbability() { throw new UnsupportedOperationException(); }
    @Override
    public FioPrecipType precipType() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal precipAccumulation() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal temperature() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal temperatureMin() { throw new UnsupportedOperationException(); }
    @Override
    public Long temperatureMinTime() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal temperatureMax() { throw new UnsupportedOperationException(); }
    @Override
    public Long temperatureMaxTime() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal apparentTemperature() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal apparentTemperatureMin() { throw new UnsupportedOperationException(); }
    @Override
    public Long apparentTemperatureMinTime() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal apparentTemperatureMax() { throw new UnsupportedOperationException(); }
    @Override
    public Long apparentTemperatureMaxTime() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal dewPoint() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal windSpeed() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal windBearing() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal cloudCover() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal humidity() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal pressure() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal visibility() { throw new UnsupportedOperationException(); }
    @Override
    public BigDecimal ozone() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableFioDataPoint fromJson(Json json) {
    ImmutableFioDataPoint.Builder builder = ImmutableFioDataPoint.builder();
    if (json.timeIsSet) {
      builder.time(json.time);
    }
    if (json.summary != null) {
      builder.summary(json.summary);
    }
    if (json.icon != null) {
      builder.icon(json.icon);
    }
    if (json.sunriseTime != null) {
      builder.sunriseTime(json.sunriseTime);
    }
    if (json.sunsetTime != null) {
      builder.sunsetTime(json.sunsetTime);
    }
    if (json.moonPhase != null) {
      builder.moonPhase(json.moonPhase);
    }
    if (json.nearestStormDistance != null) {
      builder.nearestStormDistance(json.nearestStormDistance);
    }
    if (json.nearestStormBearing != null) {
      builder.nearestStormBearing(json.nearestStormBearing);
    }
    if (json.precipIntensity != null) {
      builder.precipIntensity(json.precipIntensity);
    }
    if (json.precipIntensityMax != null) {
      builder.precipIntensityMax(json.precipIntensityMax);
    }
    if (json.precipIntensityMaxTime != null) {
      builder.precipIntensityMaxTime(json.precipIntensityMaxTime);
    }
    if (json.precipProbability != null) {
      builder.precipProbability(json.precipProbability);
    }
    if (json.precipType != null) {
      builder.precipType(json.precipType);
    }
    if (json.precipAccumulation != null) {
      builder.precipAccumulation(json.precipAccumulation);
    }
    if (json.temperature != null) {
      builder.temperature(json.temperature);
    }
    if (json.temperatureMin != null) {
      builder.temperatureMin(json.temperatureMin);
    }
    if (json.temperatureMinTime != null) {
      builder.temperatureMinTime(json.temperatureMinTime);
    }
    if (json.temperatureMax != null) {
      builder.temperatureMax(json.temperatureMax);
    }
    if (json.temperatureMaxTime != null) {
      builder.temperatureMaxTime(json.temperatureMaxTime);
    }
    if (json.apparentTemperature != null) {
      builder.apparentTemperature(json.apparentTemperature);
    }
    if (json.apparentTemperatureMin != null) {
      builder.apparentTemperatureMin(json.apparentTemperatureMin);
    }
    if (json.apparentTemperatureMinTime != null) {
      builder.apparentTemperatureMinTime(json.apparentTemperatureMinTime);
    }
    if (json.apparentTemperatureMax != null) {
      builder.apparentTemperatureMax(json.apparentTemperatureMax);
    }
    if (json.apparentTemperatureMaxTime != null) {
      builder.apparentTemperatureMaxTime(json.apparentTemperatureMaxTime);
    }
    if (json.dewPoint != null) {
      builder.dewPoint(json.dewPoint);
    }
    if (json.windSpeed != null) {
      builder.windSpeed(json.windSpeed);
    }
    if (json.windBearing != null) {
      builder.windBearing(json.windBearing);
    }
    if (json.cloudCover != null) {
      builder.cloudCover(json.cloudCover);
    }
    if (json.humidity != null) {
      builder.humidity(json.humidity);
    }
    if (json.pressure != null) {
      builder.pressure(json.pressure);
    }
    if (json.visibility != null) {
      builder.visibility(json.visibility);
    }
    if (json.ozone != null) {
      builder.ozone(json.ozone);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FioDataPoint} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FioDataPoint instance
   */
  public static ImmutableFioDataPoint copyOf(FioDataPoint instance) {
    if (instance instanceof ImmutableFioDataPoint) {
      return (ImmutableFioDataPoint) instance;
    }
    return ImmutableFioDataPoint.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFioDataPoint ImmutableFioDataPoint}.
   * @return A new ImmutableFioDataPoint builder
   */
  public static ImmutableFioDataPoint.Builder builder() {
    return new ImmutableFioDataPoint.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFioDataPoint ImmutableFioDataPoint}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_TIME = 0x1L;
    private long initBits = 0x1L;

    private long time;
    private String summary;
    private FioIcon icon;
    private Long sunriseTime;
    private Long sunsetTime;
    private BigDecimal moonPhase;
    private BigDecimal nearestStormDistance;
    private BigDecimal nearestStormBearing;
    private BigDecimal precipIntensity;
    private BigDecimal precipIntensityMax;
    private Long precipIntensityMaxTime;
    private BigDecimal precipProbability;
    private FioPrecipType precipType;
    private BigDecimal precipAccumulation;
    private BigDecimal temperature;
    private BigDecimal temperatureMin;
    private Long temperatureMinTime;
    private BigDecimal temperatureMax;
    private Long temperatureMaxTime;
    private BigDecimal apparentTemperature;
    private BigDecimal apparentTemperatureMin;
    private Long apparentTemperatureMinTime;
    private BigDecimal apparentTemperatureMax;
    private Long apparentTemperatureMaxTime;
    private BigDecimal dewPoint;
    private BigDecimal windSpeed;
    private BigDecimal windBearing;
    private BigDecimal cloudCover;
    private BigDecimal humidity;
    private BigDecimal pressure;
    private BigDecimal visibility;
    private BigDecimal ozone;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FioDataPoint} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FioDataPoint instance) {
      Objects.requireNonNull(instance, "instance");
      time(instance.time());
      @Nullable String summaryValue = instance.summary();
      if (summaryValue != null) {
        summary(summaryValue);
      }
      @Nullable FioIcon iconValue = instance.icon();
      if (iconValue != null) {
        icon(iconValue);
      }
      @Nullable Long sunriseTimeValue = instance.sunriseTime();
      if (sunriseTimeValue != null) {
        sunriseTime(sunriseTimeValue);
      }
      @Nullable Long sunsetTimeValue = instance.sunsetTime();
      if (sunsetTimeValue != null) {
        sunsetTime(sunsetTimeValue);
      }
      @Nullable BigDecimal moonPhaseValue = instance.moonPhase();
      if (moonPhaseValue != null) {
        moonPhase(moonPhaseValue);
      }
      @Nullable BigDecimal nearestStormDistanceValue = instance.nearestStormDistance();
      if (nearestStormDistanceValue != null) {
        nearestStormDistance(nearestStormDistanceValue);
      }
      @Nullable BigDecimal nearestStormBearingValue = instance.nearestStormBearing();
      if (nearestStormBearingValue != null) {
        nearestStormBearing(nearestStormBearingValue);
      }
      @Nullable BigDecimal precipIntensityValue = instance.precipIntensity();
      if (precipIntensityValue != null) {
        precipIntensity(precipIntensityValue);
      }
      @Nullable BigDecimal precipIntensityMaxValue = instance.precipIntensityMax();
      if (precipIntensityMaxValue != null) {
        precipIntensityMax(precipIntensityMaxValue);
      }
      @Nullable Long precipIntensityMaxTimeValue = instance.precipIntensityMaxTime();
      if (precipIntensityMaxTimeValue != null) {
        precipIntensityMaxTime(precipIntensityMaxTimeValue);
      }
      @Nullable BigDecimal precipProbabilityValue = instance.precipProbability();
      if (precipProbabilityValue != null) {
        precipProbability(precipProbabilityValue);
      }
      @Nullable FioPrecipType precipTypeValue = instance.precipType();
      if (precipTypeValue != null) {
        precipType(precipTypeValue);
      }
      @Nullable BigDecimal precipAccumulationValue = instance.precipAccumulation();
      if (precipAccumulationValue != null) {
        precipAccumulation(precipAccumulationValue);
      }
      @Nullable BigDecimal temperatureValue = instance.temperature();
      if (temperatureValue != null) {
        temperature(temperatureValue);
      }
      @Nullable BigDecimal temperatureMinValue = instance.temperatureMin();
      if (temperatureMinValue != null) {
        temperatureMin(temperatureMinValue);
      }
      @Nullable Long temperatureMinTimeValue = instance.temperatureMinTime();
      if (temperatureMinTimeValue != null) {
        temperatureMinTime(temperatureMinTimeValue);
      }
      @Nullable BigDecimal temperatureMaxValue = instance.temperatureMax();
      if (temperatureMaxValue != null) {
        temperatureMax(temperatureMaxValue);
      }
      @Nullable Long temperatureMaxTimeValue = instance.temperatureMaxTime();
      if (temperatureMaxTimeValue != null) {
        temperatureMaxTime(temperatureMaxTimeValue);
      }
      @Nullable BigDecimal apparentTemperatureValue = instance.apparentTemperature();
      if (apparentTemperatureValue != null) {
        apparentTemperature(apparentTemperatureValue);
      }
      @Nullable BigDecimal apparentTemperatureMinValue = instance.apparentTemperatureMin();
      if (apparentTemperatureMinValue != null) {
        apparentTemperatureMin(apparentTemperatureMinValue);
      }
      @Nullable Long apparentTemperatureMinTimeValue = instance.apparentTemperatureMinTime();
      if (apparentTemperatureMinTimeValue != null) {
        apparentTemperatureMinTime(apparentTemperatureMinTimeValue);
      }
      @Nullable BigDecimal apparentTemperatureMaxValue = instance.apparentTemperatureMax();
      if (apparentTemperatureMaxValue != null) {
        apparentTemperatureMax(apparentTemperatureMaxValue);
      }
      @Nullable Long apparentTemperatureMaxTimeValue = instance.apparentTemperatureMaxTime();
      if (apparentTemperatureMaxTimeValue != null) {
        apparentTemperatureMaxTime(apparentTemperatureMaxTimeValue);
      }
      @Nullable BigDecimal dewPointValue = instance.dewPoint();
      if (dewPointValue != null) {
        dewPoint(dewPointValue);
      }
      @Nullable BigDecimal windSpeedValue = instance.windSpeed();
      if (windSpeedValue != null) {
        windSpeed(windSpeedValue);
      }
      @Nullable BigDecimal windBearingValue = instance.windBearing();
      if (windBearingValue != null) {
        windBearing(windBearingValue);
      }
      @Nullable BigDecimal cloudCoverValue = instance.cloudCover();
      if (cloudCoverValue != null) {
        cloudCover(cloudCoverValue);
      }
      @Nullable BigDecimal humidityValue = instance.humidity();
      if (humidityValue != null) {
        humidity(humidityValue);
      }
      @Nullable BigDecimal pressureValue = instance.pressure();
      if (pressureValue != null) {
        pressure(pressureValue);
      }
      @Nullable BigDecimal visibilityValue = instance.visibility();
      if (visibilityValue != null) {
        visibility(visibilityValue);
      }
      @Nullable BigDecimal ozoneValue = instance.ozone();
      if (ozoneValue != null) {
        ozone(ozoneValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#time() time} attribute.
     * @param time The value for time 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder time(long time) {
      this.time = time;
      initBits &= ~INIT_BIT_TIME;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#summary() summary} attribute.
     * @param summary The value for summary (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder summary(@Nullable String summary) {
      this.summary = summary;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#icon() icon} attribute.
     * @param icon The value for icon (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder icon(@Nullable FioIcon icon) {
      this.icon = icon;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#sunriseTime() sunriseTime} attribute.
     * @param sunriseTime The value for sunriseTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sunriseTime(@Nullable Long sunriseTime) {
      this.sunriseTime = sunriseTime;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#sunsetTime() sunsetTime} attribute.
     * @param sunsetTime The value for sunsetTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder sunsetTime(@Nullable Long sunsetTime) {
      this.sunsetTime = sunsetTime;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#moonPhase() moonPhase} attribute.
     * @param moonPhase The value for moonPhase (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder moonPhase(@Nullable BigDecimal moonPhase) {
      this.moonPhase = moonPhase;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#nearestStormDistance() nearestStormDistance} attribute.
     * @param nearestStormDistance The value for nearestStormDistance (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nearestStormDistance(@Nullable BigDecimal nearestStormDistance) {
      this.nearestStormDistance = nearestStormDistance;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#nearestStormBearing() nearestStormBearing} attribute.
     * @param nearestStormBearing The value for nearestStormBearing (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nearestStormBearing(@Nullable BigDecimal nearestStormBearing) {
      this.nearestStormBearing = nearestStormBearing;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#precipIntensity() precipIntensity} attribute.
     * @param precipIntensity The value for precipIntensity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder precipIntensity(@Nullable BigDecimal precipIntensity) {
      this.precipIntensity = precipIntensity;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#precipIntensityMax() precipIntensityMax} attribute.
     * @param precipIntensityMax The value for precipIntensityMax (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder precipIntensityMax(@Nullable BigDecimal precipIntensityMax) {
      this.precipIntensityMax = precipIntensityMax;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#precipIntensityMaxTime() precipIntensityMaxTime} attribute.
     * @param precipIntensityMaxTime The value for precipIntensityMaxTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder precipIntensityMaxTime(@Nullable Long precipIntensityMaxTime) {
      this.precipIntensityMaxTime = precipIntensityMaxTime;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#precipProbability() precipProbability} attribute.
     * @param precipProbability The value for precipProbability (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder precipProbability(@Nullable BigDecimal precipProbability) {
      this.precipProbability = precipProbability;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#precipType() precipType} attribute.
     * @param precipType The value for precipType (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder precipType(@Nullable FioPrecipType precipType) {
      this.precipType = precipType;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#precipAccumulation() precipAccumulation} attribute.
     * @param precipAccumulation The value for precipAccumulation (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder precipAccumulation(@Nullable BigDecimal precipAccumulation) {
      this.precipAccumulation = precipAccumulation;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#temperature() temperature} attribute.
     * @param temperature The value for temperature (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder temperature(@Nullable BigDecimal temperature) {
      this.temperature = temperature;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#temperatureMin() temperatureMin} attribute.
     * @param temperatureMin The value for temperatureMin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder temperatureMin(@Nullable BigDecimal temperatureMin) {
      this.temperatureMin = temperatureMin;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#temperatureMinTime() temperatureMinTime} attribute.
     * @param temperatureMinTime The value for temperatureMinTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder temperatureMinTime(@Nullable Long temperatureMinTime) {
      this.temperatureMinTime = temperatureMinTime;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#temperatureMax() temperatureMax} attribute.
     * @param temperatureMax The value for temperatureMax (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder temperatureMax(@Nullable BigDecimal temperatureMax) {
      this.temperatureMax = temperatureMax;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#temperatureMaxTime() temperatureMaxTime} attribute.
     * @param temperatureMaxTime The value for temperatureMaxTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder temperatureMaxTime(@Nullable Long temperatureMaxTime) {
      this.temperatureMaxTime = temperatureMaxTime;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#apparentTemperature() apparentTemperature} attribute.
     * @param apparentTemperature The value for apparentTemperature (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder apparentTemperature(@Nullable BigDecimal apparentTemperature) {
      this.apparentTemperature = apparentTemperature;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#apparentTemperatureMin() apparentTemperatureMin} attribute.
     * @param apparentTemperatureMin The value for apparentTemperatureMin (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder apparentTemperatureMin(@Nullable BigDecimal apparentTemperatureMin) {
      this.apparentTemperatureMin = apparentTemperatureMin;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#apparentTemperatureMinTime() apparentTemperatureMinTime} attribute.
     * @param apparentTemperatureMinTime The value for apparentTemperatureMinTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder apparentTemperatureMinTime(@Nullable Long apparentTemperatureMinTime) {
      this.apparentTemperatureMinTime = apparentTemperatureMinTime;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#apparentTemperatureMax() apparentTemperatureMax} attribute.
     * @param apparentTemperatureMax The value for apparentTemperatureMax (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder apparentTemperatureMax(@Nullable BigDecimal apparentTemperatureMax) {
      this.apparentTemperatureMax = apparentTemperatureMax;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#apparentTemperatureMaxTime() apparentTemperatureMaxTime} attribute.
     * @param apparentTemperatureMaxTime The value for apparentTemperatureMaxTime (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder apparentTemperatureMaxTime(@Nullable Long apparentTemperatureMaxTime) {
      this.apparentTemperatureMaxTime = apparentTemperatureMaxTime;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#dewPoint() dewPoint} attribute.
     * @param dewPoint The value for dewPoint (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder dewPoint(@Nullable BigDecimal dewPoint) {
      this.dewPoint = dewPoint;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#windSpeed() windSpeed} attribute.
     * @param windSpeed The value for windSpeed (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder windSpeed(@Nullable BigDecimal windSpeed) {
      this.windSpeed = windSpeed;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#windBearing() windBearing} attribute.
     * @param windBearing The value for windBearing (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder windBearing(@Nullable BigDecimal windBearing) {
      this.windBearing = windBearing;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#cloudCover() cloudCover} attribute.
     * @param cloudCover The value for cloudCover (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder cloudCover(@Nullable BigDecimal cloudCover) {
      this.cloudCover = cloudCover;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#humidity() humidity} attribute.
     * @param humidity The value for humidity (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder humidity(@Nullable BigDecimal humidity) {
      this.humidity = humidity;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#pressure() pressure} attribute.
     * @param pressure The value for pressure (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder pressure(@Nullable BigDecimal pressure) {
      this.pressure = pressure;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#visibility() visibility} attribute.
     * @param visibility The value for visibility (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder visibility(@Nullable BigDecimal visibility) {
      this.visibility = visibility;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataPoint#ozone() ozone} attribute.
     * @param ozone The value for ozone (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ozone(@Nullable BigDecimal ozone) {
      this.ozone = ozone;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFioDataPoint ImmutableFioDataPoint}.
     * @return An immutable instance of FioDataPoint
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFioDataPoint build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFioDataPoint(
          time,
          summary,
          icon,
          sunriseTime,
          sunsetTime,
          moonPhase,
          nearestStormDistance,
          nearestStormBearing,
          precipIntensity,
          precipIntensityMax,
          precipIntensityMaxTime,
          precipProbability,
          precipType,
          precipAccumulation,
          temperature,
          temperatureMin,
          temperatureMinTime,
          temperatureMax,
          temperatureMaxTime,
          apparentTemperature,
          apparentTemperatureMin,
          apparentTemperatureMinTime,
          apparentTemperatureMax,
          apparentTemperatureMaxTime,
          dewPoint,
          windSpeed,
          windBearing,
          cloudCover,
          humidity,
          pressure,
          visibility,
          ozone);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_TIME) != 0) attributes.add("time");
      return "Cannot build FioDataPoint, some of required attributes are not set " + attributes;
    }
  }
}
