/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.forcastio.model;

import ch.rasc.forcastio.model.FioBlock;
import ch.rasc.forcastio.model.FioLanguage;
import ch.rasc.forcastio.model.FioRequest;
import ch.rasc.forcastio.model.FioUnit;
import ch.rasc.forcastio.model.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

final class ImmutableFioRequest
implements FioRequest {
    private final String latitude;
    private final String longitude;
    @Nullable
    private final Boolean extendHourly;
    @Nullable
    private final FioLanguage language;
    @Nullable
    private final FioUnit unit;
    private final Set<FioBlock> excludeBlocks;
    private final Set<FioBlock> includeBlocks;

    private ImmutableFioRequest(String latitude, String longitude, @Nullable Boolean extendHourly, @Nullable FioLanguage language, @Nullable FioUnit unit, Set<FioBlock> excludeBlocks, Set<FioBlock> includeBlocks) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.extendHourly = extendHourly;
        this.language = language;
        this.unit = unit;
        this.excludeBlocks = excludeBlocks;
        this.includeBlocks = includeBlocks;
    }

    @Override
    public String latitude() {
        return this.latitude;
    }

    @Override
    public String longitude() {
        return this.longitude;
    }

    @Override
    @Nullable
    public Boolean extendHourly() {
        return this.extendHourly;
    }

    @Override
    @Nullable
    public FioLanguage language() {
        return this.language;
    }

    @Override
    @Nullable
    public FioUnit unit() {
        return this.unit;
    }

    @Override
    public Set<FioBlock> excludeBlocks() {
        return this.excludeBlocks;
    }

    @Override
    public Set<FioBlock> includeBlocks() {
        return this.includeBlocks;
    }

    public final ImmutableFioRequest withLatitude(String latitude) {
        if (this.latitude.equals(latitude)) {
            return this;
        }
        String newValue = Objects.requireNonNull(latitude, "latitude");
        return new ImmutableFioRequest(newValue, this.longitude, this.extendHourly, this.language, this.unit, this.excludeBlocks, this.includeBlocks);
    }

    public final ImmutableFioRequest withLongitude(String longitude) {
        if (this.longitude.equals(longitude)) {
            return this;
        }
        String newValue = Objects.requireNonNull(longitude, "longitude");
        return new ImmutableFioRequest(this.latitude, newValue, this.extendHourly, this.language, this.unit, this.excludeBlocks, this.includeBlocks);
    }

    public final ImmutableFioRequest withExtendHourly(@Nullable Boolean extendHourly) {
        if (Objects.equals(this.extendHourly, extendHourly)) {
            return this;
        }
        return new ImmutableFioRequest(this.latitude, this.longitude, extendHourly, this.language, this.unit, this.excludeBlocks, this.includeBlocks);
    }

    public final ImmutableFioRequest withLanguage(@Nullable FioLanguage language) {
        if (this.language == language) {
            return this;
        }
        return new ImmutableFioRequest(this.latitude, this.longitude, this.extendHourly, language, this.unit, this.excludeBlocks, this.includeBlocks);
    }

    public final ImmutableFioRequest withUnit(@Nullable FioUnit unit) {
        if (this.unit == unit) {
            return this;
        }
        return new ImmutableFioRequest(this.latitude, this.longitude, this.extendHourly, this.language, unit, this.excludeBlocks, this.includeBlocks);
    }

    public final ImmutableFioRequest withExcludeBlocks(FioBlock ... elements) {
        Set<FioBlock> newValue = ImmutableFioRequest.createUnmodifiableEnumSet(Arrays.asList(elements));
        return new ImmutableFioRequest(this.latitude, this.longitude, this.extendHourly, this.language, this.unit, newValue, this.includeBlocks);
    }

    public final ImmutableFioRequest withExcludeBlocks(Iterable<FioBlock> elements) {
        if (this.excludeBlocks == elements) {
            return this;
        }
        Set<FioBlock> newValue = ImmutableFioRequest.createUnmodifiableEnumSet(elements);
        return new ImmutableFioRequest(this.latitude, this.longitude, this.extendHourly, this.language, this.unit, newValue, this.includeBlocks);
    }

    public final ImmutableFioRequest withIncludeBlocks(FioBlock ... elements) {
        Set<FioBlock> newValue = ImmutableFioRequest.createUnmodifiableEnumSet(Arrays.asList(elements));
        return new ImmutableFioRequest(this.latitude, this.longitude, this.extendHourly, this.language, this.unit, this.excludeBlocks, newValue);
    }

    public final ImmutableFioRequest withIncludeBlocks(Iterable<FioBlock> elements) {
        if (this.includeBlocks == elements) {
            return this;
        }
        Set<FioBlock> newValue = ImmutableFioRequest.createUnmodifiableEnumSet(elements);
        return new ImmutableFioRequest(this.latitude, this.longitude, this.extendHourly, this.language, this.unit, this.excludeBlocks, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFioRequest && this.equalTo((ImmutableFioRequest)another);
    }

    private boolean equalTo(ImmutableFioRequest another) {
        return this.latitude.equals(another.latitude) && this.longitude.equals(another.longitude) && Objects.equals(this.extendHourly, another.extendHourly) && Objects.equals((Object)this.language, (Object)another.language) && Objects.equals((Object)this.unit, (Object)another.unit) && this.excludeBlocks.equals(another.excludeBlocks) && this.includeBlocks.equals(another.includeBlocks);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.latitude.hashCode();
        h = h * 17 + this.longitude.hashCode();
        h = h * 17 + Objects.hashCode(this.extendHourly);
        h = h * 17 + Objects.hashCode((Object)this.language);
        h = h * 17 + Objects.hashCode((Object)this.unit);
        h = h * 17 + this.excludeBlocks.hashCode();
        h = h * 17 + this.includeBlocks.hashCode();
        return h;
    }

    public String toString() {
        return "FioRequest{latitude=" + this.latitude + ", longitude=" + this.longitude + ", extendHourly=" + this.extendHourly + ", language=" + (Object)((Object)this.language) + ", unit=" + (Object)((Object)this.unit) + ", excludeBlocks=" + this.excludeBlocks + ", includeBlocks=" + this.includeBlocks + "}";
    }

    public static ImmutableFioRequest copyOf(FioRequest instance) {
        if (instance instanceof ImmutableFioRequest) {
            return (ImmutableFioRequest)instance;
        }
        return new FioRequest.Builder().from(instance).build();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
        if (iterable instanceof EnumSet) {
            return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet)iterable));
        }
        List<T> list = ImmutableFioRequest.createSafeList(iterable, true, false);
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }

    static class Builder {
        private static final long INIT_BIT_LATITUDE = 1L;
        private static final long INIT_BIT_LONGITUDE = 2L;
        private long initBits = 3L;
        private String latitude;
        private String longitude;
        private Boolean extendHourly;
        private FioLanguage language;
        private FioUnit unit;
        private EnumSet<FioBlock> excludeBlocks = EnumSet.noneOf(FioBlock.class);
        private EnumSet<FioBlock> includeBlocks = EnumSet.noneOf(FioBlock.class);

        Builder() {
            if (!(this instanceof FioRequest.Builder)) {
                throw new UnsupportedOperationException("Use: new FioRequest.Builder()");
            }
        }

        public final FioRequest.Builder from(FioRequest instance) {
            FioUnit unitValue;
            FioLanguage languageValue;
            Objects.requireNonNull(instance, "instance");
            this.latitude(instance.latitude());
            this.longitude(instance.longitude());
            Boolean extendHourlyValue = instance.extendHourly();
            if (extendHourlyValue != null) {
                this.extendHourly(extendHourlyValue);
            }
            if ((languageValue = instance.language()) != null) {
                this.language(languageValue);
            }
            if ((unitValue = instance.unit()) != null) {
                this.unit(unitValue);
            }
            this.addAllExcludeBlocks(instance.excludeBlocks());
            this.addAllIncludeBlocks(instance.includeBlocks());
            return (FioRequest.Builder)this;
        }

        public final FioRequest.Builder latitude(String latitude) {
            this.latitude = Objects.requireNonNull(latitude, "latitude");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (FioRequest.Builder)this;
        }

        public final FioRequest.Builder longitude(String longitude) {
            this.longitude = Objects.requireNonNull(longitude, "longitude");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (FioRequest.Builder)this;
        }

        public final FioRequest.Builder extendHourly(@Nullable Boolean extendHourly) {
            this.extendHourly = extendHourly;
            return (FioRequest.Builder)this;
        }

        public final FioRequest.Builder language(@Nullable FioLanguage language) {
            this.language = language;
            return (FioRequest.Builder)this;
        }

        public final FioRequest.Builder unit(@Nullable FioUnit unit) {
            this.unit = unit;
            return (FioRequest.Builder)this;
        }

        public final FioRequest.Builder excludeBlock(FioBlock element) {
            this.excludeBlocks.add(Objects.requireNonNull(element, "excludeBlocks element"));
            return (FioRequest.Builder)this;
        }

        public final FioRequest.Builder excludeBlock(FioBlock ... elements) {
            for (FioBlock element : elements) {
                this.excludeBlocks.add(Objects.requireNonNull(element, "excludeBlocks element"));
            }
            return (FioRequest.Builder)this;
        }

        public final FioRequest.Builder excludeBlocks(Iterable<FioBlock> elements) {
            this.excludeBlocks.clear();
            return this.addAllExcludeBlocks(elements);
        }

        public final FioRequest.Builder addAllExcludeBlocks(Iterable<FioBlock> elements) {
            for (FioBlock element : elements) {
                this.excludeBlocks.add(Objects.requireNonNull(element, "excludeBlocks element"));
            }
            return (FioRequest.Builder)this;
        }

        public final FioRequest.Builder includeBlock(FioBlock element) {
            this.includeBlocks.add(Objects.requireNonNull(element, "includeBlocks element"));
            return (FioRequest.Builder)this;
        }

        public final FioRequest.Builder includeBlock(FioBlock ... elements) {
            for (FioBlock element : elements) {
                this.includeBlocks.add(Objects.requireNonNull(element, "includeBlocks element"));
            }
            return (FioRequest.Builder)this;
        }

        public final FioRequest.Builder includeBlocks(Iterable<FioBlock> elements) {
            this.includeBlocks.clear();
            return this.addAllIncludeBlocks(elements);
        }

        public final FioRequest.Builder addAllIncludeBlocks(Iterable<FioBlock> elements) {
            for (FioBlock element : elements) {
                this.includeBlocks.add(Objects.requireNonNull(element, "includeBlocks element"));
            }
            return (FioRequest.Builder)this;
        }

        public ImmutableFioRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFioRequest(this.latitude, this.longitude, this.extendHourly, this.language, this.unit, ImmutableFioRequest.createUnmodifiableEnumSet(this.excludeBlocks), ImmutableFioRequest.createUnmodifiableEnumSet(this.includeBlocks));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("latitude");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("longitude");
            }
            return "Cannot build FioRequest, some of required attributes are not set " + attributes;
        }
    }
}

