/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.forcastio.model;

import ch.rasc.forcastio.converter.FioUnitDeserializer;
import ch.rasc.forcastio.model.FioFlag;
import ch.rasc.forcastio.model.FioUnit;
import ch.rasc.forcastio.model.Nullable;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableFioFlag
implements FioFlag {
    @Nullable
    private final Object darkskyUnavailable;
    private final List<String> darkskyStations;
    private final List<String> datapointStations;
    private final List<String> isdStations;
    private final List<String> lampStations;
    private final List<String> metarStations;
    @Nullable
    private final String metnoLicense;
    private final List<String> sources;
    @Nullable
    private final FioUnit units;

    private ImmutableFioFlag(@Nullable Object darkskyUnavailable, List<String> darkskyStations, List<String> datapointStations, List<String> isdStations, List<String> lampStations, List<String> metarStations, @Nullable String metnoLicense, List<String> sources, @Nullable FioUnit units) {
        this.darkskyUnavailable = darkskyUnavailable;
        this.darkskyStations = darkskyStations;
        this.datapointStations = datapointStations;
        this.isdStations = isdStations;
        this.lampStations = lampStations;
        this.metarStations = metarStations;
        this.metnoLicense = metnoLicense;
        this.sources = sources;
        this.units = units;
    }

    @Override
    @JsonProperty(value="darksky-unavailable")
    @Nullable
    public Object darkskyUnavailable() {
        return this.darkskyUnavailable;
    }

    @Override
    @JsonProperty(value="darksky-stations")
    public List<String> darkskyStations() {
        return this.darkskyStations;
    }

    @Override
    @JsonProperty(value="datapoint-stations")
    public List<String> datapointStations() {
        return this.datapointStations;
    }

    @Override
    @JsonProperty(value="isd-stations")
    public List<String> isdStations() {
        return this.isdStations;
    }

    @Override
    @JsonProperty(value="lamp-stations")
    public List<String> lampStations() {
        return this.lampStations;
    }

    @Override
    @JsonProperty(value="metar-stations")
    public List<String> metarStations() {
        return this.metarStations;
    }

    @Override
    @JsonProperty(value="metno-license")
    @Nullable
    public String metnoLicense() {
        return this.metnoLicense;
    }

    @Override
    @JsonProperty(value="sources")
    public List<String> sources() {
        return this.sources;
    }

    @Override
    @JsonProperty(value="units")
    @JsonDeserialize(using=FioUnitDeserializer.class)
    @Nullable
    public FioUnit units() {
        return this.units;
    }

    public final ImmutableFioFlag withDarkskyUnavailable(@Nullable Object darkskyUnavailable) {
        if (this.darkskyUnavailable == darkskyUnavailable) {
            return this;
        }
        return new ImmutableFioFlag(darkskyUnavailable, this.darkskyStations, this.datapointStations, this.isdStations, this.lampStations, this.metarStations, this.metnoLicense, this.sources, this.units);
    }

    public final ImmutableFioFlag withDarkskyStations(String ... elements) {
        List<String> newValue = ImmutableFioFlag.createUnmodifiableList(false, ImmutableFioFlag.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableFioFlag(this.darkskyUnavailable, newValue, this.datapointStations, this.isdStations, this.lampStations, this.metarStations, this.metnoLicense, this.sources, this.units);
    }

    public final ImmutableFioFlag withDarkskyStations(Iterable<String> elements) {
        if (this.darkskyStations == elements) {
            return this;
        }
        List<String> newValue = ImmutableFioFlag.createUnmodifiableList(false, ImmutableFioFlag.createSafeList(elements, true, false));
        return new ImmutableFioFlag(this.darkskyUnavailable, newValue, this.datapointStations, this.isdStations, this.lampStations, this.metarStations, this.metnoLicense, this.sources, this.units);
    }

    public final ImmutableFioFlag withDatapointStations(String ... elements) {
        List<String> newValue = ImmutableFioFlag.createUnmodifiableList(false, ImmutableFioFlag.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableFioFlag(this.darkskyUnavailable, this.darkskyStations, newValue, this.isdStations, this.lampStations, this.metarStations, this.metnoLicense, this.sources, this.units);
    }

    public final ImmutableFioFlag withDatapointStations(Iterable<String> elements) {
        if (this.datapointStations == elements) {
            return this;
        }
        List<String> newValue = ImmutableFioFlag.createUnmodifiableList(false, ImmutableFioFlag.createSafeList(elements, true, false));
        return new ImmutableFioFlag(this.darkskyUnavailable, this.darkskyStations, newValue, this.isdStations, this.lampStations, this.metarStations, this.metnoLicense, this.sources, this.units);
    }

    public final ImmutableFioFlag withIsdStations(String ... elements) {
        List<String> newValue = ImmutableFioFlag.createUnmodifiableList(false, ImmutableFioFlag.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableFioFlag(this.darkskyUnavailable, this.darkskyStations, this.datapointStations, newValue, this.lampStations, this.metarStations, this.metnoLicense, this.sources, this.units);
    }

    public final ImmutableFioFlag withIsdStations(Iterable<String> elements) {
        if (this.isdStations == elements) {
            return this;
        }
        List<String> newValue = ImmutableFioFlag.createUnmodifiableList(false, ImmutableFioFlag.createSafeList(elements, true, false));
        return new ImmutableFioFlag(this.darkskyUnavailable, this.darkskyStations, this.datapointStations, newValue, this.lampStations, this.metarStations, this.metnoLicense, this.sources, this.units);
    }

    public final ImmutableFioFlag withLampStations(String ... elements) {
        List<String> newValue = ImmutableFioFlag.createUnmodifiableList(false, ImmutableFioFlag.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableFioFlag(this.darkskyUnavailable, this.darkskyStations, this.datapointStations, this.isdStations, newValue, this.metarStations, this.metnoLicense, this.sources, this.units);
    }

    public final ImmutableFioFlag withLampStations(Iterable<String> elements) {
        if (this.lampStations == elements) {
            return this;
        }
        List<String> newValue = ImmutableFioFlag.createUnmodifiableList(false, ImmutableFioFlag.createSafeList(elements, true, false));
        return new ImmutableFioFlag(this.darkskyUnavailable, this.darkskyStations, this.datapointStations, this.isdStations, newValue, this.metarStations, this.metnoLicense, this.sources, this.units);
    }

    public final ImmutableFioFlag withMetarStations(String ... elements) {
        List<String> newValue = ImmutableFioFlag.createUnmodifiableList(false, ImmutableFioFlag.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableFioFlag(this.darkskyUnavailable, this.darkskyStations, this.datapointStations, this.isdStations, this.lampStations, newValue, this.metnoLicense, this.sources, this.units);
    }

    public final ImmutableFioFlag withMetarStations(Iterable<String> elements) {
        if (this.metarStations == elements) {
            return this;
        }
        List<String> newValue = ImmutableFioFlag.createUnmodifiableList(false, ImmutableFioFlag.createSafeList(elements, true, false));
        return new ImmutableFioFlag(this.darkskyUnavailable, this.darkskyStations, this.datapointStations, this.isdStations, this.lampStations, newValue, this.metnoLicense, this.sources, this.units);
    }

    public final ImmutableFioFlag withMetnoLicense(@Nullable String metnoLicense) {
        if (Objects.equals(this.metnoLicense, metnoLicense)) {
            return this;
        }
        return new ImmutableFioFlag(this.darkskyUnavailable, this.darkskyStations, this.datapointStations, this.isdStations, this.lampStations, this.metarStations, metnoLicense, this.sources, this.units);
    }

    public final ImmutableFioFlag withSources(String ... elements) {
        List<String> newValue = ImmutableFioFlag.createUnmodifiableList(false, ImmutableFioFlag.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableFioFlag(this.darkskyUnavailable, this.darkskyStations, this.datapointStations, this.isdStations, this.lampStations, this.metarStations, this.metnoLicense, newValue, this.units);
    }

    public final ImmutableFioFlag withSources(Iterable<String> elements) {
        if (this.sources == elements) {
            return this;
        }
        List<String> newValue = ImmutableFioFlag.createUnmodifiableList(false, ImmutableFioFlag.createSafeList(elements, true, false));
        return new ImmutableFioFlag(this.darkskyUnavailable, this.darkskyStations, this.datapointStations, this.isdStations, this.lampStations, this.metarStations, this.metnoLicense, newValue, this.units);
    }

    public final ImmutableFioFlag withUnits(@Nullable FioUnit units) {
        if (this.units == units) {
            return this;
        }
        return new ImmutableFioFlag(this.darkskyUnavailable, this.darkskyStations, this.datapointStations, this.isdStations, this.lampStations, this.metarStations, this.metnoLicense, this.sources, units);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFioFlag && this.equalTo((ImmutableFioFlag)another);
    }

    private boolean equalTo(ImmutableFioFlag another) {
        return Objects.equals(this.darkskyUnavailable, another.darkskyUnavailable) && this.darkskyStations.equals(another.darkskyStations) && this.datapointStations.equals(another.datapointStations) && this.isdStations.equals(another.isdStations) && this.lampStations.equals(another.lampStations) && this.metarStations.equals(another.metarStations) && Objects.equals(this.metnoLicense, another.metnoLicense) && this.sources.equals(another.sources) && Objects.equals((Object)this.units, (Object)another.units);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.darkskyUnavailable);
        h = h * 17 + this.darkskyStations.hashCode();
        h = h * 17 + this.datapointStations.hashCode();
        h = h * 17 + this.isdStations.hashCode();
        h = h * 17 + this.lampStations.hashCode();
        h = h * 17 + this.metarStations.hashCode();
        h = h * 17 + Objects.hashCode(this.metnoLicense);
        h = h * 17 + this.sources.hashCode();
        h = h * 17 + Objects.hashCode((Object)this.units);
        return h;
    }

    public String toString() {
        return "FioFlag{darkskyUnavailable=" + this.darkskyUnavailable + ", darkskyStations=" + this.darkskyStations + ", datapointStations=" + this.datapointStations + ", isdStations=" + this.isdStations + ", lampStations=" + this.lampStations + ", metarStations=" + this.metarStations + ", metnoLicense=" + this.metnoLicense + ", sources=" + this.sources + ", units=" + (Object)((Object)this.units) + "}";
    }

    @Deprecated
    @JsonCreator
    static ImmutableFioFlag fromJson(Json json) {
        Builder builder = ImmutableFioFlag.builder();
        if (json.darkskyUnavailable != null) {
            builder.darkskyUnavailable(json.darkskyUnavailable);
        }
        if (json.darkskyStations != null) {
            builder.addAllDarkskyStations(json.darkskyStations);
        }
        if (json.datapointStations != null) {
            builder.addAllDatapointStations(json.datapointStations);
        }
        if (json.isdStations != null) {
            builder.addAllIsdStations(json.isdStations);
        }
        if (json.lampStations != null) {
            builder.addAllLampStations(json.lampStations);
        }
        if (json.metarStations != null) {
            builder.addAllMetarStations(json.metarStations);
        }
        if (json.metnoLicense != null) {
            builder.metnoLicense(json.metnoLicense);
        }
        if (json.sources != null) {
            builder.addAllSources(json.sources);
        }
        if (json.units != null) {
            builder.units(json.units);
        }
        return builder.build();
    }

    public static ImmutableFioFlag copyOf(FioFlag instance) {
        if (instance instanceof ImmutableFioFlag) {
            return (ImmutableFioFlag)instance;
        }
        return ImmutableFioFlag.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private Object darkskyUnavailable;
        private List<String> darkskyStations = new ArrayList<String>();
        private List<String> datapointStations = new ArrayList<String>();
        private List<String> isdStations = new ArrayList<String>();
        private List<String> lampStations = new ArrayList<String>();
        private List<String> metarStations = new ArrayList<String>();
        private String metnoLicense;
        private List<String> sources = new ArrayList<String>();
        private FioUnit units;

        private Builder() {
        }

        public final Builder from(FioFlag instance) {
            Objects.requireNonNull(instance, "instance");
            Object darkskyUnavailableValue = instance.darkskyUnavailable();
            if (darkskyUnavailableValue != null) {
                this.darkskyUnavailable(darkskyUnavailableValue);
            }
            this.addAllDarkskyStations(instance.darkskyStations());
            this.addAllDatapointStations(instance.datapointStations());
            this.addAllIsdStations(instance.isdStations());
            this.addAllLampStations(instance.lampStations());
            this.addAllMetarStations(instance.metarStations());
            String metnoLicenseValue = instance.metnoLicense();
            if (metnoLicenseValue != null) {
                this.metnoLicense(metnoLicenseValue);
            }
            this.addAllSources(instance.sources());
            FioUnit unitsValue = instance.units();
            if (unitsValue != null) {
                this.units(unitsValue);
            }
            return this;
        }

        public final Builder darkskyUnavailable(@Nullable Object darkskyUnavailable) {
            this.darkskyUnavailable = darkskyUnavailable;
            return this;
        }

        public final Builder addDarkskyStations(String element) {
            this.darkskyStations.add(Objects.requireNonNull(element, "darkskyStations element"));
            return this;
        }

        public final Builder addDarkskyStations(String ... elements) {
            for (String element : elements) {
                this.darkskyStations.add(Objects.requireNonNull(element, "darkskyStations element"));
            }
            return this;
        }

        public final Builder darkskyStations(Iterable<String> elements) {
            this.darkskyStations.clear();
            return this.addAllDarkskyStations(elements);
        }

        public final Builder addAllDarkskyStations(Iterable<String> elements) {
            for (String element : elements) {
                this.darkskyStations.add(Objects.requireNonNull(element, "darkskyStations element"));
            }
            return this;
        }

        public final Builder addDatapointStations(String element) {
            this.datapointStations.add(Objects.requireNonNull(element, "datapointStations element"));
            return this;
        }

        public final Builder addDatapointStations(String ... elements) {
            for (String element : elements) {
                this.datapointStations.add(Objects.requireNonNull(element, "datapointStations element"));
            }
            return this;
        }

        public final Builder datapointStations(Iterable<String> elements) {
            this.datapointStations.clear();
            return this.addAllDatapointStations(elements);
        }

        public final Builder addAllDatapointStations(Iterable<String> elements) {
            for (String element : elements) {
                this.datapointStations.add(Objects.requireNonNull(element, "datapointStations element"));
            }
            return this;
        }

        public final Builder addIsdStations(String element) {
            this.isdStations.add(Objects.requireNonNull(element, "isdStations element"));
            return this;
        }

        public final Builder addIsdStations(String ... elements) {
            for (String element : elements) {
                this.isdStations.add(Objects.requireNonNull(element, "isdStations element"));
            }
            return this;
        }

        public final Builder isdStations(Iterable<String> elements) {
            this.isdStations.clear();
            return this.addAllIsdStations(elements);
        }

        public final Builder addAllIsdStations(Iterable<String> elements) {
            for (String element : elements) {
                this.isdStations.add(Objects.requireNonNull(element, "isdStations element"));
            }
            return this;
        }

        public final Builder addLampStations(String element) {
            this.lampStations.add(Objects.requireNonNull(element, "lampStations element"));
            return this;
        }

        public final Builder addLampStations(String ... elements) {
            for (String element : elements) {
                this.lampStations.add(Objects.requireNonNull(element, "lampStations element"));
            }
            return this;
        }

        public final Builder lampStations(Iterable<String> elements) {
            this.lampStations.clear();
            return this.addAllLampStations(elements);
        }

        public final Builder addAllLampStations(Iterable<String> elements) {
            for (String element : elements) {
                this.lampStations.add(Objects.requireNonNull(element, "lampStations element"));
            }
            return this;
        }

        public final Builder addMetarStations(String element) {
            this.metarStations.add(Objects.requireNonNull(element, "metarStations element"));
            return this;
        }

        public final Builder addMetarStations(String ... elements) {
            for (String element : elements) {
                this.metarStations.add(Objects.requireNonNull(element, "metarStations element"));
            }
            return this;
        }

        public final Builder metarStations(Iterable<String> elements) {
            this.metarStations.clear();
            return this.addAllMetarStations(elements);
        }

        public final Builder addAllMetarStations(Iterable<String> elements) {
            for (String element : elements) {
                this.metarStations.add(Objects.requireNonNull(element, "metarStations element"));
            }
            return this;
        }

        public final Builder metnoLicense(@Nullable String metnoLicense) {
            this.metnoLicense = metnoLicense;
            return this;
        }

        public final Builder addSources(String element) {
            this.sources.add(Objects.requireNonNull(element, "sources element"));
            return this;
        }

        public final Builder addSources(String ... elements) {
            for (String element : elements) {
                this.sources.add(Objects.requireNonNull(element, "sources element"));
            }
            return this;
        }

        public final Builder sources(Iterable<String> elements) {
            this.sources.clear();
            return this.addAllSources(elements);
        }

        public final Builder addAllSources(Iterable<String> elements) {
            for (String element : elements) {
                this.sources.add(Objects.requireNonNull(element, "sources element"));
            }
            return this;
        }

        public final Builder units(@Nullable FioUnit units) {
            this.units = units;
            return this;
        }

        public ImmutableFioFlag build() {
            return new ImmutableFioFlag(this.darkskyUnavailable, ImmutableFioFlag.createUnmodifiableList(true, this.darkskyStations), ImmutableFioFlag.createUnmodifiableList(true, this.datapointStations), ImmutableFioFlag.createUnmodifiableList(true, this.isdStations), ImmutableFioFlag.createUnmodifiableList(true, this.lampStations), ImmutableFioFlag.createUnmodifiableList(true, this.metarStations), this.metnoLicense, ImmutableFioFlag.createUnmodifiableList(true, this.sources), this.units);
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements FioFlag {
        Object darkskyUnavailable;
        List<String> darkskyStations = Collections.emptyList();
        List<String> datapointStations = Collections.emptyList();
        List<String> isdStations = Collections.emptyList();
        List<String> lampStations = Collections.emptyList();
        List<String> metarStations = Collections.emptyList();
        String metnoLicense;
        List<String> sources = Collections.emptyList();
        FioUnit units;

        Json() {
        }

        @JsonProperty(value="darksky-unavailable")
        public void setDarkskyUnavailable(@Nullable Object darkskyUnavailable) {
            this.darkskyUnavailable = darkskyUnavailable;
        }

        @JsonProperty(value="darksky-stations")
        public void setDarkskyStations(List<String> darkskyStations) {
            this.darkskyStations = darkskyStations;
        }

        @JsonProperty(value="datapoint-stations")
        public void setDatapointStations(List<String> datapointStations) {
            this.datapointStations = datapointStations;
        }

        @JsonProperty(value="isd-stations")
        public void setIsdStations(List<String> isdStations) {
            this.isdStations = isdStations;
        }

        @JsonProperty(value="lamp-stations")
        public void setLampStations(List<String> lampStations) {
            this.lampStations = lampStations;
        }

        @JsonProperty(value="metar-stations")
        public void setMetarStations(List<String> metarStations) {
            this.metarStations = metarStations;
        }

        @JsonProperty(value="metno-license")
        public void setMetnoLicense(@Nullable String metnoLicense) {
            this.metnoLicense = metnoLicense;
        }

        @JsonProperty(value="sources")
        public void setSources(List<String> sources) {
            this.sources = sources;
        }

        @JsonProperty(value="units")
        @JsonDeserialize(using=FioUnitDeserializer.class)
        public void setUnits(@Nullable FioUnit units) {
            this.units = units;
        }

        @Override
        public Object darkskyUnavailable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> darkskyStations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> datapointStations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> isdStations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> lampStations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> metarStations() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String metnoLicense() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> sources() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FioUnit units() {
            throw new UnsupportedOperationException();
        }
    }
}

