/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.forcastio.model;

import ch.rasc.forcastio.converter.FioIconDeserializer;
import ch.rasc.forcastio.converter.FioPrecipTypeDeserializer;
import ch.rasc.forcastio.model.FioDataPoint;
import ch.rasc.forcastio.model.FioIcon;
import ch.rasc.forcastio.model.FioPrecipType;
import ch.rasc.forcastio.model.Nullable;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ImmutableFioDataPoint
extends FioDataPoint {
    private final long time;
    @Nullable
    private final String summary;
    @Nullable
    private final FioIcon icon;
    @Nullable
    private final Long sunriseTime;
    @Nullable
    private final Long sunsetTime;
    @Nullable
    private final BigDecimal moonPhase;
    @Nullable
    private final BigDecimal nearestStormDistance;
    @Nullable
    private final BigDecimal nearestStormBearing;
    @Nullable
    private final BigDecimal precipIntensity;
    @Nullable
    private final BigDecimal precipIntensityMax;
    @Nullable
    private final Long precipIntensityMaxTime;
    @Nullable
    private final BigDecimal precipProbability;
    @Nullable
    private final FioPrecipType precipType;
    @Nullable
    private final BigDecimal precipAccumulation;
    @Nullable
    private final BigDecimal temperature;
    @Nullable
    private final BigDecimal temperatureMin;
    @Nullable
    private final Long temperatureMinTime;
    @Nullable
    private final BigDecimal temperatureMax;
    @Nullable
    private final Long temperatureMaxTime;
    @Nullable
    private final BigDecimal apparentTemperature;
    @Nullable
    private final BigDecimal apparentTemperatureMin;
    @Nullable
    private final Long apparentTemperatureMinTime;
    @Nullable
    private final BigDecimal apparentTemperatureMax;
    @Nullable
    private final Long apparentTemperatureMaxTime;
    @Nullable
    private final BigDecimal dewPoint;
    @Nullable
    private final BigDecimal windSpeed;
    @Nullable
    private final BigDecimal windBearing;
    @Nullable
    private final BigDecimal cloudCover;
    @Nullable
    private final BigDecimal humidity;
    @Nullable
    private final BigDecimal pressure;
    @Nullable
    private final BigDecimal visibility;
    @Nullable
    private final BigDecimal ozone;

    private ImmutableFioDataPoint(long time, @Nullable String summary, @Nullable FioIcon icon, @Nullable Long sunriseTime, @Nullable Long sunsetTime, @Nullable BigDecimal moonPhase, @Nullable BigDecimal nearestStormDistance, @Nullable BigDecimal nearestStormBearing, @Nullable BigDecimal precipIntensity, @Nullable BigDecimal precipIntensityMax, @Nullable Long precipIntensityMaxTime, @Nullable BigDecimal precipProbability, @Nullable FioPrecipType precipType, @Nullable BigDecimal precipAccumulation, @Nullable BigDecimal temperature, @Nullable BigDecimal temperatureMin, @Nullable Long temperatureMinTime, @Nullable BigDecimal temperatureMax, @Nullable Long temperatureMaxTime, @Nullable BigDecimal apparentTemperature, @Nullable BigDecimal apparentTemperatureMin, @Nullable Long apparentTemperatureMinTime, @Nullable BigDecimal apparentTemperatureMax, @Nullable Long apparentTemperatureMaxTime, @Nullable BigDecimal dewPoint, @Nullable BigDecimal windSpeed, @Nullable BigDecimal windBearing, @Nullable BigDecimal cloudCover, @Nullable BigDecimal humidity, @Nullable BigDecimal pressure, @Nullable BigDecimal visibility, @Nullable BigDecimal ozone) {
        this.time = time;
        this.summary = summary;
        this.icon = icon;
        this.sunriseTime = sunriseTime;
        this.sunsetTime = sunsetTime;
        this.moonPhase = moonPhase;
        this.nearestStormDistance = nearestStormDistance;
        this.nearestStormBearing = nearestStormBearing;
        this.precipIntensity = precipIntensity;
        this.precipIntensityMax = precipIntensityMax;
        this.precipIntensityMaxTime = precipIntensityMaxTime;
        this.precipProbability = precipProbability;
        this.precipType = precipType;
        this.precipAccumulation = precipAccumulation;
        this.temperature = temperature;
        this.temperatureMin = temperatureMin;
        this.temperatureMinTime = temperatureMinTime;
        this.temperatureMax = temperatureMax;
        this.temperatureMaxTime = temperatureMaxTime;
        this.apparentTemperature = apparentTemperature;
        this.apparentTemperatureMin = apparentTemperatureMin;
        this.apparentTemperatureMinTime = apparentTemperatureMinTime;
        this.apparentTemperatureMax = apparentTemperatureMax;
        this.apparentTemperatureMaxTime = apparentTemperatureMaxTime;
        this.dewPoint = dewPoint;
        this.windSpeed = windSpeed;
        this.windBearing = windBearing;
        this.cloudCover = cloudCover;
        this.humidity = humidity;
        this.pressure = pressure;
        this.visibility = visibility;
        this.ozone = ozone;
    }

    @Override
    @JsonProperty(value="time")
    public long time() {
        return this.time;
    }

    @Override
    @JsonProperty(value="summary")
    @Nullable
    public String summary() {
        return this.summary;
    }

    @Override
    @JsonProperty(value="icon")
    @JsonDeserialize(using=FioIconDeserializer.class)
    @Nullable
    public FioIcon icon() {
        return this.icon;
    }

    @Override
    @JsonProperty(value="sunriseTime")
    @Nullable
    public Long sunriseTime() {
        return this.sunriseTime;
    }

    @Override
    @JsonProperty(value="sunsetTime")
    @Nullable
    public Long sunsetTime() {
        return this.sunsetTime;
    }

    @Override
    @JsonProperty(value="moonPhase")
    @Nullable
    public BigDecimal moonPhase() {
        return this.moonPhase;
    }

    @Override
    @JsonProperty(value="nearestStormDistance")
    @Nullable
    public BigDecimal nearestStormDistance() {
        return this.nearestStormDistance;
    }

    @Override
    @JsonProperty(value="nearestStormBearing")
    @Nullable
    public BigDecimal nearestStormBearing() {
        return this.nearestStormBearing;
    }

    @Override
    @JsonProperty(value="precipIntensity")
    @Nullable
    public BigDecimal precipIntensity() {
        return this.precipIntensity;
    }

    @Override
    @JsonProperty(value="precipIntensityMax")
    @Nullable
    public BigDecimal precipIntensityMax() {
        return this.precipIntensityMax;
    }

    @Override
    @JsonProperty(value="precipIntensityMaxTime")
    @Nullable
    public Long precipIntensityMaxTime() {
        return this.precipIntensityMaxTime;
    }

    @Override
    @JsonProperty(value="precipProbability")
    @Nullable
    public BigDecimal precipProbability() {
        return this.precipProbability;
    }

    @Override
    @JsonProperty(value="precipType")
    @JsonDeserialize(using=FioPrecipTypeDeserializer.class)
    @Nullable
    public FioPrecipType precipType() {
        return this.precipType;
    }

    @Override
    @JsonProperty(value="precipAccumulation")
    @Nullable
    public BigDecimal precipAccumulation() {
        return this.precipAccumulation;
    }

    @Override
    @JsonProperty(value="temperature")
    @Nullable
    public BigDecimal temperature() {
        return this.temperature;
    }

    @Override
    @JsonProperty(value="temperatureMin")
    @Nullable
    public BigDecimal temperatureMin() {
        return this.temperatureMin;
    }

    @Override
    @JsonProperty(value="temperatureMinTime")
    @Nullable
    public Long temperatureMinTime() {
        return this.temperatureMinTime;
    }

    @Override
    @JsonProperty(value="temperatureMax")
    @Nullable
    public BigDecimal temperatureMax() {
        return this.temperatureMax;
    }

    @Override
    @JsonProperty(value="temperatureMaxTime")
    @Nullable
    public Long temperatureMaxTime() {
        return this.temperatureMaxTime;
    }

    @Override
    @JsonProperty(value="apparentTemperature")
    @Nullable
    public BigDecimal apparentTemperature() {
        return this.apparentTemperature;
    }

    @Override
    @JsonProperty(value="apparentTemperatureMin")
    @Nullable
    public BigDecimal apparentTemperatureMin() {
        return this.apparentTemperatureMin;
    }

    @Override
    @JsonProperty(value="apparentTemperatureMinTime")
    @Nullable
    public Long apparentTemperatureMinTime() {
        return this.apparentTemperatureMinTime;
    }

    @Override
    @JsonProperty(value="apparentTemperatureMax")
    @Nullable
    public BigDecimal apparentTemperatureMax() {
        return this.apparentTemperatureMax;
    }

    @Override
    @JsonProperty(value="apparentTemperatureMaxTime")
    @Nullable
    public Long apparentTemperatureMaxTime() {
        return this.apparentTemperatureMaxTime;
    }

    @Override
    @JsonProperty(value="dewPoint")
    @Nullable
    public BigDecimal dewPoint() {
        return this.dewPoint;
    }

    @Override
    @JsonProperty(value="windSpeed")
    @Nullable
    public BigDecimal windSpeed() {
        return this.windSpeed;
    }

    @Override
    @JsonProperty(value="windBearing")
    @Nullable
    public BigDecimal windBearing() {
        return this.windBearing;
    }

    @Override
    @JsonProperty(value="cloudCover")
    @Nullable
    public BigDecimal cloudCover() {
        return this.cloudCover;
    }

    @Override
    @JsonProperty(value="humidity")
    @Nullable
    public BigDecimal humidity() {
        return this.humidity;
    }

    @Override
    @JsonProperty(value="pressure")
    @Nullable
    public BigDecimal pressure() {
        return this.pressure;
    }

    @Override
    @JsonProperty(value="visibility")
    @Nullable
    public BigDecimal visibility() {
        return this.visibility;
    }

    @Override
    @JsonProperty(value="ozone")
    @Nullable
    public BigDecimal ozone() {
        return this.ozone;
    }

    public final ImmutableFioDataPoint withTime(long time) {
        if (this.time == time) {
            return this;
        }
        return new ImmutableFioDataPoint(time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withSummary(@Nullable String summary) {
        if (Objects.equals(this.summary, summary)) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withIcon(@Nullable FioIcon icon) {
        if (this.icon == icon) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withSunriseTime(@Nullable Long sunriseTime) {
        if (Objects.equals(this.sunriseTime, sunriseTime)) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withSunsetTime(@Nullable Long sunsetTime) {
        if (Objects.equals(this.sunsetTime, sunsetTime)) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withMoonPhase(@Nullable BigDecimal moonPhase) {
        if (this.moonPhase == moonPhase) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withNearestStormDistance(@Nullable BigDecimal nearestStormDistance) {
        if (this.nearestStormDistance == nearestStormDistance) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withNearestStormBearing(@Nullable BigDecimal nearestStormBearing) {
        if (this.nearestStormBearing == nearestStormBearing) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withPrecipIntensity(@Nullable BigDecimal precipIntensity) {
        if (this.precipIntensity == precipIntensity) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withPrecipIntensityMax(@Nullable BigDecimal precipIntensityMax) {
        if (this.precipIntensityMax == precipIntensityMax) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withPrecipIntensityMaxTime(@Nullable Long precipIntensityMaxTime) {
        if (Objects.equals(this.precipIntensityMaxTime, precipIntensityMaxTime)) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withPrecipProbability(@Nullable BigDecimal precipProbability) {
        if (this.precipProbability == precipProbability) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withPrecipType(@Nullable FioPrecipType precipType) {
        if (this.precipType == precipType) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withPrecipAccumulation(@Nullable BigDecimal precipAccumulation) {
        if (this.precipAccumulation == precipAccumulation) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withTemperature(@Nullable BigDecimal temperature) {
        if (this.temperature == temperature) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withTemperatureMin(@Nullable BigDecimal temperatureMin) {
        if (this.temperatureMin == temperatureMin) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withTemperatureMinTime(@Nullable Long temperatureMinTime) {
        if (Objects.equals(this.temperatureMinTime, temperatureMinTime)) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withTemperatureMax(@Nullable BigDecimal temperatureMax) {
        if (this.temperatureMax == temperatureMax) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withTemperatureMaxTime(@Nullable Long temperatureMaxTime) {
        if (Objects.equals(this.temperatureMaxTime, temperatureMaxTime)) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withApparentTemperature(@Nullable BigDecimal apparentTemperature) {
        if (this.apparentTemperature == apparentTemperature) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withApparentTemperatureMin(@Nullable BigDecimal apparentTemperatureMin) {
        if (this.apparentTemperatureMin == apparentTemperatureMin) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withApparentTemperatureMinTime(@Nullable Long apparentTemperatureMinTime) {
        if (Objects.equals(this.apparentTemperatureMinTime, apparentTemperatureMinTime)) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withApparentTemperatureMax(@Nullable BigDecimal apparentTemperatureMax) {
        if (this.apparentTemperatureMax == apparentTemperatureMax) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withApparentTemperatureMaxTime(@Nullable Long apparentTemperatureMaxTime) {
        if (Objects.equals(this.apparentTemperatureMaxTime, apparentTemperatureMaxTime)) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withDewPoint(@Nullable BigDecimal dewPoint) {
        if (this.dewPoint == dewPoint) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withWindSpeed(@Nullable BigDecimal windSpeed) {
        if (this.windSpeed == windSpeed) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withWindBearing(@Nullable BigDecimal windBearing) {
        if (this.windBearing == windBearing) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withCloudCover(@Nullable BigDecimal cloudCover) {
        if (this.cloudCover == cloudCover) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withHumidity(@Nullable BigDecimal humidity) {
        if (this.humidity == humidity) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, humidity, this.pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withPressure(@Nullable BigDecimal pressure) {
        if (this.pressure == pressure) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, pressure, this.visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withVisibility(@Nullable BigDecimal visibility) {
        if (this.visibility == visibility) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, visibility, this.ozone);
    }

    public final ImmutableFioDataPoint withOzone(@Nullable BigDecimal ozone) {
        if (this.ozone == ozone) {
            return this;
        }
        return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, ozone);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFioDataPoint && this.equalTo((ImmutableFioDataPoint)another);
    }

    private boolean equalTo(ImmutableFioDataPoint another) {
        return this.time == another.time && Objects.equals(this.summary, another.summary) && Objects.equals((Object)this.icon, (Object)another.icon) && Objects.equals(this.sunriseTime, another.sunriseTime) && Objects.equals(this.sunsetTime, another.sunsetTime) && Objects.equals(this.moonPhase, another.moonPhase) && Objects.equals(this.nearestStormDistance, another.nearestStormDistance) && Objects.equals(this.nearestStormBearing, another.nearestStormBearing) && Objects.equals(this.precipIntensity, another.precipIntensity) && Objects.equals(this.precipIntensityMax, another.precipIntensityMax) && Objects.equals(this.precipIntensityMaxTime, another.precipIntensityMaxTime) && Objects.equals(this.precipProbability, another.precipProbability) && Objects.equals((Object)this.precipType, (Object)another.precipType) && Objects.equals(this.precipAccumulation, another.precipAccumulation) && Objects.equals(this.temperature, another.temperature) && Objects.equals(this.temperatureMin, another.temperatureMin) && Objects.equals(this.temperatureMinTime, another.temperatureMinTime) && Objects.equals(this.temperatureMax, another.temperatureMax) && Objects.equals(this.temperatureMaxTime, another.temperatureMaxTime) && Objects.equals(this.apparentTemperature, another.apparentTemperature) && Objects.equals(this.apparentTemperatureMin, another.apparentTemperatureMin) && Objects.equals(this.apparentTemperatureMinTime, another.apparentTemperatureMinTime) && Objects.equals(this.apparentTemperatureMax, another.apparentTemperatureMax) && Objects.equals(this.apparentTemperatureMaxTime, another.apparentTemperatureMaxTime) && Objects.equals(this.dewPoint, another.dewPoint) && Objects.equals(this.windSpeed, another.windSpeed) && Objects.equals(this.windBearing, another.windBearing) && Objects.equals(this.cloudCover, another.cloudCover) && Objects.equals(this.humidity, another.humidity) && Objects.equals(this.pressure, another.pressure) && Objects.equals(this.visibility, another.visibility) && Objects.equals(this.ozone, another.ozone);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Long.hashCode(this.time);
        h = h * 17 + Objects.hashCode(this.summary);
        h = h * 17 + Objects.hashCode((Object)this.icon);
        h = h * 17 + Objects.hashCode(this.sunriseTime);
        h = h * 17 + Objects.hashCode(this.sunsetTime);
        h = h * 17 + Objects.hashCode(this.moonPhase);
        h = h * 17 + Objects.hashCode(this.nearestStormDistance);
        h = h * 17 + Objects.hashCode(this.nearestStormBearing);
        h = h * 17 + Objects.hashCode(this.precipIntensity);
        h = h * 17 + Objects.hashCode(this.precipIntensityMax);
        h = h * 17 + Objects.hashCode(this.precipIntensityMaxTime);
        h = h * 17 + Objects.hashCode(this.precipProbability);
        h = h * 17 + Objects.hashCode((Object)this.precipType);
        h = h * 17 + Objects.hashCode(this.precipAccumulation);
        h = h * 17 + Objects.hashCode(this.temperature);
        h = h * 17 + Objects.hashCode(this.temperatureMin);
        h = h * 17 + Objects.hashCode(this.temperatureMinTime);
        h = h * 17 + Objects.hashCode(this.temperatureMax);
        h = h * 17 + Objects.hashCode(this.temperatureMaxTime);
        h = h * 17 + Objects.hashCode(this.apparentTemperature);
        h = h * 17 + Objects.hashCode(this.apparentTemperatureMin);
        h = h * 17 + Objects.hashCode(this.apparentTemperatureMinTime);
        h = h * 17 + Objects.hashCode(this.apparentTemperatureMax);
        h = h * 17 + Objects.hashCode(this.apparentTemperatureMaxTime);
        h = h * 17 + Objects.hashCode(this.dewPoint);
        h = h * 17 + Objects.hashCode(this.windSpeed);
        h = h * 17 + Objects.hashCode(this.windBearing);
        h = h * 17 + Objects.hashCode(this.cloudCover);
        h = h * 17 + Objects.hashCode(this.humidity);
        h = h * 17 + Objects.hashCode(this.pressure);
        h = h * 17 + Objects.hashCode(this.visibility);
        h = h * 17 + Objects.hashCode(this.ozone);
        return h;
    }

    public String toString() {
        return "FioDataPoint{time=" + this.time + ", summary=" + this.summary + ", icon=" + (Object)((Object)this.icon) + ", sunriseTime=" + this.sunriseTime + ", sunsetTime=" + this.sunsetTime + ", moonPhase=" + this.moonPhase + ", nearestStormDistance=" + this.nearestStormDistance + ", nearestStormBearing=" + this.nearestStormBearing + ", precipIntensity=" + this.precipIntensity + ", precipIntensityMax=" + this.precipIntensityMax + ", precipIntensityMaxTime=" + this.precipIntensityMaxTime + ", precipProbability=" + this.precipProbability + ", precipType=" + (Object)((Object)this.precipType) + ", precipAccumulation=" + this.precipAccumulation + ", temperature=" + this.temperature + ", temperatureMin=" + this.temperatureMin + ", temperatureMinTime=" + this.temperatureMinTime + ", temperatureMax=" + this.temperatureMax + ", temperatureMaxTime=" + this.temperatureMaxTime + ", apparentTemperature=" + this.apparentTemperature + ", apparentTemperatureMin=" + this.apparentTemperatureMin + ", apparentTemperatureMinTime=" + this.apparentTemperatureMinTime + ", apparentTemperatureMax=" + this.apparentTemperatureMax + ", apparentTemperatureMaxTime=" + this.apparentTemperatureMaxTime + ", dewPoint=" + this.dewPoint + ", windSpeed=" + this.windSpeed + ", windBearing=" + this.windBearing + ", cloudCover=" + this.cloudCover + ", humidity=" + this.humidity + ", pressure=" + this.pressure + ", visibility=" + this.visibility + ", ozone=" + this.ozone + "}";
    }

    @Deprecated
    @JsonCreator
    static ImmutableFioDataPoint fromJson(Json json) {
        Builder builder = ImmutableFioDataPoint.builder();
        if (json.timeIsSet) {
            builder.time(json.time);
        }
        if (json.summary != null) {
            builder.summary(json.summary);
        }
        if (json.icon != null) {
            builder.icon(json.icon);
        }
        if (json.sunriseTime != null) {
            builder.sunriseTime(json.sunriseTime);
        }
        if (json.sunsetTime != null) {
            builder.sunsetTime(json.sunsetTime);
        }
        if (json.moonPhase != null) {
            builder.moonPhase(json.moonPhase);
        }
        if (json.nearestStormDistance != null) {
            builder.nearestStormDistance(json.nearestStormDistance);
        }
        if (json.nearestStormBearing != null) {
            builder.nearestStormBearing(json.nearestStormBearing);
        }
        if (json.precipIntensity != null) {
            builder.precipIntensity(json.precipIntensity);
        }
        if (json.precipIntensityMax != null) {
            builder.precipIntensityMax(json.precipIntensityMax);
        }
        if (json.precipIntensityMaxTime != null) {
            builder.precipIntensityMaxTime(json.precipIntensityMaxTime);
        }
        if (json.precipProbability != null) {
            builder.precipProbability(json.precipProbability);
        }
        if (json.precipType != null) {
            builder.precipType(json.precipType);
        }
        if (json.precipAccumulation != null) {
            builder.precipAccumulation(json.precipAccumulation);
        }
        if (json.temperature != null) {
            builder.temperature(json.temperature);
        }
        if (json.temperatureMin != null) {
            builder.temperatureMin(json.temperatureMin);
        }
        if (json.temperatureMinTime != null) {
            builder.temperatureMinTime(json.temperatureMinTime);
        }
        if (json.temperatureMax != null) {
            builder.temperatureMax(json.temperatureMax);
        }
        if (json.temperatureMaxTime != null) {
            builder.temperatureMaxTime(json.temperatureMaxTime);
        }
        if (json.apparentTemperature != null) {
            builder.apparentTemperature(json.apparentTemperature);
        }
        if (json.apparentTemperatureMin != null) {
            builder.apparentTemperatureMin(json.apparentTemperatureMin);
        }
        if (json.apparentTemperatureMinTime != null) {
            builder.apparentTemperatureMinTime(json.apparentTemperatureMinTime);
        }
        if (json.apparentTemperatureMax != null) {
            builder.apparentTemperatureMax(json.apparentTemperatureMax);
        }
        if (json.apparentTemperatureMaxTime != null) {
            builder.apparentTemperatureMaxTime(json.apparentTemperatureMaxTime);
        }
        if (json.dewPoint != null) {
            builder.dewPoint(json.dewPoint);
        }
        if (json.windSpeed != null) {
            builder.windSpeed(json.windSpeed);
        }
        if (json.windBearing != null) {
            builder.windBearing(json.windBearing);
        }
        if (json.cloudCover != null) {
            builder.cloudCover(json.cloudCover);
        }
        if (json.humidity != null) {
            builder.humidity(json.humidity);
        }
        if (json.pressure != null) {
            builder.pressure(json.pressure);
        }
        if (json.visibility != null) {
            builder.visibility(json.visibility);
        }
        if (json.ozone != null) {
            builder.ozone(json.ozone);
        }
        return builder.build();
    }

    public static ImmutableFioDataPoint copyOf(FioDataPoint instance) {
        if (instance instanceof ImmutableFioDataPoint) {
            return (ImmutableFioDataPoint)instance;
        }
        return ImmutableFioDataPoint.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_TIME = 1L;
        private long initBits = 1L;
        private long time;
        private String summary;
        private FioIcon icon;
        private Long sunriseTime;
        private Long sunsetTime;
        private BigDecimal moonPhase;
        private BigDecimal nearestStormDistance;
        private BigDecimal nearestStormBearing;
        private BigDecimal precipIntensity;
        private BigDecimal precipIntensityMax;
        private Long precipIntensityMaxTime;
        private BigDecimal precipProbability;
        private FioPrecipType precipType;
        private BigDecimal precipAccumulation;
        private BigDecimal temperature;
        private BigDecimal temperatureMin;
        private Long temperatureMinTime;
        private BigDecimal temperatureMax;
        private Long temperatureMaxTime;
        private BigDecimal apparentTemperature;
        private BigDecimal apparentTemperatureMin;
        private Long apparentTemperatureMinTime;
        private BigDecimal apparentTemperatureMax;
        private Long apparentTemperatureMaxTime;
        private BigDecimal dewPoint;
        private BigDecimal windSpeed;
        private BigDecimal windBearing;
        private BigDecimal cloudCover;
        private BigDecimal humidity;
        private BigDecimal pressure;
        private BigDecimal visibility;
        private BigDecimal ozone;

        private Builder() {
        }

        public final Builder from(FioDataPoint instance) {
            BigDecimal ozoneValue;
            BigDecimal visibilityValue;
            BigDecimal pressureValue;
            BigDecimal humidityValue;
            BigDecimal cloudCoverValue;
            BigDecimal windBearingValue;
            BigDecimal windSpeedValue;
            BigDecimal dewPointValue;
            Long apparentTemperatureMaxTimeValue;
            BigDecimal apparentTemperatureMaxValue;
            Long apparentTemperatureMinTimeValue;
            BigDecimal apparentTemperatureMinValue;
            BigDecimal apparentTemperatureValue;
            Long temperatureMaxTimeValue;
            BigDecimal temperatureMaxValue;
            Long temperatureMinTimeValue;
            BigDecimal temperatureMinValue;
            BigDecimal temperatureValue;
            BigDecimal precipAccumulationValue;
            FioPrecipType precipTypeValue;
            BigDecimal precipProbabilityValue;
            Long precipIntensityMaxTimeValue;
            BigDecimal precipIntensityMaxValue;
            BigDecimal precipIntensityValue;
            BigDecimal nearestStormBearingValue;
            BigDecimal nearestStormDistanceValue;
            BigDecimal moonPhaseValue;
            Long sunsetTimeValue;
            Long sunriseTimeValue;
            FioIcon iconValue;
            Objects.requireNonNull(instance, "instance");
            this.time(instance.time());
            String summaryValue = instance.summary();
            if (summaryValue != null) {
                this.summary(summaryValue);
            }
            if ((iconValue = instance.icon()) != null) {
                this.icon(iconValue);
            }
            if ((sunriseTimeValue = instance.sunriseTime()) != null) {
                this.sunriseTime(sunriseTimeValue);
            }
            if ((sunsetTimeValue = instance.sunsetTime()) != null) {
                this.sunsetTime(sunsetTimeValue);
            }
            if ((moonPhaseValue = instance.moonPhase()) != null) {
                this.moonPhase(moonPhaseValue);
            }
            if ((nearestStormDistanceValue = instance.nearestStormDistance()) != null) {
                this.nearestStormDistance(nearestStormDistanceValue);
            }
            if ((nearestStormBearingValue = instance.nearestStormBearing()) != null) {
                this.nearestStormBearing(nearestStormBearingValue);
            }
            if ((precipIntensityValue = instance.precipIntensity()) != null) {
                this.precipIntensity(precipIntensityValue);
            }
            if ((precipIntensityMaxValue = instance.precipIntensityMax()) != null) {
                this.precipIntensityMax(precipIntensityMaxValue);
            }
            if ((precipIntensityMaxTimeValue = instance.precipIntensityMaxTime()) != null) {
                this.precipIntensityMaxTime(precipIntensityMaxTimeValue);
            }
            if ((precipProbabilityValue = instance.precipProbability()) != null) {
                this.precipProbability(precipProbabilityValue);
            }
            if ((precipTypeValue = instance.precipType()) != null) {
                this.precipType(precipTypeValue);
            }
            if ((precipAccumulationValue = instance.precipAccumulation()) != null) {
                this.precipAccumulation(precipAccumulationValue);
            }
            if ((temperatureValue = instance.temperature()) != null) {
                this.temperature(temperatureValue);
            }
            if ((temperatureMinValue = instance.temperatureMin()) != null) {
                this.temperatureMin(temperatureMinValue);
            }
            if ((temperatureMinTimeValue = instance.temperatureMinTime()) != null) {
                this.temperatureMinTime(temperatureMinTimeValue);
            }
            if ((temperatureMaxValue = instance.temperatureMax()) != null) {
                this.temperatureMax(temperatureMaxValue);
            }
            if ((temperatureMaxTimeValue = instance.temperatureMaxTime()) != null) {
                this.temperatureMaxTime(temperatureMaxTimeValue);
            }
            if ((apparentTemperatureValue = instance.apparentTemperature()) != null) {
                this.apparentTemperature(apparentTemperatureValue);
            }
            if ((apparentTemperatureMinValue = instance.apparentTemperatureMin()) != null) {
                this.apparentTemperatureMin(apparentTemperatureMinValue);
            }
            if ((apparentTemperatureMinTimeValue = instance.apparentTemperatureMinTime()) != null) {
                this.apparentTemperatureMinTime(apparentTemperatureMinTimeValue);
            }
            if ((apparentTemperatureMaxValue = instance.apparentTemperatureMax()) != null) {
                this.apparentTemperatureMax(apparentTemperatureMaxValue);
            }
            if ((apparentTemperatureMaxTimeValue = instance.apparentTemperatureMaxTime()) != null) {
                this.apparentTemperatureMaxTime(apparentTemperatureMaxTimeValue);
            }
            if ((dewPointValue = instance.dewPoint()) != null) {
                this.dewPoint(dewPointValue);
            }
            if ((windSpeedValue = instance.windSpeed()) != null) {
                this.windSpeed(windSpeedValue);
            }
            if ((windBearingValue = instance.windBearing()) != null) {
                this.windBearing(windBearingValue);
            }
            if ((cloudCoverValue = instance.cloudCover()) != null) {
                this.cloudCover(cloudCoverValue);
            }
            if ((humidityValue = instance.humidity()) != null) {
                this.humidity(humidityValue);
            }
            if ((pressureValue = instance.pressure()) != null) {
                this.pressure(pressureValue);
            }
            if ((visibilityValue = instance.visibility()) != null) {
                this.visibility(visibilityValue);
            }
            if ((ozoneValue = instance.ozone()) != null) {
                this.ozone(ozoneValue);
            }
            return this;
        }

        public final Builder time(long time) {
            this.time = time;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder summary(@Nullable String summary) {
            this.summary = summary;
            return this;
        }

        public final Builder icon(@Nullable FioIcon icon) {
            this.icon = icon;
            return this;
        }

        public final Builder sunriseTime(@Nullable Long sunriseTime) {
            this.sunriseTime = sunriseTime;
            return this;
        }

        public final Builder sunsetTime(@Nullable Long sunsetTime) {
            this.sunsetTime = sunsetTime;
            return this;
        }

        public final Builder moonPhase(@Nullable BigDecimal moonPhase) {
            this.moonPhase = moonPhase;
            return this;
        }

        public final Builder nearestStormDistance(@Nullable BigDecimal nearestStormDistance) {
            this.nearestStormDistance = nearestStormDistance;
            return this;
        }

        public final Builder nearestStormBearing(@Nullable BigDecimal nearestStormBearing) {
            this.nearestStormBearing = nearestStormBearing;
            return this;
        }

        public final Builder precipIntensity(@Nullable BigDecimal precipIntensity) {
            this.precipIntensity = precipIntensity;
            return this;
        }

        public final Builder precipIntensityMax(@Nullable BigDecimal precipIntensityMax) {
            this.precipIntensityMax = precipIntensityMax;
            return this;
        }

        public final Builder precipIntensityMaxTime(@Nullable Long precipIntensityMaxTime) {
            this.precipIntensityMaxTime = precipIntensityMaxTime;
            return this;
        }

        public final Builder precipProbability(@Nullable BigDecimal precipProbability) {
            this.precipProbability = precipProbability;
            return this;
        }

        public final Builder precipType(@Nullable FioPrecipType precipType) {
            this.precipType = precipType;
            return this;
        }

        public final Builder precipAccumulation(@Nullable BigDecimal precipAccumulation) {
            this.precipAccumulation = precipAccumulation;
            return this;
        }

        public final Builder temperature(@Nullable BigDecimal temperature) {
            this.temperature = temperature;
            return this;
        }

        public final Builder temperatureMin(@Nullable BigDecimal temperatureMin) {
            this.temperatureMin = temperatureMin;
            return this;
        }

        public final Builder temperatureMinTime(@Nullable Long temperatureMinTime) {
            this.temperatureMinTime = temperatureMinTime;
            return this;
        }

        public final Builder temperatureMax(@Nullable BigDecimal temperatureMax) {
            this.temperatureMax = temperatureMax;
            return this;
        }

        public final Builder temperatureMaxTime(@Nullable Long temperatureMaxTime) {
            this.temperatureMaxTime = temperatureMaxTime;
            return this;
        }

        public final Builder apparentTemperature(@Nullable BigDecimal apparentTemperature) {
            this.apparentTemperature = apparentTemperature;
            return this;
        }

        public final Builder apparentTemperatureMin(@Nullable BigDecimal apparentTemperatureMin) {
            this.apparentTemperatureMin = apparentTemperatureMin;
            return this;
        }

        public final Builder apparentTemperatureMinTime(@Nullable Long apparentTemperatureMinTime) {
            this.apparentTemperatureMinTime = apparentTemperatureMinTime;
            return this;
        }

        public final Builder apparentTemperatureMax(@Nullable BigDecimal apparentTemperatureMax) {
            this.apparentTemperatureMax = apparentTemperatureMax;
            return this;
        }

        public final Builder apparentTemperatureMaxTime(@Nullable Long apparentTemperatureMaxTime) {
            this.apparentTemperatureMaxTime = apparentTemperatureMaxTime;
            return this;
        }

        public final Builder dewPoint(@Nullable BigDecimal dewPoint) {
            this.dewPoint = dewPoint;
            return this;
        }

        public final Builder windSpeed(@Nullable BigDecimal windSpeed) {
            this.windSpeed = windSpeed;
            return this;
        }

        public final Builder windBearing(@Nullable BigDecimal windBearing) {
            this.windBearing = windBearing;
            return this;
        }

        public final Builder cloudCover(@Nullable BigDecimal cloudCover) {
            this.cloudCover = cloudCover;
            return this;
        }

        public final Builder humidity(@Nullable BigDecimal humidity) {
            this.humidity = humidity;
            return this;
        }

        public final Builder pressure(@Nullable BigDecimal pressure) {
            this.pressure = pressure;
            return this;
        }

        public final Builder visibility(@Nullable BigDecimal visibility) {
            this.visibility = visibility;
            return this;
        }

        public final Builder ozone(@Nullable BigDecimal ozone) {
            this.ozone = ozone;
            return this;
        }

        public ImmutableFioDataPoint build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFioDataPoint(this.time, this.summary, this.icon, this.sunriseTime, this.sunsetTime, this.moonPhase, this.nearestStormDistance, this.nearestStormBearing, this.precipIntensity, this.precipIntensityMax, this.precipIntensityMaxTime, this.precipProbability, this.precipType, this.precipAccumulation, this.temperature, this.temperatureMin, this.temperatureMinTime, this.temperatureMax, this.temperatureMaxTime, this.apparentTemperature, this.apparentTemperatureMin, this.apparentTemperatureMinTime, this.apparentTemperatureMax, this.apparentTemperatureMaxTime, this.dewPoint, this.windSpeed, this.windBearing, this.cloudCover, this.humidity, this.pressure, this.visibility, this.ozone);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("time");
            }
            return "Cannot build FioDataPoint, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends FioDataPoint {
        long time;
        boolean timeIsSet;
        String summary;
        FioIcon icon;
        Long sunriseTime;
        Long sunsetTime;
        BigDecimal moonPhase;
        BigDecimal nearestStormDistance;
        BigDecimal nearestStormBearing;
        BigDecimal precipIntensity;
        BigDecimal precipIntensityMax;
        Long precipIntensityMaxTime;
        BigDecimal precipProbability;
        FioPrecipType precipType;
        BigDecimal precipAccumulation;
        BigDecimal temperature;
        BigDecimal temperatureMin;
        Long temperatureMinTime;
        BigDecimal temperatureMax;
        Long temperatureMaxTime;
        BigDecimal apparentTemperature;
        BigDecimal apparentTemperatureMin;
        Long apparentTemperatureMinTime;
        BigDecimal apparentTemperatureMax;
        Long apparentTemperatureMaxTime;
        BigDecimal dewPoint;
        BigDecimal windSpeed;
        BigDecimal windBearing;
        BigDecimal cloudCover;
        BigDecimal humidity;
        BigDecimal pressure;
        BigDecimal visibility;
        BigDecimal ozone;

        Json() {
        }

        @JsonProperty(value="time")
        public void setTime(long time) {
            this.time = time;
            this.timeIsSet = true;
        }

        @JsonProperty(value="summary")
        public void setSummary(@Nullable String summary) {
            this.summary = summary;
        }

        @JsonProperty(value="icon")
        @JsonDeserialize(using=FioIconDeserializer.class)
        public void setIcon(@Nullable FioIcon icon) {
            this.icon = icon;
        }

        @JsonProperty(value="sunriseTime")
        public void setSunriseTime(@Nullable Long sunriseTime) {
            this.sunriseTime = sunriseTime;
        }

        @JsonProperty(value="sunsetTime")
        public void setSunsetTime(@Nullable Long sunsetTime) {
            this.sunsetTime = sunsetTime;
        }

        @JsonProperty(value="moonPhase")
        public void setMoonPhase(@Nullable BigDecimal moonPhase) {
            this.moonPhase = moonPhase;
        }

        @JsonProperty(value="nearestStormDistance")
        public void setNearestStormDistance(@Nullable BigDecimal nearestStormDistance) {
            this.nearestStormDistance = nearestStormDistance;
        }

        @JsonProperty(value="nearestStormBearing")
        public void setNearestStormBearing(@Nullable BigDecimal nearestStormBearing) {
            this.nearestStormBearing = nearestStormBearing;
        }

        @JsonProperty(value="precipIntensity")
        public void setPrecipIntensity(@Nullable BigDecimal precipIntensity) {
            this.precipIntensity = precipIntensity;
        }

        @JsonProperty(value="precipIntensityMax")
        public void setPrecipIntensityMax(@Nullable BigDecimal precipIntensityMax) {
            this.precipIntensityMax = precipIntensityMax;
        }

        @JsonProperty(value="precipIntensityMaxTime")
        public void setPrecipIntensityMaxTime(@Nullable Long precipIntensityMaxTime) {
            this.precipIntensityMaxTime = precipIntensityMaxTime;
        }

        @JsonProperty(value="precipProbability")
        public void setPrecipProbability(@Nullable BigDecimal precipProbability) {
            this.precipProbability = precipProbability;
        }

        @JsonProperty(value="precipType")
        @JsonDeserialize(using=FioPrecipTypeDeserializer.class)
        public void setPrecipType(@Nullable FioPrecipType precipType) {
            this.precipType = precipType;
        }

        @JsonProperty(value="precipAccumulation")
        public void setPrecipAccumulation(@Nullable BigDecimal precipAccumulation) {
            this.precipAccumulation = precipAccumulation;
        }

        @JsonProperty(value="temperature")
        public void setTemperature(@Nullable BigDecimal temperature) {
            this.temperature = temperature;
        }

        @JsonProperty(value="temperatureMin")
        public void setTemperatureMin(@Nullable BigDecimal temperatureMin) {
            this.temperatureMin = temperatureMin;
        }

        @JsonProperty(value="temperatureMinTime")
        public void setTemperatureMinTime(@Nullable Long temperatureMinTime) {
            this.temperatureMinTime = temperatureMinTime;
        }

        @JsonProperty(value="temperatureMax")
        public void setTemperatureMax(@Nullable BigDecimal temperatureMax) {
            this.temperatureMax = temperatureMax;
        }

        @JsonProperty(value="temperatureMaxTime")
        public void setTemperatureMaxTime(@Nullable Long temperatureMaxTime) {
            this.temperatureMaxTime = temperatureMaxTime;
        }

        @JsonProperty(value="apparentTemperature")
        public void setApparentTemperature(@Nullable BigDecimal apparentTemperature) {
            this.apparentTemperature = apparentTemperature;
        }

        @JsonProperty(value="apparentTemperatureMin")
        public void setApparentTemperatureMin(@Nullable BigDecimal apparentTemperatureMin) {
            this.apparentTemperatureMin = apparentTemperatureMin;
        }

        @JsonProperty(value="apparentTemperatureMinTime")
        public void setApparentTemperatureMinTime(@Nullable Long apparentTemperatureMinTime) {
            this.apparentTemperatureMinTime = apparentTemperatureMinTime;
        }

        @JsonProperty(value="apparentTemperatureMax")
        public void setApparentTemperatureMax(@Nullable BigDecimal apparentTemperatureMax) {
            this.apparentTemperatureMax = apparentTemperatureMax;
        }

        @JsonProperty(value="apparentTemperatureMaxTime")
        public void setApparentTemperatureMaxTime(@Nullable Long apparentTemperatureMaxTime) {
            this.apparentTemperatureMaxTime = apparentTemperatureMaxTime;
        }

        @JsonProperty(value="dewPoint")
        public void setDewPoint(@Nullable BigDecimal dewPoint) {
            this.dewPoint = dewPoint;
        }

        @JsonProperty(value="windSpeed")
        public void setWindSpeed(@Nullable BigDecimal windSpeed) {
            this.windSpeed = windSpeed;
        }

        @JsonProperty(value="windBearing")
        public void setWindBearing(@Nullable BigDecimal windBearing) {
            this.windBearing = windBearing;
        }

        @JsonProperty(value="cloudCover")
        public void setCloudCover(@Nullable BigDecimal cloudCover) {
            this.cloudCover = cloudCover;
        }

        @JsonProperty(value="humidity")
        public void setHumidity(@Nullable BigDecimal humidity) {
            this.humidity = humidity;
        }

        @JsonProperty(value="pressure")
        public void setPressure(@Nullable BigDecimal pressure) {
            this.pressure = pressure;
        }

        @JsonProperty(value="visibility")
        public void setVisibility(@Nullable BigDecimal visibility) {
            this.visibility = visibility;
        }

        @JsonProperty(value="ozone")
        public void setOzone(@Nullable BigDecimal ozone) {
            this.ozone = ozone;
        }

        @Override
        public long time() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String summary() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FioIcon icon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long sunriseTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long sunsetTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal moonPhase() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal nearestStormDistance() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal nearestStormBearing() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal precipIntensity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal precipIntensityMax() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long precipIntensityMaxTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal precipProbability() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FioPrecipType precipType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal precipAccumulation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal temperature() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal temperatureMin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long temperatureMinTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal temperatureMax() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long temperatureMaxTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal apparentTemperature() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal apparentTemperatureMin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long apparentTemperatureMinTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal apparentTemperatureMax() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long apparentTemperatureMaxTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal dewPoint() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal windSpeed() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal windBearing() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal cloudCover() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal humidity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal pressure() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal visibility() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BigDecimal ozone() {
            throw new UnsupportedOperationException();
        }
    }
}

