package ch.rasc.forcastio.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link FioRequest}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code new FioRequest.Builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "FioRequest"})
final class ImmutableFioRequest implements FioRequest {
  private final String latitude;
  private final String longitude;
  private final @Nullable Boolean extendHourly;
  private final @Nullable FioLanguage language;
  private final @Nullable FioUnit unit;
  private final Set<FioBlock> excludeBlocks;
  private final Set<FioBlock> includeBlocks;

  private ImmutableFioRequest(
      String latitude,
      String longitude,
      @Nullable Boolean extendHourly,
      @Nullable FioLanguage language,
      @Nullable FioUnit unit,
      Set<FioBlock> excludeBlocks,
      Set<FioBlock> includeBlocks) {
    this.latitude = latitude;
    this.longitude = longitude;
    this.extendHourly = extendHourly;
    this.language = language;
    this.unit = unit;
    this.excludeBlocks = excludeBlocks;
    this.includeBlocks = includeBlocks;
  }

  /**
   * @return The value of the {@code latitude} attribute
   */
  @Override
  public String latitude() {
    return latitude;
  }

  /**
   * @return The value of the {@code longitude} attribute
   */
  @Override
  public String longitude() {
    return longitude;
  }

  /**
   * @return The value of the {@code extendHourly} attribute
   */
  @Override
  public @Nullable Boolean extendHourly() {
    return extendHourly;
  }

  /**
   * @return The value of the {@code language} attribute
   */
  @Override
  public @Nullable FioLanguage language() {
    return language;
  }

  /**
   * @return The value of the {@code unit} attribute
   */
  @Override
  public @Nullable FioUnit unit() {
    return unit;
  }

  /**
   * @return The value of the {@code excludeBlocks} attribute
   */
  @Override
  public Set<FioBlock> excludeBlocks() {
    return excludeBlocks;
  }

  /**
   * @return The value of the {@code includeBlocks} attribute
   */
  @Override
  public Set<FioBlock> includeBlocks() {
    return includeBlocks;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioRequest#latitude() latitude} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param latitude A new value for latitude
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioRequest withLatitude(String latitude) {
    if (this.latitude.equals(latitude)) return this;
    String newValue = Objects.requireNonNull(latitude, "latitude");
    return new ImmutableFioRequest(
        newValue,
        this.longitude,
        this.extendHourly,
        this.language,
        this.unit,
        this.excludeBlocks,
        this.includeBlocks);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioRequest#longitude() longitude} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param longitude A new value for longitude
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioRequest withLongitude(String longitude) {
    if (this.longitude.equals(longitude)) return this;
    String newValue = Objects.requireNonNull(longitude, "longitude");
    return new ImmutableFioRequest(
        this.latitude,
        newValue,
        this.extendHourly,
        this.language,
        this.unit,
        this.excludeBlocks,
        this.includeBlocks);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioRequest#extendHourly() extendHourly} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param extendHourly A new value for extendHourly (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioRequest withExtendHourly(@Nullable Boolean extendHourly) {
    if (Objects.equals(this.extendHourly, extendHourly)) return this;
    return new ImmutableFioRequest(
        this.latitude,
        this.longitude,
        extendHourly,
        this.language,
        this.unit,
        this.excludeBlocks,
        this.includeBlocks);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioRequest#language() language} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param language A new value for language (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioRequest withLanguage(@Nullable FioLanguage language) {
    if (this.language == language) return this;
    return new ImmutableFioRequest(
        this.latitude,
        this.longitude,
        this.extendHourly,
        language,
        this.unit,
        this.excludeBlocks,
        this.includeBlocks);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioRequest#unit() unit} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param unit A new value for unit (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioRequest withUnit(@Nullable FioUnit unit) {
    if (this.unit == unit) return this;
    return new ImmutableFioRequest(
        this.latitude,
        this.longitude,
        this.extendHourly,
        this.language,
        unit,
        this.excludeBlocks,
        this.includeBlocks);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioRequest#excludeBlocks() excludeBlocks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioRequest withExcludeBlocks(FioBlock... elements) {
    Set<FioBlock> newValue = createUnmodifiableEnumSet(Arrays.asList(elements));
    return new ImmutableFioRequest(
        this.latitude,
        this.longitude,
        this.extendHourly,
        this.language,
        this.unit,
        newValue,
        this.includeBlocks);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioRequest#excludeBlocks() excludeBlocks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of excludeBlocks elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioRequest withExcludeBlocks(Iterable<FioBlock> elements) {
    if (this.excludeBlocks == elements) return this;
    Set<FioBlock> newValue = createUnmodifiableEnumSet(elements);
    return new ImmutableFioRequest(
        this.latitude,
        this.longitude,
        this.extendHourly,
        this.language,
        this.unit,
        newValue,
        this.includeBlocks);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioRequest#includeBlocks() includeBlocks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioRequest withIncludeBlocks(FioBlock... elements) {
    Set<FioBlock> newValue = createUnmodifiableEnumSet(Arrays.asList(elements));
    return new ImmutableFioRequest(
        this.latitude,
        this.longitude,
        this.extendHourly,
        this.language,
        this.unit,
        this.excludeBlocks,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioRequest#includeBlocks() includeBlocks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of includeBlocks elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioRequest withIncludeBlocks(Iterable<FioBlock> elements) {
    if (this.includeBlocks == elements) return this;
    Set<FioBlock> newValue = createUnmodifiableEnumSet(elements);
    return new ImmutableFioRequest(
        this.latitude,
        this.longitude,
        this.extendHourly,
        this.language,
        this.unit,
        this.excludeBlocks,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFioRequest} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFioRequest
        && equalTo((ImmutableFioRequest) another);
  }

  private boolean equalTo(ImmutableFioRequest another) {
    return latitude.equals(another.latitude)
        && longitude.equals(another.longitude)
        && Objects.equals(extendHourly, another.extendHourly)
        && Objects.equals(language, another.language)
        && Objects.equals(unit, another.unit)
        && excludeBlocks.equals(another.excludeBlocks)
        && includeBlocks.equals(another.includeBlocks);
  }

  /**
   * Computes a hash code from attributes: {@code latitude}, {@code longitude}, {@code extendHourly}, {@code language}, {@code unit}, {@code excludeBlocks}, {@code includeBlocks}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + latitude.hashCode();
    h = h * 17 + longitude.hashCode();
    h = h * 17 + Objects.hashCode(extendHourly);
    h = h * 17 + Objects.hashCode(language);
    h = h * 17 + Objects.hashCode(unit);
    h = h * 17 + excludeBlocks.hashCode();
    h = h * 17 + includeBlocks.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FioRequest} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FioRequest{"
        + "latitude=" + latitude
        + ", longitude=" + longitude
        + ", extendHourly=" + extendHourly
        + ", language=" + language
        + ", unit=" + unit
        + ", excludeBlocks=" + excludeBlocks
        + ", includeBlocks=" + includeBlocks
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link FioRequest} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FioRequest instance
   */
  public static ImmutableFioRequest copyOf(FioRequest instance) {
    if (instance instanceof ImmutableFioRequest) {
      return (ImmutableFioRequest) instance;
    }
    return new FioRequest.Builder()
        .from(instance)
        .build();
  }

  /**
   * Builds instances of type {@link ImmutableFioRequest ImmutableFioRequest}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static class Builder {
    private static final long INIT_BIT_LATITUDE = 0x1L;
    private static final long INIT_BIT_LONGITUDE = 0x2L;
    private long initBits = 0x3L;

    private String latitude;
    private String longitude;
    private Boolean extendHourly;
    private FioLanguage language;
    private FioUnit unit;
    private EnumSet<FioBlock> excludeBlocks = EnumSet.noneOf(FioBlock.class);
    private EnumSet<FioBlock> includeBlocks = EnumSet.noneOf(FioBlock.class);

    /**
     * Creates a builder for {@link ImmutableFioRequest ImmutableFioRequest} instances.
     */
    Builder() {
      if (!(this instanceof FioRequest.Builder)) {
        throw new UnsupportedOperationException("Use: new FioRequest.Builder()");
      }
    }

    /**
     * Fill a builder with attribute values from the provided {@code FioRequest} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final FioRequest.Builder from(FioRequest instance) {
      Objects.requireNonNull(instance, "instance");
      latitude(instance.latitude());
      longitude(instance.longitude());
      @Nullable Boolean extendHourlyValue = instance.extendHourly();
      if (extendHourlyValue != null) {
        extendHourly(extendHourlyValue);
      }
      @Nullable FioLanguage languageValue = instance.language();
      if (languageValue != null) {
        language(languageValue);
      }
      @Nullable FioUnit unitValue = instance.unit();
      if (unitValue != null) {
        unit(unitValue);
      }
      addAllExcludeBlocks(instance.excludeBlocks());
      addAllIncludeBlocks(instance.includeBlocks());
      return (FioRequest.Builder) this;
    }

    /**
     * Initializes the value for the {@link FioRequest#latitude() latitude} attribute.
     * @param latitude The value for latitude 
     * @return {@code this} builder for use in a chained invocation
     */
    public final FioRequest.Builder latitude(String latitude) {
      this.latitude = Objects.requireNonNull(latitude, "latitude");
      initBits &= ~INIT_BIT_LATITUDE;
      return (FioRequest.Builder) this;
    }

    /**
     * Initializes the value for the {@link FioRequest#longitude() longitude} attribute.
     * @param longitude The value for longitude 
     * @return {@code this} builder for use in a chained invocation
     */
    public final FioRequest.Builder longitude(String longitude) {
      this.longitude = Objects.requireNonNull(longitude, "longitude");
      initBits &= ~INIT_BIT_LONGITUDE;
      return (FioRequest.Builder) this;
    }

    /**
     * Initializes the value for the {@link FioRequest#extendHourly() extendHourly} attribute.
     * @param extendHourly The value for extendHourly (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final FioRequest.Builder extendHourly(@Nullable Boolean extendHourly) {
      this.extendHourly = extendHourly;
      return (FioRequest.Builder) this;
    }

    /**
     * Initializes the value for the {@link FioRequest#language() language} attribute.
     * @param language The value for language (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final FioRequest.Builder language(@Nullable FioLanguage language) {
      this.language = language;
      return (FioRequest.Builder) this;
    }

    /**
     * Initializes the value for the {@link FioRequest#unit() unit} attribute.
     * @param unit The value for unit (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    public final FioRequest.Builder unit(@Nullable FioUnit unit) {
      this.unit = unit;
      return (FioRequest.Builder) this;
    }

    /**
     * Adds one element to {@link FioRequest#excludeBlocks() excludeBlocks} set.
     * @param element A excludeBlocks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final FioRequest.Builder excludeBlock(FioBlock element) {
      this.excludeBlocks.add(Objects.requireNonNull(element, "excludeBlocks element"));
      return (FioRequest.Builder) this;
    }

    /**
     * Adds elements to {@link FioRequest#excludeBlocks() excludeBlocks} set.
     * @param elements An array of excludeBlocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final FioRequest.Builder excludeBlock(FioBlock... elements) {
      for (FioBlock element : elements) {
        this.excludeBlocks.add(Objects.requireNonNull(element, "excludeBlocks element"));
      }
      return (FioRequest.Builder) this;
    }

    /**
     * Sets or replaces all elements for {@link FioRequest#excludeBlocks() excludeBlocks} set.
     * @param elements An iterable of excludeBlocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final FioRequest.Builder excludeBlocks(Iterable<FioBlock> elements) {
      this.excludeBlocks.clear();
      return addAllExcludeBlocks(elements);
    }

    /**
     * Adds elements to {@link FioRequest#excludeBlocks() excludeBlocks} set.
     * @param elements An iterable of excludeBlocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final FioRequest.Builder addAllExcludeBlocks(Iterable<FioBlock> elements) {
      for (FioBlock element : elements) {
        this.excludeBlocks.add(Objects.requireNonNull(element, "excludeBlocks element"));
      }
      return (FioRequest.Builder) this;
    }

    /**
     * Adds one element to {@link FioRequest#includeBlocks() includeBlocks} set.
     * @param element A includeBlocks element
     * @return {@code this} builder for use in a chained invocation
     */
    public final FioRequest.Builder includeBlock(FioBlock element) {
      this.includeBlocks.add(Objects.requireNonNull(element, "includeBlocks element"));
      return (FioRequest.Builder) this;
    }

    /**
     * Adds elements to {@link FioRequest#includeBlocks() includeBlocks} set.
     * @param elements An array of includeBlocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final FioRequest.Builder includeBlock(FioBlock... elements) {
      for (FioBlock element : elements) {
        this.includeBlocks.add(Objects.requireNonNull(element, "includeBlocks element"));
      }
      return (FioRequest.Builder) this;
    }

    /**
     * Sets or replaces all elements for {@link FioRequest#includeBlocks() includeBlocks} set.
     * @param elements An iterable of includeBlocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final FioRequest.Builder includeBlocks(Iterable<FioBlock> elements) {
      this.includeBlocks.clear();
      return addAllIncludeBlocks(elements);
    }

    /**
     * Adds elements to {@link FioRequest#includeBlocks() includeBlocks} set.
     * @param elements An iterable of includeBlocks elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final FioRequest.Builder addAllIncludeBlocks(Iterable<FioBlock> elements) {
      for (FioBlock element : elements) {
        this.includeBlocks.add(Objects.requireNonNull(element, "includeBlocks element"));
      }
      return (FioRequest.Builder) this;
    }

    /**
     * Builds a new {@link ImmutableFioRequest ImmutableFioRequest}.
     * @return An immutable instance of FioRequest
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFioRequest build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFioRequest(
          latitude,
          longitude,
          extendHourly,
          language,
          unit,
          createUnmodifiableEnumSet(excludeBlocks),
          createUnmodifiableEnumSet(includeBlocks));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_LATITUDE) != 0) attributes.add("latitude");
      if ((initBits & INIT_BIT_LONGITUDE) != 0) attributes.add("longitude");
      return "Cannot build FioRequest, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
    if (iterable instanceof EnumSet<?>) {
      return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet<T>) iterable));
    }
    List<T> list = createSafeList(iterable, true, false);
    switch(list.size()) {
    case 0: return Collections.emptySet();
    case 1: return Collections.singleton(list.get(0));
    default: return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }
  }
}
