package ch.rasc.forcastio.model;

import ch.rasc.forcastio.converter.FioIconDeserializer;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link FioDataBlock}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFioDataBlock.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "FioDataBlock"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableFioDataBlock implements FioDataBlock {
  private final String summary;
  private final FioIcon icon;
  private final List<FioDataPoint> data;

  private ImmutableFioDataBlock(
      String summary,
      FioIcon icon,
      List<FioDataPoint> data) {
    this.summary = summary;
    this.icon = icon;
    this.data = data;
  }

  /**
   * A human-readable text summary of this data block.
   */
  @JsonProperty("summary")
  @Override
  public String summary() {
    return summary;
  }

  /**
   * A machine-readable text summary of this data block
   */
  @JsonProperty("icon")
  @JsonDeserialize(using = FioIconDeserializer.class)
  @Override
  public FioIcon icon() {
    return icon;
  }

  /**
   * A collection of {@link FioDataPoint} instances, ordered by time, which together
   * describe the weather conditions at the requested location over time.
   */
  @JsonProperty("data")
  @Override
  public List<FioDataPoint> data() {
    return data;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataBlock#summary() summary} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param summary A new value for summary
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataBlock withSummary(String summary) {
    if (this.summary.equals(summary)) return this;
    String newValue = Objects.requireNonNull(summary, "summary");
    return new ImmutableFioDataBlock(newValue, this.icon, this.data);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioDataBlock#icon() icon} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param icon A new value for icon
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioDataBlock withIcon(FioIcon icon) {
    if (this.icon == icon) return this;
    FioIcon newValue = Objects.requireNonNull(icon, "icon");
    return new ImmutableFioDataBlock(this.summary, newValue, this.data);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioDataBlock#data() data}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioDataBlock withData(FioDataPoint... elements) {
    List<FioDataPoint> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableFioDataBlock(this.summary, this.icon, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link FioDataBlock#data() data}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of data elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableFioDataBlock withData(Iterable<? extends FioDataPoint> elements) {
    if (this.data == elements) return this;
    List<FioDataPoint> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableFioDataBlock(this.summary, this.icon, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFioDataBlock} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFioDataBlock
        && equalTo((ImmutableFioDataBlock) another);
  }

  private boolean equalTo(ImmutableFioDataBlock another) {
    return summary.equals(another.summary)
        && icon.equals(another.icon)
        && data.equals(another.data);
  }

  /**
   * Computes a hash code from attributes: {@code summary}, {@code icon}, {@code data}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + summary.hashCode();
    h = h * 17 + icon.hashCode();
    h = h * 17 + data.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FioDataBlock} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FioDataBlock{"
        + "summary=" + summary
        + ", icon=" + icon
        + ", data=" + data
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FioDataBlock {
    String summary;
    FioIcon icon;
    List<FioDataPoint> data = Collections.emptyList();
    @JsonProperty("summary")
    public void setSummary(String summary) {
      this.summary = summary;
    }
    @JsonProperty("icon")
    @JsonDeserialize(using = FioIconDeserializer.class)
    public void setIcon(FioIcon icon) {
      this.icon = icon;
    }
    @JsonProperty("data")
    public void setData(List<FioDataPoint> data) {
      this.data = data;
    }
    @Override
    public String summary() { throw new UnsupportedOperationException(); }
    @Override
    public FioIcon icon() { throw new UnsupportedOperationException(); }
    @Override
    public List<FioDataPoint> data() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableFioDataBlock fromJson(Json json) {
    ImmutableFioDataBlock.Builder builder = ImmutableFioDataBlock.builder();
    if (json.summary != null) {
      builder.summary(json.summary);
    }
    if (json.icon != null) {
      builder.icon(json.icon);
    }
    if (json.data != null) {
      builder.addAllData(json.data);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FioDataBlock} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FioDataBlock instance
   */
  public static ImmutableFioDataBlock copyOf(FioDataBlock instance) {
    if (instance instanceof ImmutableFioDataBlock) {
      return (ImmutableFioDataBlock) instance;
    }
    return ImmutableFioDataBlock.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFioDataBlock ImmutableFioDataBlock}.
   * @return A new ImmutableFioDataBlock builder
   */
  public static ImmutableFioDataBlock.Builder builder() {
    return new ImmutableFioDataBlock.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFioDataBlock ImmutableFioDataBlock}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_SUMMARY = 0x1L;
    private static final long INIT_BIT_ICON = 0x2L;
    private long initBits = 0x3L;

    private String summary;
    private FioIcon icon;
    private List<FioDataPoint> data = new ArrayList<FioDataPoint>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FioDataBlock} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FioDataBlock instance) {
      Objects.requireNonNull(instance, "instance");
      summary(instance.summary());
      icon(instance.icon());
      addAllData(instance.data());
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataBlock#summary() summary} attribute.
     * @param summary The value for summary 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder summary(String summary) {
      this.summary = Objects.requireNonNull(summary, "summary");
      initBits &= ~INIT_BIT_SUMMARY;
      return this;
    }

    /**
     * Initializes the value for the {@link FioDataBlock#icon() icon} attribute.
     * @param icon The value for icon 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder icon(FioIcon icon) {
      this.icon = Objects.requireNonNull(icon, "icon");
      initBits &= ~INIT_BIT_ICON;
      return this;
    }

    /**
     * Adds one element to {@link FioDataBlock#data() data} list.
     * @param element A data element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addData(FioDataPoint element) {
      this.data.add(Objects.requireNonNull(element, "data element"));
      return this;
    }

    /**
     * Adds elements to {@link FioDataBlock#data() data} list.
     * @param elements An array of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addData(FioDataPoint... elements) {
      for (FioDataPoint element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link FioDataBlock#data() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder data(Iterable<? extends FioDataPoint> elements) {
      this.data.clear();
      return addAllData(elements);
    }

    /**
     * Adds elements to {@link FioDataBlock#data() data} list.
     * @param elements An iterable of data elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllData(Iterable<? extends FioDataPoint> elements) {
      for (FioDataPoint element : elements) {
        this.data.add(Objects.requireNonNull(element, "data element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableFioDataBlock ImmutableFioDataBlock}.
     * @return An immutable instance of FioDataBlock
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFioDataBlock build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFioDataBlock(summary, icon, createUnmodifiableList(true, data));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_SUMMARY) != 0) attributes.add("summary");
      if ((initBits & INIT_BIT_ICON) != 0) attributes.add("icon");
      return "Cannot build FioDataBlock, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
