package ch.rasc.forcastio.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;

/**
 * Immutable implementation of {@link FioAlert}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableFioAlert.builder()}.
 */
@SuppressWarnings("all")
@Generated({"Immutables.generator", "FioAlert"})
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableFioAlert implements FioAlert {
  private final String title;
  private final long expires;
  private final String uri;
  private final String description;

  private ImmutableFioAlert(String title, long expires, String uri, String description) {
    this.title = title;
    this.expires = expires;
    this.uri = uri;
    this.description = description;
  }

  /**
   * A short text summary of the alert.
   */
  @JsonProperty("title")
  @Override
  public String title() {
    return title;
  }

  /**
   * The UNIX time (that is, seconds since midnight GMT on 1 Jan 1970) at which the
   * alert will cease to be valid.
   */
  @JsonProperty("expires")
  @Override
  public long expires() {
    return expires;
  }

  /**
   * An HTTP(S) URI that contains detailed information about the alert.
   */
  @JsonProperty("uri")
  @Override
  public String uri() {
    return uri;
  }

  /**
   * A detailed text description of the alert from the appropriate weather service.
   */
  @JsonProperty("description")
  @Override
  public String description() {
    return description;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioAlert#title() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param title A new value for title
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioAlert withTitle(String title) {
    if (this.title.equals(title)) return this;
    String newValue = Objects.requireNonNull(title, "title");
    return new ImmutableFioAlert(newValue, this.expires, this.uri, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioAlert#expires() expires} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param expires A new value for expires
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioAlert withExpires(long expires) {
    if (this.expires == expires) return this;
    return new ImmutableFioAlert(this.title, expires, this.uri, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioAlert#uri() uri} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param uri A new value for uri
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioAlert withUri(String uri) {
    if (this.uri.equals(uri)) return this;
    String newValue = Objects.requireNonNull(uri, "uri");
    return new ImmutableFioAlert(this.title, this.expires, newValue, this.description);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link FioAlert#description() description} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param description A new value for description
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableFioAlert withDescription(String description) {
    if (this.description.equals(description)) return this;
    String newValue = Objects.requireNonNull(description, "description");
    return new ImmutableFioAlert(this.title, this.expires, this.uri, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableFioAlert} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableFioAlert
        && equalTo((ImmutableFioAlert) another);
  }

  private boolean equalTo(ImmutableFioAlert another) {
    return title.equals(another.title)
        && expires == another.expires
        && uri.equals(another.uri)
        && description.equals(another.description);
  }

  /**
   * Computes a hash code from attributes: {@code title}, {@code expires}, {@code uri}, {@code description}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + title.hashCode();
    h = h * 17 + Long.hashCode(expires);
    h = h * 17 + uri.hashCode();
    h = h * 17 + description.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code FioAlert} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "FioAlert{"
        + "title=" + title
        + ", expires=" + expires
        + ", uri=" + uri
        + ", description=" + description
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements FioAlert {
    String title;
    long expires;
    boolean expiresIsSet;
    String uri;
    String description;
    @JsonProperty("title")
    public void setTitle(String title) {
      this.title = title;
    }
    @JsonProperty("expires")
    public void setExpires(long expires) {
      this.expires = expires;
      this.expiresIsSet = true;
    }
    @JsonProperty("uri")
    public void setUri(String uri) {
      this.uri = uri;
    }
    @JsonProperty("description")
    public void setDescription(String description) {
      this.description = description;
    }
    @Override
    public String title() { throw new UnsupportedOperationException(); }
    @Override
    public long expires() { throw new UnsupportedOperationException(); }
    @Override
    public String uri() { throw new UnsupportedOperationException(); }
    @Override
    public String description() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImmutableFioAlert fromJson(Json json) {
    ImmutableFioAlert.Builder builder = ImmutableFioAlert.builder();
    if (json.title != null) {
      builder.title(json.title);
    }
    if (json.expiresIsSet) {
      builder.expires(json.expires);
    }
    if (json.uri != null) {
      builder.uri(json.uri);
    }
    if (json.description != null) {
      builder.description(json.description);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link FioAlert} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable FioAlert instance
   */
  public static ImmutableFioAlert copyOf(FioAlert instance) {
    if (instance instanceof ImmutableFioAlert) {
      return (ImmutableFioAlert) instance;
    }
    return ImmutableFioAlert.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableFioAlert ImmutableFioAlert}.
   * @return A new ImmutableFioAlert builder
   */
  public static ImmutableFioAlert.Builder builder() {
    return new ImmutableFioAlert.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableFioAlert ImmutableFioAlert}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  public static final class Builder {
    private static final long INIT_BIT_TITLE = 0x1L;
    private static final long INIT_BIT_EXPIRES = 0x2L;
    private static final long INIT_BIT_URI = 0x4L;
    private static final long INIT_BIT_DESCRIPTION = 0x8L;
    private long initBits = 0xfL;

    private String title;
    private long expires;
    private String uri;
    private String description;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code FioAlert} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(FioAlert instance) {
      Objects.requireNonNull(instance, "instance");
      title(instance.title());
      expires(instance.expires());
      uri(instance.uri());
      description(instance.description());
      return this;
    }

    /**
     * Initializes the value for the {@link FioAlert#title() title} attribute.
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder title(String title) {
      this.title = Objects.requireNonNull(title, "title");
      initBits &= ~INIT_BIT_TITLE;
      return this;
    }

    /**
     * Initializes the value for the {@link FioAlert#expires() expires} attribute.
     * @param expires The value for expires 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder expires(long expires) {
      this.expires = expires;
      initBits &= ~INIT_BIT_EXPIRES;
      return this;
    }

    /**
     * Initializes the value for the {@link FioAlert#uri() uri} attribute.
     * @param uri The value for uri 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder uri(String uri) {
      this.uri = Objects.requireNonNull(uri, "uri");
      initBits &= ~INIT_BIT_URI;
      return this;
    }

    /**
     * Initializes the value for the {@link FioAlert#description() description} attribute.
     * @param description The value for description 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder description(String description) {
      this.description = Objects.requireNonNull(description, "description");
      initBits &= ~INIT_BIT_DESCRIPTION;
      return this;
    }

    /**
     * Builds a new {@link ImmutableFioAlert ImmutableFioAlert}.
     * @return An immutable instance of FioAlert
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableFioAlert build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableFioAlert(title, expires, uri, description);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if ((initBits & INIT_BIT_TITLE) != 0) attributes.add("title");
      if ((initBits & INIT_BIT_EXPIRES) != 0) attributes.add("expires");
      if ((initBits & INIT_BIT_URI) != 0) attributes.add("uri");
      if ((initBits & INIT_BIT_DESCRIPTION) != 0) attributes.add("description");
      return "Cannot build FioAlert, some of required attributes are not set " + attributes;
    }
  }
}
