/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.extclassgenerator.validation;

import ch.rasc.extclassgenerator.IncludeValidation;
import ch.rasc.extclassgenerator.JsonViews;
import ch.rasc.extclassgenerator.ModelBean;
import ch.rasc.extclassgenerator.ModelFieldBean;
import ch.rasc.extclassgenerator.ModelValidation;
import ch.rasc.extclassgenerator.ModelValidationParameter;
import ch.rasc.extclassgenerator.ModelValidationType;
import ch.rasc.extclassgenerator.OutputConfig;
import ch.rasc.extclassgenerator.OutputFormat;
import ch.rasc.extclassgenerator.validation.CreditCardNumberValidation;
import ch.rasc.extclassgenerator.validation.DigitsValidation;
import ch.rasc.extclassgenerator.validation.EmailValidation;
import ch.rasc.extclassgenerator.validation.ExclusionValidation;
import ch.rasc.extclassgenerator.validation.ExclusionValidationArray;
import ch.rasc.extclassgenerator.validation.FormatValidation;
import ch.rasc.extclassgenerator.validation.FutureValidation;
import ch.rasc.extclassgenerator.validation.GenericValidation;
import ch.rasc.extclassgenerator.validation.InclusionValidation;
import ch.rasc.extclassgenerator.validation.InclusionValidationArray;
import ch.rasc.extclassgenerator.validation.LengthValidation;
import ch.rasc.extclassgenerator.validation.NotBlankValidation;
import ch.rasc.extclassgenerator.validation.PastValidation;
import ch.rasc.extclassgenerator.validation.PresenceValidation;
import ch.rasc.extclassgenerator.validation.RangeValidation;
import com.fasterxml.jackson.annotation.JsonView;
import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractValidation {
    private final String type;
    @JsonView(value={JsonViews.ExtJS4.class, JsonViews.Touch2.class})
    private final String field;

    public AbstractValidation(String type, String field) {
        this.type = type;
        this.field = field;
    }

    public String getType() {
        return this.type;
    }

    public String getField() {
        return this.field;
    }

    public static void addValidationToModel(ModelBean model, ModelFieldBean modelFieldBean, Annotation fieldAnnotation, OutputConfig outputConfig) {
        Number max;
        Number min;
        String annotationClassName = fieldAnnotation.annotationType().getName();
        IncludeValidation includeValidation = outputConfig.getIncludeValidation();
        if (includeValidation == IncludeValidation.BUILTIN || includeValidation == IncludeValidation.ALL) {
            if (annotationClassName.equals("javax.validation.constraints.NotNull") || annotationClassName.equals("org.hibernate.validator.constraints.NotEmpty") || annotationClassName.equals("javax.validation.constraints.NotEmpty")) {
                model.addValidation(new PresenceValidation(modelFieldBean.getName()));
            } else if (annotationClassName.equals("javax.validation.constraints.Size") || annotationClassName.equals("org.hibernate.validator.constraints.Length")) {
                min = (Integer)AnnotationUtils.getValue((Annotation)fieldAnnotation, (String)"min");
                max = (Integer)AnnotationUtils.getValue((Annotation)fieldAnnotation, (String)"max");
                model.addValidation(new LengthValidation(modelFieldBean.getName(), (Integer)min, (Integer)max));
            } else if (annotationClassName.equals("javax.validation.constraints.Pattern")) {
                String regexp = (String)AnnotationUtils.getValue((Annotation)fieldAnnotation, (String)"regexp");
                model.addValidation(new FormatValidation(modelFieldBean.getName(), regexp));
            } else if (annotationClassName.equals("org.hibernate.validator.constraints.Email") || annotationClassName.equals("javax.validation.constraints.Email")) {
                model.addValidation(new EmailValidation(modelFieldBean.getName()));
            }
        }
        if (includeValidation == IncludeValidation.BUILTIN && outputConfig.getOutputFormat() == OutputFormat.EXTJS5 || includeValidation == IncludeValidation.ALL) {
            Object value;
            if (annotationClassName.equals("javax.validation.constraints.DecimalMax")) {
                value = (String)AnnotationUtils.getValue((Annotation)fieldAnnotation);
                model.addValidation(new RangeValidation(modelFieldBean.getName(), null, new BigDecimal((String)value)));
            } else if (annotationClassName.equals("javax.validation.constraints.DecimalMin")) {
                value = (String)AnnotationUtils.getValue((Annotation)fieldAnnotation);
                model.addValidation(new RangeValidation(modelFieldBean.getName(), new BigDecimal((String)value), null));
            } else if (annotationClassName.equals("javax.validation.constraints.Max")) {
                value = (Long)AnnotationUtils.getValue((Annotation)fieldAnnotation);
                model.addValidation(new RangeValidation(modelFieldBean.getName(), null, (Long)value));
            } else if (annotationClassName.equals("javax.validation.constraints.Min")) {
                value = (Long)AnnotationUtils.getValue((Annotation)fieldAnnotation);
                model.addValidation(new RangeValidation(modelFieldBean.getName(), (Long)value, null));
            } else if (annotationClassName.equals("org.hibernate.validator.constraints.Range")) {
                min = (Long)AnnotationUtils.getValue((Annotation)fieldAnnotation, (String)"min");
                max = (Long)AnnotationUtils.getValue((Annotation)fieldAnnotation, (String)"max");
                model.addValidation(new RangeValidation(modelFieldBean.getName(), (Long)min, (Long)max));
            }
        }
        if (includeValidation == IncludeValidation.ALL) {
            if (annotationClassName.equals("javax.validation.constraints.Digits")) {
                Integer integer = (Integer)AnnotationUtils.getValue((Annotation)fieldAnnotation, (String)"integer");
                Integer fraction = (Integer)AnnotationUtils.getValue((Annotation)fieldAnnotation, (String)"fraction");
                model.addValidation(new DigitsValidation(modelFieldBean.getName(), integer, fraction));
            } else if (annotationClassName.equals("javax.validation.constraints.Future")) {
                model.addValidation(new FutureValidation(modelFieldBean.getName()));
            } else if (annotationClassName.equals("javax.validation.constraints.Past")) {
                model.addValidation(new PastValidation(modelFieldBean.getName()));
            } else if (annotationClassName.equals("org.hibernate.validator.constraints.CreditCardNumber")) {
                model.addValidation(new CreditCardNumberValidation(modelFieldBean.getName()));
            } else if (annotationClassName.equals("org.hibernate.validator.constraints.NotBlank") || annotationClassName.equals("javax.validation.constraints.NotBlank")) {
                model.addValidation(new NotBlankValidation(modelFieldBean.getName()));
            }
        }
    }

    public static AbstractValidation createValidation(String propertyName, ModelValidation modelValidationAnnotation, IncludeValidation includeValidation) {
        if (!StringUtils.hasText((String)propertyName)) {
            return null;
        }
        ModelValidationType validationType = modelValidationAnnotation.value();
        if ((includeValidation == IncludeValidation.ALL || includeValidation == IncludeValidation.BUILTIN && validationType.isBuiltin()) && validationType.isValid(modelValidationAnnotation)) {
            switch (validationType) {
                case GENERIC: {
                    String type = AbstractValidation.getParameterValue(modelValidationAnnotation.parameters(), "type");
                    LinkedHashMap<String, Object> options = new LinkedHashMap<String, Object>();
                    for (ModelValidationParameter parameter : modelValidationAnnotation.parameters()) {
                        if (parameter.name().equals("type")) continue;
                        options.put(parameter.name(), parameter.value());
                    }
                    return new GenericValidation(type, propertyName, options);
                }
                case CREDITCARDNUMBER: {
                    return new CreditCardNumberValidation(propertyName);
                }
                case DIGITS: {
                    String integer = AbstractValidation.getParameterValue(modelValidationAnnotation.parameters(), "integer");
                    String fraction = AbstractValidation.getParameterValue(modelValidationAnnotation.parameters(), "fraction");
                    return new DigitsValidation(propertyName, Integer.parseInt(integer), Integer.parseInt(fraction));
                }
                case EMAIL: {
                    return new EmailValidation(propertyName);
                }
                case FORMAT: {
                    return new FormatValidation(propertyName, modelValidationAnnotation.parameters()[0].value());
                }
                case FUTURE: {
                    return new FutureValidation(propertyName);
                }
                case INCLUSION: {
                    if (modelValidationAnnotation.exclusionOrInclusionList().length > 0) {
                        List<String> list = Arrays.asList(modelValidationAnnotation.exclusionOrInclusionList());
                        return new InclusionValidationArray(propertyName, list);
                    }
                    String list = AbstractValidation.getParameterValue(modelValidationAnnotation.parameters(), "list");
                    return new InclusionValidation(propertyName, list);
                }
                case EXCLUSION: {
                    if (modelValidationAnnotation.exclusionOrInclusionList().length > 0) {
                        List<String> list = Arrays.asList(modelValidationAnnotation.exclusionOrInclusionList());
                        return new ExclusionValidationArray(propertyName, list);
                    }
                    String list = AbstractValidation.getParameterValue(modelValidationAnnotation.parameters(), "list");
                    return new ExclusionValidation(propertyName, list);
                }
                case LENGTH: {
                    String minValue = AbstractValidation.getParameterValue(modelValidationAnnotation.parameters(), "min");
                    String maxValue = AbstractValidation.getParameterValue(modelValidationAnnotation.parameters(), "max");
                    Long min = null;
                    Long max = null;
                    if (minValue != null) {
                        min = Long.valueOf(minValue);
                    }
                    if (maxValue != null) {
                        max = Long.valueOf(maxValue);
                    }
                    return new LengthValidation(propertyName, min, max);
                }
                case NOTBLANK: {
                    return new NotBlankValidation(propertyName);
                }
                case PAST: {
                    return new PastValidation(propertyName);
                }
                case PRESENCE: {
                    return new PresenceValidation(propertyName);
                }
                case RANGE: {
                    String minValue = AbstractValidation.getParameterValue(modelValidationAnnotation.parameters(), "min");
                    String maxValue = AbstractValidation.getParameterValue(modelValidationAnnotation.parameters(), "max");
                    if (minValue != null && minValue.indexOf(".") != -1 || maxValue != null && maxValue.indexOf(".") != -1) {
                        BigDecimal minBD = null;
                        BigDecimal maxBD = null;
                        if (minValue != null) {
                            minBD = new BigDecimal(minValue);
                        }
                        if (maxValue != null) {
                            maxBD = new BigDecimal(maxValue);
                        }
                        return new RangeValidation(propertyName, minBD, maxBD);
                    }
                    Long min = null;
                    Long max = null;
                    if (minValue != null) {
                        min = Long.valueOf(minValue);
                    }
                    if (maxValue != null) {
                        max = Long.valueOf(maxValue);
                    }
                    return new RangeValidation(propertyName, min, max);
                }
            }
            return null;
        }
        return null;
    }

    private static String getParameterValue(ModelValidationParameter[] parameters, String param) {
        for (ModelValidationParameter modelValidationParameter : parameters) {
            if (!param.equals(modelValidationParameter.name())) continue;
            return modelValidationParameter.value();
        }
        return null;
    }
}

