/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.extclassgenerator;

import ch.rasc.extclassgenerator.ApiObject;
import ch.rasc.extclassgenerator.ModelBean;
import ch.rasc.extclassgenerator.OutputConfig;
import ch.rasc.extclassgenerator.OutputFormat;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class ProxyObject {
    private final String type = "direct";
    private String idParam;
    private Object pageParam = null;
    private Object startParam = null;
    private Object limitParam = null;
    private String directFn;
    private ApiObject api;
    private Map<String, Object> reader;
    private Map<String, Object> writer;

    protected ProxyObject(ModelBean model, OutputConfig config) {
        String rootPropertyName;
        if (StringUtils.hasText((String)model.getIdProperty()) && !model.getIdProperty().equals("id")) {
            this.idParam = model.getIdProperty();
        }
        if (model.isDisablePagingParameters()) {
            Object value = config.getOutputFormat() == OutputFormat.EXTJS4 ? "undefined" : (config.getOutputFormat() == OutputFormat.EXTJS5 ? "" : Boolean.FALSE);
            this.pageParam = value;
            this.startParam = value;
            this.limitParam = value;
        }
        LinkedHashMap<String, Object> readerConfigObject = new LinkedHashMap<String, Object>();
        if (StringUtils.hasText((String)model.getReader()) && !"json".equals(model.getReader())) {
            readerConfigObject.put("type", model.getReader());
        }
        String string = rootPropertyName = config.getOutputFormat() == OutputFormat.EXTJS4 ? "root" : "rootProperty";
        if (StringUtils.hasText((String)model.getRootProperty())) {
            readerConfigObject.put(rootPropertyName, model.getRootProperty());
        } else if (model.isPaging()) {
            readerConfigObject.put(rootPropertyName, "records");
        }
        if (StringUtils.hasText((String)model.getMessageProperty())) {
            readerConfigObject.put("messageProperty", model.getMessageProperty());
        }
        if (StringUtils.hasText((String)model.getTotalProperty())) {
            readerConfigObject.put("totalProperty", model.getTotalProperty());
        }
        if (StringUtils.hasText((String)model.getSuccessProperty())) {
            readerConfigObject.put("successProperty", model.getSuccessProperty());
        }
        if (!readerConfigObject.isEmpty()) {
            this.reader = readerConfigObject;
        }
        LinkedHashMap<String, Object> writerConfigObject = new LinkedHashMap<String, Object>();
        if (StringUtils.hasText((String)model.getWriter()) && !"json".equals(model.getWriter())) {
            writerConfigObject.put("type", model.getWriter());
        }
        if (model.getWriteAllFields() != null && (config.getOutputFormat() == OutputFormat.EXTJS5 && model.getWriteAllFields().booleanValue() || !model.getWriteAllFields().booleanValue() && (config.getOutputFormat() == OutputFormat.EXTJS4 || config.getOutputFormat() == OutputFormat.TOUCH2))) {
            writerConfigObject.put("writeAllFields", model.getWriteAllFields());
        }
        if (config.getOutputFormat() == OutputFormat.EXTJS5 && model.isClientIdPropertyAddToWriter() && StringUtils.hasText((String)model.getClientIdProperty())) {
            writerConfigObject.put("clientIdProperty", model.getClientIdProperty());
        }
        if (!writerConfigObject.isEmpty()) {
            this.writer = writerConfigObject;
        }
        boolean hasApiMethods = false;
        ApiObject apiObject = new ApiObject();
        if (StringUtils.hasText((String)model.getCreateMethod())) {
            hasApiMethods = true;
            apiObject.create = model.getCreateMethod();
        }
        if (StringUtils.hasText((String)model.getUpdateMethod())) {
            hasApiMethods = true;
            apiObject.update = model.getUpdateMethod();
        }
        if (StringUtils.hasText((String)model.getDestroyMethod())) {
            hasApiMethods = true;
            apiObject.destroy = model.getDestroyMethod();
        }
        if (StringUtils.hasText((String)model.getReadMethod())) {
            if (hasApiMethods) {
                apiObject.read = model.getReadMethod();
            } else {
                this.directFn = model.getReadMethod();
            }
        }
        if (hasApiMethods) {
            this.api = apiObject;
        }
    }

    public boolean hasContent() {
        return this.api != null || this.directFn != null || this.reader != null || this.writer != null && (this.writer.size() != 1 || !this.writer.containsKey("writeAllFields")) || this.idParam != null;
    }
}

