/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.extclassgenerator;

import ch.rasc.extclassgenerator.ApiObject;
import ch.rasc.extclassgenerator.ApiObjectMixin;
import ch.rasc.extclassgenerator.IncludeValidation;
import ch.rasc.extclassgenerator.JsCacheKey;
import ch.rasc.extclassgenerator.JsonViews;
import ch.rasc.extclassgenerator.LineEnding;
import ch.rasc.extclassgenerator.Model;
import ch.rasc.extclassgenerator.ModelAssociation;
import ch.rasc.extclassgenerator.ModelAssociations;
import ch.rasc.extclassgenerator.ModelBean;
import ch.rasc.extclassgenerator.ModelCacheKey;
import ch.rasc.extclassgenerator.ModelClientId;
import ch.rasc.extclassgenerator.ModelField;
import ch.rasc.extclassgenerator.ModelFieldBean;
import ch.rasc.extclassgenerator.ModelFields;
import ch.rasc.extclassgenerator.ModelId;
import ch.rasc.extclassgenerator.ModelType;
import ch.rasc.extclassgenerator.ModelValidation;
import ch.rasc.extclassgenerator.ModelValidations;
import ch.rasc.extclassgenerator.ModelVersion;
import ch.rasc.extclassgenerator.OutputConfig;
import ch.rasc.extclassgenerator.OutputFormat;
import ch.rasc.extclassgenerator.ProxyObject;
import ch.rasc.extclassgenerator.ProxyObjectWithApiQuotesMixin;
import ch.rasc.extclassgenerator.ProxyObjectWithoutApiQuotesExtJs5Mixin;
import ch.rasc.extclassgenerator.ProxyObjectWithoutApiQuotesMixin;
import ch.rasc.extclassgenerator.ReferenceBean;
import ch.rasc.extclassgenerator.association.AbstractAssociation;
import ch.rasc.extclassgenerator.validation.AbstractValidation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.ref.SoftReference;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.BeanUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;
import org.springframework.util.DigestUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public abstract class ModelGenerator {
    public static final Charset UTF8_CHARSET = Charset.forName("UTF-8");
    private static final Map<JsCacheKey, SoftReference<String>> jsCache = new ConcurrentHashMap<JsCacheKey, SoftReference<String>>();
    private static final Map<ModelCacheKey, SoftReference<ModelBean>> modelCache = new ConcurrentHashMap<ModelCacheKey, SoftReference<ModelBean>>();

    public static void writeModel(HttpServletRequest request, HttpServletResponse response, Class<?> clazz, OutputFormat format) throws IOException {
        ModelGenerator.writeModel(request, response, clazz, format, IncludeValidation.NONE, false);
    }

    public static void writeModel(HttpServletRequest request, HttpServletResponse response, Class<?> clazz, OutputFormat format, boolean debug) throws IOException {
        ModelGenerator.writeModel(request, response, clazz, format, IncludeValidation.NONE, debug);
    }

    public static void writeModel(HttpServletRequest request, HttpServletResponse response, Class<?> clazz, OutputFormat format, IncludeValidation includeValidation, boolean debug) throws IOException {
        OutputConfig outputConfig = new OutputConfig();
        outputConfig.setIncludeValidation(includeValidation);
        outputConfig.setOutputFormat(format);
        outputConfig.setDebug(debug);
        ModelBean model = ModelGenerator.createModel(clazz, outputConfig);
        ModelGenerator.writeModel(request, response, model, outputConfig);
    }

    public static void writeModel(HttpServletRequest request, HttpServletResponse response, Class<?> clazz, OutputConfig outputConfig) throws IOException {
        ModelBean model = ModelGenerator.createModel(clazz, outputConfig);
        ModelGenerator.writeModel(request, response, model, outputConfig);
    }

    public static void writeModel(HttpServletRequest request, HttpServletResponse response, ModelBean model, OutputFormat format) throws IOException {
        ModelGenerator.writeModel(request, response, model, format, false);
    }

    public static void writeModel(HttpServletRequest request, HttpServletResponse response, ModelBean model, OutputFormat format, boolean debug) throws IOException {
        OutputConfig outputConfig = new OutputConfig();
        outputConfig.setDebug(debug);
        outputConfig.setOutputFormat(format);
        ModelGenerator.writeModel(request, response, model, outputConfig);
    }

    public static ModelBean createModel(Class<?> clazz) {
        return ModelGenerator.createModel(clazz, IncludeValidation.NONE);
    }

    public static ModelBean createModel(Class<?> clazz, IncludeValidation includeValidation) {
        OutputConfig outputConfig = new OutputConfig();
        outputConfig.setIncludeValidation(includeValidation);
        return ModelGenerator.createModel(clazz, outputConfig);
    }

    public static String generateJavascript(Class<?> clazz, OutputFormat format, boolean debug) {
        OutputConfig outputConfig = new OutputConfig();
        outputConfig.setIncludeValidation(IncludeValidation.NONE);
        outputConfig.setOutputFormat(format);
        outputConfig.setDebug(debug);
        ModelBean model = ModelGenerator.createModel(clazz, outputConfig);
        return ModelGenerator.generateJavascript(model, outputConfig);
    }

    public static String generateJavascript(Class<?> clazz, OutputConfig outputConfig) {
        ModelBean model = ModelGenerator.createModel(clazz, outputConfig);
        return ModelGenerator.generateJavascript(model, outputConfig);
    }

    public static String generateJavascript(Class<?> clazz, OutputFormat format, IncludeValidation includeValidation, boolean debug) {
        OutputConfig outputConfig = new OutputConfig();
        outputConfig.setIncludeValidation(includeValidation);
        outputConfig.setOutputFormat(format);
        outputConfig.setDebug(debug);
        ModelBean model = ModelGenerator.createModel(clazz, outputConfig);
        return ModelGenerator.generateJavascript(model, outputConfig);
    }

    public static String generateJavascript(ModelBean model, OutputFormat format, boolean debug) {
        OutputConfig outputConfig = new OutputConfig();
        outputConfig.setOutputFormat(format);
        outputConfig.setDebug(debug);
        return ModelGenerator.generateJavascript(model, outputConfig);
    }

    public static void writeModel(HttpServletRequest request, HttpServletResponse response, ModelBean model, OutputConfig outputConfig) throws IOException {
        byte[] data = ModelGenerator.generateJavascript(model, outputConfig).getBytes(UTF8_CHARSET);
        String ifNoneMatch = request.getHeader("If-None-Match");
        String etag = "\"0" + DigestUtils.md5DigestAsHex((byte[])data) + "\"";
        if (etag.equals(ifNoneMatch)) {
            response.setStatus(304);
            return;
        }
        response.setContentType("application/javascript");
        response.setCharacterEncoding(UTF8_CHARSET.name());
        response.setContentLength(data.length);
        response.setHeader("ETag", etag);
        ServletOutputStream out = response.getOutputStream();
        out.write(data);
        out.flush();
    }

    public static ModelBean createModel(Class<?> clazz, final OutputConfig outputConfig) {
        BeanInfo bi;
        Assert.notNull(clazz, (String)"clazz must not be null");
        Assert.notNull((Object)((Object)outputConfig.getIncludeValidation()), (String)"includeValidation must not be null");
        ModelCacheKey key = new ModelCacheKey(clazz.getName(), outputConfig);
        SoftReference<ModelBean> modelReference = modelCache.get(key);
        if (modelReference != null && modelReference.get() != null) {
            return modelReference.get();
        }
        Model modelAnnotation = clazz.getAnnotation(Model.class);
        final ModelBean model = new ModelBean();
        if (modelAnnotation != null && StringUtils.hasText((String)modelAnnotation.value())) {
            model.setName(modelAnnotation.value());
        } else {
            model.setName(clazz.getName());
        }
        if (modelAnnotation != null) {
            model.setAutodetectTypes(modelAnnotation.autodetectTypes());
        }
        if (modelAnnotation != null) {
            model.setExtend(modelAnnotation.extend());
            model.setIdProperty(modelAnnotation.idProperty());
            model.setVersionProperty(ModelGenerator.trimToNull(modelAnnotation.versionProperty()));
            model.setPaging(modelAnnotation.paging());
            model.setDisablePagingParameters(modelAnnotation.disablePagingParameters());
            model.setCreateMethod(ModelGenerator.trimToNull(modelAnnotation.createMethod()));
            model.setReadMethod(ModelGenerator.trimToNull(modelAnnotation.readMethod()));
            model.setUpdateMethod(ModelGenerator.trimToNull(modelAnnotation.updateMethod()));
            model.setDestroyMethod(ModelGenerator.trimToNull(modelAnnotation.destroyMethod()));
            model.setMessageProperty(ModelGenerator.trimToNull(modelAnnotation.messageProperty()));
            model.setWriter(ModelGenerator.trimToNull(modelAnnotation.writer()));
            model.setReader(ModelGenerator.trimToNull(modelAnnotation.reader()));
            model.setSuccessProperty(ModelGenerator.trimToNull(modelAnnotation.successProperty()));
            model.setTotalProperty(ModelGenerator.trimToNull(modelAnnotation.totalProperty()));
            model.setRootProperty(ModelGenerator.trimToNull(modelAnnotation.rootProperty()));
            model.setWriteAllFields(modelAnnotation.writeAllFields());
            model.setIdentifier(ModelGenerator.trimToNull(modelAnnotation.identifier()));
            String clientIdProperty = ModelGenerator.trimToNull(modelAnnotation.clientIdProperty());
            if (StringUtils.hasText((String)clientIdProperty)) {
                model.setClientIdProperty(clientIdProperty);
                model.setClientIdPropertyAddToWriter(true);
            } else {
                model.setClientIdProperty(null);
                model.setClientIdPropertyAddToWriter(false);
            }
        }
        final HashSet<String> hasReadMethod = new HashSet<String>();
        try {
            bi = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
            if (pd.getReadMethod() == null || pd.getReadMethod().getAnnotation(JsonIgnore.class) != null) continue;
            hasReadMethod.add(pd.getName());
        }
        if (clazz.isInterface()) {
            final ArrayList methods = new ArrayList();
            ReflectionUtils.doWithMethods(clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                    methods.add(method);
                }
            });
            Collections.sort(methods, new Comparator<Method>(){

                @Override
                public int compare(Method o1, Method o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (Method method : methods) {
                ModelGenerator.createModelBean(model, method, outputConfig);
            }
        } else {
            final HashSet fields = new HashSet();
            Set modelFieldsOnType = AnnotationUtils.getRepeatableAnnotation(clazz, ModelFields.class, ModelField.class);
            for (Object modelField : modelFieldsOnType) {
                if (!StringUtils.hasText((String)modelField.value())) continue;
                ModelFieldBean modelFieldBean = StringUtils.hasText((String)modelField.customType()) ? new ModelFieldBean(modelField.value(), modelField.customType()) : new ModelFieldBean(modelField.value(), modelField.type());
                ModelGenerator.updateModelFieldBean(modelFieldBean, (ModelField)modelField);
                model.addField(modelFieldBean);
            }
            Set modelAssociationsOnType = AnnotationUtils.getRepeatableAnnotation(clazz, ModelAssociations.class, ModelAssociation.class);
            for (ModelAssociation modelAssociationAnnotation : modelAssociationsOnType) {
                AbstractAssociation modelAssociation = AbstractAssociation.createAssociation(modelAssociationAnnotation);
                if (modelAssociation == null) continue;
                model.addAssociation(modelAssociation);
            }
            Set modelValidationsOnType = AnnotationUtils.getRepeatableAnnotation(clazz, ModelValidations.class, ModelValidation.class);
            for (ModelValidation modelValidationAnnotation : modelValidationsOnType) {
                AbstractValidation modelValidation = AbstractValidation.createValidation(modelValidationAnnotation.propertyName(), modelValidationAnnotation, outputConfig.getIncludeValidation());
                if (modelValidation == null) continue;
                model.addValidation(modelValidation);
            }
            ReflectionUtils.doWithFields(clazz, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                    if (!fields.contains(field.getName()) && (field.getAnnotation(ModelField.class) != null || field.getAnnotation(ModelAssociation.class) != null || (Modifier.isPublic(field.getModifiers()) || hasReadMethod.contains(field.getName())) && field.getAnnotation(JsonIgnore.class) == null)) {
                        fields.add(field.getName());
                        ModelGenerator.createModelBean(model, field, outputConfig);
                    }
                }
            });
        }
        modelCache.put(key, new SoftReference<ModelBean>(model));
        return model;
    }

    private static void createModelBean(ModelBean model, AccessibleObject accessibleObject, OutputConfig outputConfig) {
        block21: {
            PropertyDescriptor pd;
            Annotation[] fieldAnnotations;
            ModelFieldBean modelFieldBean;
            Class<?> declaringClass;
            String name;
            block22: {
                ModelAssociation modelAssociationAnnotation;
                ModelVersion modelVersion;
                ModelClientId modelClientId;
                Class<?> javaType = null;
                name = null;
                declaringClass = null;
                if (accessibleObject instanceof Field) {
                    Field field = (Field)accessibleObject;
                    javaType = field.getType();
                    name = field.getName();
                    declaringClass = field.getDeclaringClass();
                } else if (accessibleObject instanceof Method) {
                    Method method = (Method)accessibleObject;
                    javaType = method.getReturnType();
                    if (javaType.equals(Void.TYPE)) {
                        return;
                    }
                    name = method.getName().startsWith("get") ? StringUtils.uncapitalize((String)method.getName().substring(3)) : (method.getName().startsWith("is") ? StringUtils.uncapitalize((String)method.getName().substring(2)) : method.getName());
                    declaringClass = method.getDeclaringClass();
                }
                ModelType modelType = null;
                if (model.isAutodetectTypes()) {
                    for (ModelType mt : ModelType.values()) {
                        if (!mt.supports(javaType)) continue;
                        modelType = mt;
                        break;
                    }
                } else {
                    modelType = ModelType.AUTO;
                }
                modelFieldBean = null;
                ModelField modelFieldAnnotation = accessibleObject.getAnnotation(ModelField.class);
                if (modelFieldAnnotation != null) {
                    if (StringUtils.hasText((String)modelFieldAnnotation.value())) {
                        name = modelFieldAnnotation.value();
                    }
                    if (StringUtils.hasText((String)modelFieldAnnotation.customType())) {
                        modelFieldBean = new ModelFieldBean(name, modelFieldAnnotation.customType());
                    } else {
                        ModelType type = null;
                        type = modelFieldAnnotation.type() != ModelType.NOT_SPECIFIED ? modelFieldAnnotation.type() : modelType;
                        modelFieldBean = new ModelFieldBean(name, type);
                    }
                    ModelGenerator.updateModelFieldBean(modelFieldBean, modelFieldAnnotation);
                    model.addField(modelFieldBean);
                } else if (modelType != null) {
                    modelFieldBean = new ModelFieldBean(name, modelType);
                    model.addField(modelFieldBean);
                }
                ModelId modelIdAnnotation = accessibleObject.getAnnotation(ModelId.class);
                if (modelIdAnnotation != null) {
                    model.setIdProperty(name);
                }
                if ((modelClientId = accessibleObject.getAnnotation(ModelClientId.class)) != null) {
                    model.setClientIdProperty(name);
                    model.setClientIdPropertyAddToWriter(modelClientId.configureWriter());
                }
                if ((modelVersion = accessibleObject.getAnnotation(ModelVersion.class)) != null) {
                    model.setVersionProperty(name);
                }
                if ((modelAssociationAnnotation = accessibleObject.getAnnotation(ModelAssociation.class)) != null) {
                    model.addAssociation(AbstractAssociation.createAssociation(modelAssociationAnnotation, model, javaType, declaringClass, name));
                }
                if (modelFieldBean == null || outputConfig.getIncludeValidation() == IncludeValidation.NONE) break block21;
                Set modelValidationAnnotations = AnnotationUtils.getRepeatableAnnotation((AnnotatedElement)accessibleObject, ModelValidations.class, ModelValidation.class);
                if (modelValidationAnnotations.isEmpty()) break block22;
                for (ModelValidation modelValidationAnnotation : modelValidationAnnotations) {
                    AbstractValidation modelValidation = AbstractValidation.createValidation(name, modelValidationAnnotation, outputConfig.getIncludeValidation());
                    if (modelValidation == null) continue;
                    model.addValidation(modelValidation);
                }
                break block21;
            }
            for (Annotation fieldAnnotation : fieldAnnotations = accessibleObject.getAnnotations()) {
                AbstractValidation.addValidationToModel(model, modelFieldBean, fieldAnnotation, outputConfig.getIncludeValidation());
            }
            if (!(accessibleObject instanceof Field) || (pd = BeanUtils.getPropertyDescriptor(declaringClass, (String)name)) == null || pd.getReadMethod() == null) break block21;
            for (Annotation readMethodAnnotation : pd.getReadMethod().getAnnotations()) {
                AbstractValidation.addValidationToModel(model, modelFieldBean, readMethodAnnotation, outputConfig.getIncludeValidation());
            }
        }
    }

    private static void updateModelFieldBean(ModelFieldBean modelFieldBean, ModelField modelFieldAnnotation) {
        String defaultValue;
        ModelType type = modelFieldBean.getModelType();
        if (StringUtils.hasText((String)modelFieldAnnotation.dateFormat()) && type == ModelType.DATE) {
            modelFieldBean.setDateFormat(modelFieldAnnotation.dateFormat());
        }
        if (StringUtils.hasText((String)(defaultValue = modelFieldAnnotation.defaultValue()))) {
            if ("undefined".equals(defaultValue)) {
                modelFieldBean.setDefaultValue("undefined");
            } else if (type == ModelType.BOOLEAN) {
                modelFieldBean.setDefaultValue(Boolean.valueOf(defaultValue));
            } else if (type == ModelType.INTEGER) {
                modelFieldBean.setDefaultValue(Long.valueOf(defaultValue));
            } else if (type == ModelType.FLOAT || type == ModelType.NUMBER) {
                modelFieldBean.setDefaultValue(Double.valueOf(defaultValue));
            } else {
                modelFieldBean.setDefaultValue("\"" + defaultValue + "\"");
            }
        }
        if ((modelFieldAnnotation.useNull() || modelFieldAnnotation.allowNull()) && (type == ModelType.INTEGER || type == ModelType.FLOAT || type == ModelType.NUMBER || type == ModelType.STRING || type == ModelType.BOOLEAN)) {
            modelFieldBean.setAllowNull(Boolean.TRUE);
        }
        if (!modelFieldAnnotation.allowBlank()) {
            modelFieldBean.setAllowBlank(Boolean.FALSE);
        }
        if (modelFieldAnnotation.unique()) {
            modelFieldBean.setUnique(Boolean.TRUE);
        }
        modelFieldBean.setMapping(ModelGenerator.trimToNull(modelFieldAnnotation.mapping()));
        if (!modelFieldAnnotation.persist()) {
            modelFieldBean.setPersist(Boolean.FALSE);
        }
        if (modelFieldAnnotation.critical()) {
            modelFieldBean.setCritical(Boolean.TRUE);
        }
        modelFieldBean.setConvert(ModelGenerator.trimToNull(modelFieldAnnotation.convert()));
        modelFieldBean.setCalculate(ModelGenerator.trimToNull(modelFieldAnnotation.calculate()));
        List<String> depends = Arrays.asList(modelFieldAnnotation.depends());
        if (!depends.isEmpty()) {
            modelFieldBean.setDepends(depends);
        } else {
            modelFieldBean.setDepends(null);
        }
        ReferenceBean reference = new ReferenceBean(modelFieldAnnotation.reference());
        if (reference.hasAnyProperties()) {
            if (reference.typeOnly()) {
                modelFieldBean.setReference(reference.getType());
            } else {
                modelFieldBean.setReference(reference);
            }
        }
    }

    public static String generateJavascript(ModelBean model, OutputConfig outputConfig) {
        String configObjectString;
        JsCacheKey key;
        SoftReference<String> jsReference;
        if (!outputConfig.isDebug() && (jsReference = jsCache.get(key = new JsCacheKey(model, outputConfig))) != null && jsReference.get() != null) {
            return jsReference.get();
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, false);
        if (!outputConfig.isSurroundApiWithQuotes()) {
            if (outputConfig.getOutputFormat() == OutputFormat.EXTJS5) {
                mapper.addMixInAnnotations(ProxyObject.class, ProxyObjectWithoutApiQuotesExtJs5Mixin.class);
            } else {
                mapper.addMixInAnnotations(ProxyObject.class, ProxyObjectWithoutApiQuotesMixin.class);
            }
            mapper.addMixInAnnotations(ApiObject.class, ApiObjectMixin.class);
        } else if (outputConfig.getOutputFormat() != OutputFormat.EXTJS5) {
            mapper.addMixInAnnotations(ProxyObject.class, ProxyObjectWithApiQuotesMixin.class);
        }
        LinkedHashMap<String, Object> modelObject = new LinkedHashMap<String, Object>();
        modelObject.put("extend", model.getExtend());
        if (!model.getAssociations().isEmpty()) {
            HashSet<String> usesClasses = new HashSet<String>();
            for (AbstractAssociation association : model.getAssociations()) {
                usesClasses.add(association.getModel());
            }
            usesClasses.remove(model.getName());
            if (!usesClasses.isEmpty()) {
                modelObject.put("uses", usesClasses);
            }
        }
        LinkedHashMap<String, Object> configObject = new LinkedHashMap<String, Object>();
        ProxyObject proxyObject = new ProxyObject(model, outputConfig);
        Map<String, ModelFieldBean> fields = model.getFields();
        Set<Object> requires = new HashSet<String>();
        if (!model.getValidations().isEmpty() && outputConfig.getOutputFormat() == OutputFormat.EXTJS5) {
            requires = ModelGenerator.addValidatorsToField(fields, model.getValidations());
        }
        if (proxyObject.hasContent() && outputConfig.getOutputFormat() == OutputFormat.EXTJS5) {
            requires.add("Ext.data.proxy.Direct");
        }
        if (StringUtils.hasText((String)model.getIdentifier()) && outputConfig.getOutputFormat() == OutputFormat.EXTJS5) {
            if ("sequential".equals(model.getIdentifier())) {
                requires.add("Ext.data.identifier.Sequential");
            } else if ("uuid".equals(model.getIdentifier())) {
                requires.add("Ext.data.identifier.Uuid");
            } else if ("negative".equals(model.getIdentifier())) {
                requires.add("Ext.data.identifier.Negative");
            }
        }
        if (requires != null && !requires.isEmpty()) {
            configObject.put("requires", requires);
        }
        if (StringUtils.hasText((String)model.getIdentifier())) {
            if (outputConfig.getOutputFormat() == OutputFormat.EXTJS5 || outputConfig.getOutputFormat() == OutputFormat.TOUCH2) {
                configObject.put("identifier", model.getIdentifier());
            } else {
                configObject.put("idgen", model.getIdentifier());
            }
        }
        if (StringUtils.hasText((String)model.getIdProperty()) && !model.getIdProperty().equals("id")) {
            configObject.put("idProperty", model.getIdProperty());
        }
        if (outputConfig.getOutputFormat() == OutputFormat.EXTJS5 && StringUtils.hasText((String)model.getVersionProperty())) {
            configObject.put("versionProperty", model.getVersionProperty());
        }
        if (StringUtils.hasText((String)model.getClientIdProperty())) {
            if (outputConfig.getOutputFormat() == OutputFormat.EXTJS5 || outputConfig.getOutputFormat() == OutputFormat.EXTJS4) {
                configObject.put("clientIdProperty", model.getClientIdProperty());
            } else if (outputConfig.getOutputFormat() == OutputFormat.TOUCH2 && !"clientId".equals(model.getClientIdProperty())) {
                configObject.put("clientIdProperty", model.getClientIdProperty());
            }
        }
        for (ModelFieldBean modelFieldBean : fields.values()) {
            modelFieldBean.updateTypes(outputConfig);
        }
        ArrayList<Object> fieldConfigObjects = new ArrayList<Object>();
        for (ModelFieldBean field : fields.values()) {
            if (field.hasOnlyName(outputConfig)) {
                fieldConfigObjects.add(field.getName());
                continue;
            }
            fieldConfigObjects.add(field);
        }
        configObject.put("fields", fieldConfigObjects);
        if (!model.getAssociations().isEmpty()) {
            configObject.put("associations", model.getAssociations());
        }
        if (!model.getValidations().isEmpty() && outputConfig.getOutputFormat() != OutputFormat.EXTJS5) {
            configObject.put("validations", model.getValidations());
        }
        if (proxyObject.hasContent()) {
            configObject.put("proxy", proxyObject);
        }
        if (outputConfig.getOutputFormat() == OutputFormat.EXTJS4 || outputConfig.getOutputFormat() == OutputFormat.EXTJS5) {
            modelObject.putAll(configObject);
        } else {
            modelObject.put("config", configObject);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Ext.define(\"").append(model.getName()).append("\",");
        if (outputConfig.isDebug()) {
            stringBuilder.append("\r\n");
        }
        Class jsonView = JsonViews.ExtJS4.class;
        if (outputConfig.getOutputFormat() == OutputFormat.TOUCH2) {
            jsonView = JsonViews.Touch2.class;
        } else if (outputConfig.getOutputFormat() == OutputFormat.EXTJS5) {
            jsonView = JsonViews.ExtJS5.class;
        }
        try {
            configObjectString = outputConfig.isDebug() ? mapper.writerWithDefaultPrettyPrinter().withView(jsonView).writeValueAsString(modelObject) : mapper.writerWithView(jsonView).writeValueAsString(modelObject);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        stringBuilder.append(configObjectString);
        stringBuilder.append(");");
        String result = stringBuilder.toString();
        if (outputConfig.isUseSingleQuotes()) {
            result = result.replace('\"', '\'');
        }
        if (outputConfig.getLineEnding() == LineEnding.CRLF) {
            result = result.replaceAll("\r?\n", "\r\n");
        } else if (outputConfig.getLineEnding() == LineEnding.LF) {
            result = result.replaceAll("\r?\n", "\n");
        } else if (outputConfig.getLineEnding() == LineEnding.SYSTEM) {
            String lineSeparator = System.getProperty("line.separator");
            result = result.replaceAll("\r?\n", lineSeparator);
        }
        if (!outputConfig.isDebug()) {
            jsCache.put(new JsCacheKey(model, outputConfig), new SoftReference<String>(result));
        }
        return result;
    }

    private static Set<String> addValidatorsToField(Map<String, ModelFieldBean> fields, List<AbstractValidation> validations) {
        TreeSet<String> requires = new TreeSet<String>();
        for (ModelFieldBean field : fields.values()) {
            for (AbstractValidation validation : validations) {
                String validatorClass;
                if (!field.getName().equals(validation.getField())) continue;
                List<AbstractValidation> validators = field.getValidators();
                if (validators == null) {
                    validators = new ArrayList<AbstractValidation>();
                    field.setValidators(validators);
                }
                if ((validatorClass = ModelGenerator.getValidatorClass(validation.getType())) != null) {
                    requires.add(validatorClass);
                }
                boolean alreadyExists = false;
                for (AbstractValidation validator : validators) {
                    if (!validation.getType().equals(validator.getType())) continue;
                    alreadyExists = true;
                    break;
                }
                if (alreadyExists) continue;
                validators.add(validation);
            }
        }
        return requires;
    }

    private static String getValidatorClass(String type) {
        if (type.equals("email")) {
            return "Ext.data.validator.Email";
        }
        if (type.equals("exclusion")) {
            return "Ext.data.validator.Exclusion";
        }
        if (type.equals("format")) {
            return "Ext.data.validator.Format";
        }
        if (type.equals("inclusion")) {
            return "Ext.data.validator.Inclusion";
        }
        if (type.equals("length")) {
            return "Ext.data.validator.Length";
        }
        if (type.equals("presence")) {
            return "Ext.data.validator.Presence";
        }
        if (type.equals("range")) {
            return "Ext.data.validator.Range";
        }
        return null;
    }

    static String trimToNull(String str) {
        String trimmedStr = StringUtils.trimWhitespace((String)str);
        if (StringUtils.hasLength((String)trimmedStr)) {
            return trimmedStr;
        }
        return null;
    }

    public static void clearCaches() {
        modelCache.clear();
        jsCache.clear();
    }
}

