/**
 * Copyright 2013-2014 Ralph Schaer <ralphschaer@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ch.rasc.extclassgenerator.validation;

import com.fasterxml.jackson.annotation.JsonRawValue;

public class InclusionValidation extends AbstractValidation {

	@JsonRawValue
	private final String list;

	public InclusionValidation(String field, String list) {
		super("inclusion", field);

		this.list = list;
	}

	public String getList() {
		return list;
	}

}
