/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.extclassgenerator;

import ch.rasc.extclassgenerator.ModelBean;
import ch.rasc.extclassgenerator.OutputConfig;
import ch.rasc.extclassgenerator.OutputFormat;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonRawValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
class ProxyObjectWithQuotes {
    private final String type = "direct";
    private String idParam;
    @JsonRawValue
    private Object pageParam = null;
    @JsonRawValue
    private Object startParam = null;
    @JsonRawValue
    private Object limitParam = null;
    private String directFn;
    private ApiObject api;
    private Map<String, String> reader;
    private String writer;

    public ProxyObjectWithQuotes(ModelBean model, OutputConfig config) {
        if (StringUtils.hasText((String)model.getIdProperty()) && !model.getIdProperty().equals("id")) {
            this.idParam = model.getIdProperty();
        }
        if (model.isDisablePagingParameters()) {
            Object value;
            this.pageParam = value = config.getOutputFormat() == OutputFormat.EXTJS4 ? "undefined" : Boolean.valueOf(false);
            this.startParam = value;
            this.limitParam = value;
        }
        boolean hasApiMethods = false;
        ApiObject apiObject = new ApiObject();
        if (StringUtils.hasText((String)model.getCreateMethod())) {
            hasApiMethods = true;
            apiObject.create = model.getCreateMethod();
        }
        if (StringUtils.hasText((String)model.getUpdateMethod())) {
            hasApiMethods = true;
            apiObject.update = model.getUpdateMethod();
        }
        if (StringUtils.hasText((String)model.getDestroyMethod())) {
            hasApiMethods = true;
            apiObject.destroy = model.getDestroyMethod();
        }
        if (StringUtils.hasText((String)model.getReadMethod())) {
            if (hasApiMethods) {
                apiObject.read = model.getReadMethod();
            } else {
                this.directFn = model.getReadMethod();
            }
        }
        if (hasApiMethods) {
            this.api = apiObject;
        }
        if (model.isPaging()) {
            String rootPropertyName;
            String string = rootPropertyName = config.getOutputFormat() == OutputFormat.EXTJS4 ? "root" : "rootProperty";
            if (StringUtils.hasText((String)model.getMessageProperty())) {
                this.reader = new HashMap<String, String>();
                this.reader.put(rootPropertyName, "records");
                this.reader.put("messageProperty", model.getMessageProperty());
            } else {
                this.reader = Collections.singletonMap(rootPropertyName, "records");
            }
        } else if (StringUtils.hasText((String)model.getMessageProperty())) {
            this.reader = Collections.singletonMap("messageProperty", model.getMessageProperty());
        }
        if (StringUtils.hasText((String)model.getWriter())) {
            this.writer = model.getWriter();
        }
    }

    public boolean hasMethods() {
        return this.api != null || this.directFn != null;
    }

    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final class ApiObject {
        private String read;
        private String create;
        private String update;
        private String destroy;

        private ApiObject() {
        }
    }
}

