/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.extclassgenerator.association;

import ch.rasc.extclassgenerator.Model;
import ch.rasc.extclassgenerator.ModelAssociation;
import ch.rasc.extclassgenerator.ModelAssociationType;
import ch.rasc.extclassgenerator.ModelBean;
import ch.rasc.extclassgenerator.ModelGenerator;
import ch.rasc.extclassgenerator.association.BelongsToAssociation;
import ch.rasc.extclassgenerator.association.HasManyAssociation;
import ch.rasc.extclassgenerator.association.HasOneAssociation;
import com.fasterxml.jackson.annotation.JsonInclude;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public abstract class AbstractAssociation {
    private final String type;
    private final String model;
    private String associationKey;
    private String foreignKey;
    private String primaryKey;
    private String instanceName;

    public AbstractAssociation(String type, String model) {
        this.type = type;
        this.model = model;
    }

    public String getAssociationKey() {
        return this.associationKey;
    }

    public void setAssociationKey(String associationKey) {
        this.associationKey = associationKey;
    }

    public String getForeignKey() {
        return this.foreignKey;
    }

    public void setForeignKey(String foreignKey) {
        this.foreignKey = foreignKey;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(String primaryKey) {
        this.primaryKey = primaryKey;
    }

    public String getType() {
        return this.type;
    }

    public String getModel() {
        return this.model;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    protected static String getModelName(Class<?> model) {
        Model modelAnnotation = model.getAnnotation(Model.class);
        if (modelAnnotation != null && StringUtils.hasText((String)modelAnnotation.value())) {
            return modelAnnotation.value();
        }
        return model.getName();
    }

    public static AbstractAssociation createAssociation(ModelAssociation associationAnnotation, ModelBean model, Class<?> typeOfFieldOrReturnValue, Class<?> declaringClass, String name) {
        Model associationModelAnnotation;
        ModelAssociationType type = associationAnnotation.value();
        Class<?> associationClass = associationAnnotation.model();
        if (associationClass == Object.class) {
            associationClass = typeOfFieldOrReturnValue;
        }
        AbstractAssociation association = type == ModelAssociationType.HAS_MANY ? new HasManyAssociation(associationClass) : (type == ModelAssociationType.BELONGS_TO ? new BelongsToAssociation(associationClass) : new HasOneAssociation(associationClass));
        association.setAssociationKey(name);
        if (StringUtils.hasText((String)associationAnnotation.foreignKey())) {
            association.setForeignKey(associationAnnotation.foreignKey());
        } else if (type == ModelAssociationType.HAS_MANY) {
            association.setForeignKey(StringUtils.uncapitalize((String)declaringClass.getSimpleName()) + "_id");
        } else if (type == ModelAssociationType.BELONGS_TO || type == ModelAssociationType.HAS_ONE) {
            association.setForeignKey(name + "_id");
        }
        if (StringUtils.hasText((String)associationAnnotation.primaryKey())) {
            association.setPrimaryKey(associationAnnotation.primaryKey());
        } else if (type == ModelAssociationType.HAS_MANY && StringUtils.hasText((String)model.getIdProperty()) && !model.getIdProperty().equals("id")) {
            association.setPrimaryKey(model.getIdProperty());
        } else if ((type == ModelAssociationType.BELONGS_TO || type == ModelAssociationType.HAS_ONE) && (associationModelAnnotation = associationClass.getAnnotation(Model.class)) != null && StringUtils.hasText((String)associationModelAnnotation.idProperty()) && !associationModelAnnotation.idProperty().equals("id")) {
            association.setPrimaryKey(associationModelAnnotation.idProperty());
        }
        if (type == ModelAssociationType.HAS_MANY) {
            HasManyAssociation hasManyAssociation = (HasManyAssociation)association;
            if (StringUtils.hasText((String)associationAnnotation.setterName())) {
                LogFactory.getLog(ModelGenerator.class).warn((Object)AbstractAssociation.getWarningText(declaringClass, name, association.getType(), "setterName"));
            }
            if (StringUtils.hasText((String)associationAnnotation.getterName())) {
                LogFactory.getLog(ModelGenerator.class).warn((Object)AbstractAssociation.getWarningText(declaringClass, name, association.getType(), "getterName"));
            }
            if (associationAnnotation.autoLoad()) {
                hasManyAssociation.setAutoLoad(true);
            }
            if (StringUtils.hasText((String)associationAnnotation.name())) {
                hasManyAssociation.setName(associationAnnotation.name());
            } else {
                hasManyAssociation.setName(name);
            }
        } else if (type == ModelAssociationType.BELONGS_TO) {
            BelongsToAssociation belongsToAssociation = (BelongsToAssociation)association;
            if (StringUtils.hasText((String)associationAnnotation.setterName())) {
                belongsToAssociation.setSetterName(associationAnnotation.setterName());
            } else {
                belongsToAssociation.setSetterName("set" + StringUtils.capitalize((String)name));
            }
            if (StringUtils.hasText((String)associationAnnotation.getterName())) {
                belongsToAssociation.setGetterName(associationAnnotation.getterName());
            } else {
                belongsToAssociation.setGetterName("get" + StringUtils.capitalize((String)name));
            }
            if (associationAnnotation.autoLoad()) {
                LogFactory.getLog(ModelGenerator.class).warn((Object)AbstractAssociation.getWarningText(declaringClass, name, association.getType(), "autoLoad"));
            }
            if (StringUtils.hasText((String)associationAnnotation.name())) {
                LogFactory.getLog(ModelGenerator.class).warn((Object)AbstractAssociation.getWarningText(declaringClass, name, association.getType(), "name"));
            }
        } else {
            HasOneAssociation hasOneAssociation = (HasOneAssociation)association;
            if (StringUtils.hasText((String)associationAnnotation.setterName())) {
                hasOneAssociation.setSetterName(associationAnnotation.setterName());
            } else {
                hasOneAssociation.setSetterName("set" + StringUtils.capitalize((String)name));
            }
            if (StringUtils.hasText((String)associationAnnotation.getterName())) {
                hasOneAssociation.setGetterName(associationAnnotation.getterName());
            } else {
                hasOneAssociation.setGetterName("get" + StringUtils.capitalize((String)name));
            }
            if (associationAnnotation.autoLoad()) {
                LogFactory.getLog(ModelGenerator.class).warn((Object)AbstractAssociation.getWarningText(declaringClass, name, association.getType(), "autoLoad"));
            }
            if (StringUtils.hasText((String)associationAnnotation.name())) {
                LogFactory.getLog(ModelGenerator.class).warn((Object)AbstractAssociation.getWarningText(declaringClass, name, association.getType(), "name"));
            }
        }
        if (StringUtils.hasText((String)associationAnnotation.instanceName())) {
            association.setInstanceName(associationAnnotation.instanceName());
        }
        return association;
    }

    private static String getWarningText(Class<?> declaringClass, String name, String type, String propertyName) {
        String warning = "Field ";
        warning = warning + declaringClass.getName();
        warning = warning + ".";
        warning = warning + name;
        return warning + ": A '" + type + "' association does not support property '" + propertyName + "'. Property will be ignored.";
    }
}

