/*
 * Decompiled with CFR 0.152.
 */
package ch.rasc.extclassgenerator;

import ch.rasc.extclassgenerator.IncludeValidation;
import ch.rasc.extclassgenerator.Model;
import ch.rasc.extclassgenerator.ModelGenerator;
import ch.rasc.extclassgenerator.OutputConfig;
import ch.rasc.extclassgenerator.OutputFormat;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.springframework.util.StringUtils;

@SupportedAnnotationTypes(value={"ch.rasc.extclassgenerator.Model"})
@SupportedOptions(value={"outputFormat", "debug", "includeValidation"})
public class ModelAnnotationProcessor
extends AbstractProcessor {
    private static final boolean ALLOW_OTHER_PROCESSORS_TO_CLAIM_ANNOTATIONS = false;
    private static final String OPTION_OUTPUTFORMAT = "outputFormat";
    private static final String OPTION_DEBUG = "debug";
    private static final String OPTION_INCLUDEVALIDATION = "includeValidation";
    private static final String OPTION_CREATEBASEANDSUBCLASS = "createBaseAndSubclass";
    private static final String OPTION_USESINGLEQUOTES = "useSingleQuotes";
    private static final String OPTION_SURROUNDAPIWITHQUOTES = "surroundApiWithQuotes";
    private static final ObjectMapper mapper = new ObjectMapper();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Running " + this.getClass().getSimpleName());
        if (roundEnv.processingOver() || annotations.size() == 0) {
            return false;
        }
        if (roundEnv.getRootElements() == null || roundEnv.getRootElements().isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "No sources to process");
            return false;
        }
        OutputConfig outputConfig = new OutputConfig();
        outputConfig.setDebug(!"false".equals(this.processingEnv.getOptions().get(OPTION_DEBUG)));
        boolean createBaseAndSubclass = "true".equals(this.processingEnv.getOptions().get(OPTION_CREATEBASEANDSUBCLASS));
        String outputFormatString = this.processingEnv.getOptions().get(OPTION_OUTPUTFORMAT);
        outputConfig.setOutputFormat(OutputFormat.EXTJS4);
        if (StringUtils.hasText((String)outputFormatString) && OutputFormat.TOUCH2.name().equalsIgnoreCase(outputFormatString)) {
            outputConfig.setOutputFormat(OutputFormat.TOUCH2);
        }
        String includeValidationString = this.processingEnv.getOptions().get(OPTION_INCLUDEVALIDATION);
        outputConfig.setIncludeValidation(IncludeValidation.NONE);
        if (StringUtils.hasText((String)includeValidationString)) {
            if (IncludeValidation.ALL.name().equalsIgnoreCase(includeValidationString)) {
                outputConfig.setIncludeValidation(IncludeValidation.ALL);
            } else if (IncludeValidation.BUILTIN.name().equalsIgnoreCase(includeValidationString)) {
                outputConfig.setIncludeValidation(IncludeValidation.BUILTIN);
            }
        }
        outputConfig.setUseSingleQuotes("true".equals(this.processingEnv.getOptions().get(OPTION_USESINGLEQUOTES)));
        outputConfig.setSurroundApiWithQuotes("true".equals(this.processingEnv.getOptions().get(OPTION_SURROUNDAPIWITHQUOTES)));
        for (TypeElement typeElement : annotations) {
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(typeElement);
            for (Element element : elements) {
                try {
                    OutputStream os;
                    FileObject fo;
                    String fileName;
                    TypeElement typeElement2 = (TypeElement)element;
                    String qualifiedName = typeElement2.getQualifiedName().toString();
                    Class<?> modelClass = Class.forName(qualifiedName);
                    String code = ModelGenerator.generateJavascript(modelClass, outputConfig);
                    Model modelAnnotation = element.getAnnotation(Model.class);
                    String modelName = modelAnnotation.value();
                    String packageName = "";
                    if (StringUtils.hasText((String)modelName)) {
                        int lastDot = modelName.lastIndexOf(46);
                        if (lastDot != -1) {
                            fileName = modelName.substring(lastDot + 1);
                            int firstDot = modelName.indexOf(46);
                            if (firstDot < lastDot) {
                                packageName = modelName.substring(firstDot + 1, lastDot);
                            }
                        } else {
                            fileName = modelName;
                        }
                    } else {
                        fileName = typeElement2.getSimpleName().toString();
                    }
                    if (createBaseAndSubclass) {
                        code = code.replaceFirst("(Ext.define\\([\"'].+?)([\"'],)", "$1Base$2");
                        fo = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, packageName, fileName + "Base.js", new Element[0]);
                        os = fo.openOutputStream();
                        os.write(code.getBytes(ModelGenerator.UTF8_CHARSET));
                        os.close();
                        try {
                            fo = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, packageName, fileName + ".js");
                            InputStream is = fo.openInputStream();
                            is.close();
                        }
                        catch (FileNotFoundException e) {
                            String subClassCode = ModelAnnotationProcessor.generateSubclassCode(modelClass, outputConfig);
                            fo = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, packageName, fileName + ".js", new Element[0]);
                            os = fo.openOutputStream();
                            os.write(subClassCode.getBytes(ModelGenerator.UTF8_CHARSET));
                            os.close();
                        }
                        continue;
                    }
                    fo = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, packageName, fileName + ".js", new Element[0]);
                    os = fo.openOutputStream();
                    os.write(code.getBytes(ModelGenerator.UTF8_CHARSET));
                    os.close();
                }
                catch (ClassNotFoundException e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
                }
                catch (IOException e) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, e.getMessage());
                }
            }
        }
        return false;
    }

    private static String generateSubclassCode(Class<?> clazz, OutputConfig outputConfig) {
        String configObjectString;
        Model modelAnnotation = clazz.getAnnotation(Model.class);
        String name = modelAnnotation != null && StringUtils.hasText((String)modelAnnotation.value()) ? modelAnnotation.value() : clazz.getName();
        LinkedHashMap<String, String> modelObject = new LinkedHashMap<String, String>();
        modelObject.put("extend", name + "Base");
        StringBuilder sb = new StringBuilder(100);
        sb.append("Ext.define(\"").append(name).append("\",");
        if (outputConfig.isDebug()) {
            sb.append("\n");
        }
        try {
            configObjectString = outputConfig.isDebug() ? mapper.writerWithDefaultPrettyPrinter().writeValueAsString(modelObject) : mapper.writeValueAsString(modelObject);
        }
        catch (JsonGenerationException e) {
            throw new RuntimeException(e);
        }
        catch (JsonMappingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        sb.append(configObjectString);
        sb.append(");");
        if (outputConfig.isUseSingleQuotes()) {
            return sb.toString().replace('\"', '\'');
        }
        return sb.toString();
    }

    static {
        mapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, false);
    }
}

