/**
 * Copyright 2013-2014 Ralph Schaer <ralphschaer@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package ch.rasc.extclassgenerator;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation that configures validation for a model
 */
@Target({ ElementType.FIELD, ElementType.METHOD, ElementType.TYPE })
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface ModelValidation {

	/**
	 * Name of the property. Must be present when annotation is located on a
	 * type. Has to correspond with a {@link ModelField#value()} entry.
	 */
	String propertyName() default "";

	ModelValidationType value();

	ModelValidationParameter[] parameters() default {};

	/**
	 * inclusion or exclusion list, valid only for
	 * {@link ModelValidationType#Exclusion} or
	 * {@link ModelValidationType#Inclusion}. Confer to <a href=
	 * "http://docs.sencha.com/ext-js/4-2/#!/api/Ext.data.validations-method-exclusion"
	 * >documentation</a>
	 */
	String[] exclusionOrInclusionList() default {};

}
